/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.utils;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Logger;

public class PropertyManager {
    private static final Logger LOG = Logger.getLogger(PropertyManager.class.getName());
    private static Properties properties;
    private static final String PROPERTIES_PATH;
    public static final String PROPERTY_SYSTEM_PREFIX = "chat.";
    public static final String PROPERTY_SERVICES_IMPLEMENTATION = "servicesImplementation";
    public static final String PROPERTY_SERVER_TYPE = "dbServerType";
    public static final String PROPERTY_SERVER_HOST = "dbServerHost";
    public static final String PROPERTY_SERVER_PORT = "dbServerPort";
    public static final String PROPERTY_DB_NAME = "dbName";
    public static final String PROPERTY_DB_AUTHENTICATION = "dbAuthentication";
    public static final String PROPERTY_DB_USER = "dbUser";
    public static final String PROPERTY_DB_PASSWORD = "dbPassword";
    public static final String PROPERTY_CHAT_SERVER_BASE = "chatServerBase";
    public static final String PROPERTY_CHAT_SERVER_URL = "chatServerUrl";
    public static final String PROPERTY_CHAT_PORTAL_PAGE = "chatPortalPage";
    public static final String PROPERTY_INTERVAL_CHAT = "chatIntervalChat";
    public static final String PROPERTY_INTERVAL_SESSION = "chatIntervalSession";
    public static final String PROPERTY_INTERVAL_STATUS = "chatIntervalStatus";
    public static final String PROPERTY_INTERVAL_NOTIF = "chatIntervalNotif";
    public static final String PROPERTY_INTERVAL_USERS = "chatIntervalUsers";
    public static final String PROPERTY_PASSPHRASE = "chatPassPhrase";
    public static final String PROPERTY_CRON_NOTIF_CLEANUP = "chatCronNotifCleanup";
    public static final String PROPERTY_PUBLIC_MODE = "publicMode";
    public static final String PROPERTY_PUBLIC_ADMIN_GROUP = "publicAdminGroup";
    public static final String PROPERTY_TEAM_ADMIN_GROUP = "teamAdminGroup";
    public static final String PROPERTY_TOKEN_VALIDITY = "chatTokenValidity";
    public static final String PROPERTY_READ_DAYS = "chatReadDays";
    public static final String PROPERTY_READ_TOTAL_JSON = "chatReadTotalJson";
    public static final String PROPERTY_READ_TOTAL_TXT = "chatReadTotalTxt";
    public static final String PROPERTY_SERVER_TYPE_EMBED = "embed";
    public static final String PROPERTY_SERVER_TYPE_MONGO = "mongo";
    public static final String PROPERTY_SERVICE_IMPL_MONGO = "mongo";
    public static final String PROPERTY_SERVICE_IMPL_JCR = "jcr";
    public static final String PROPERTY_MAIL_HOST = "mailHost";
    public static final String PROPERTY_MAIL_PORT = "mailPort";
    public static final String PROPERTY_MAIL_USER = "mailUser";
    public static final String PROPERTY_MAIL_PASSWORD = "mailPassword";

    public static String getProperty(String key) {
        String value = (String)PropertyManager.properties().get(key);
        return value;
    }

    private static synchronized Properties properties() {
        if (properties == null) {
            properties = new Properties();
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(PROPERTIES_PATH);
                properties.load(stream);
                ((InputStream)stream).close();
            }
            catch (Exception e) {
                LOG.warning(e.getMessage());
            }
            PropertyManager.overridePropertyIfNotSet(PROPERTY_SERVICES_IMPLEMENTATION, "mongo");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_SERVER_TYPE, "mongo");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_SERVER_HOST, "localhost");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_SERVER_PORT, "27017");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_DB_NAME, "chat");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_DB_AUTHENTICATION, "false");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_DB_USER, "");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_DB_PASSWORD, "");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_CHAT_SERVER_BASE, "");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_CHAT_SERVER_URL, "/chatServer");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_CHAT_PORTAL_PAGE, "/portal/intranet/chat");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_INTERVAL_CHAT, "3000");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_INTERVAL_SESSION, "60000");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_INTERVAL_STATUS, "15000");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_INTERVAL_NOTIF, "3000");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_INTERVAL_USERS, "5000");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_PASSPHRASE, "chat");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_CRON_NOTIF_CLEANUP, "0 0/60 * * * ?");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_PUBLIC_MODE, "false");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_PUBLIC_ADMIN_GROUP, "/platform/administrators");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_TEAM_ADMIN_GROUP, "/platform/users");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_TOKEN_VALIDITY, "25000");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_READ_DAYS, "30");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_READ_TOTAL_JSON, "200");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_READ_TOTAL_TXT, "2000");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_MAIL_HOST, "smtp.gmail.com");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_MAIL_PORT, "587");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_MAIL_USER, "exo");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_MAIL_PASSWORD, "");
        }
        return properties;
    }

    private static void overridePropertyIfNotSet(String key, String value) {
        if (PropertyManager.properties().getProperty(key) == null) {
            PropertyManager.properties().setProperty(key, value);
        }
        if (System.getProperty(PROPERTY_SYSTEM_PREFIX + key) != null) {
            PropertyManager.properties().setProperty(key, System.getProperty(PROPERTY_SYSTEM_PREFIX + key));
        }
    }

    public static void overrideProperty(String key, String value) {
        PropertyManager.properties().setProperty(key, value);
    }

    static {
        PROPERTIES_PATH = System.getProperty("catalina.base") + "/conf/chat.properties";
    }
}

