/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.services.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.WriteConcern;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.bson.types.ObjectId;
import org.exoplatform.chat.listener.ConnectionManager;
import org.exoplatform.chat.model.RoomBean;
import org.exoplatform.chat.model.RoomsBean;
import org.exoplatform.chat.model.SpaceBean;
import org.exoplatform.chat.model.UserBean;
import org.exoplatform.chat.services.ChatService;
import org.exoplatform.chat.services.NotificationService;
import org.exoplatform.chat.services.TokenService;
import org.exoplatform.chat.services.UserService;
import org.exoplatform.chat.utils.ChatUtils;
import org.exoplatform.chat.utils.PropertyManager;

@Named(value="chatService")
@ApplicationScoped
public class ChatServiceImpl
implements ChatService {
    private static final Logger LOG = Logger.getLogger("ChatService");
    private long readMillis;
    private int readTotalJson;
    private int readTotalTxt;

    public ChatServiceImpl() {
        long readDays = Long.parseLong(PropertyManager.getProperty("chatReadDays"));
        this.readMillis = readDays * 24L * 60L * 60L * 1000L;
        this.readTotalJson = Integer.parseInt(PropertyManager.getProperty("chatReadTotalJson"));
        this.readTotalTxt = Integer.parseInt(PropertyManager.getProperty("chatReadTotalTxt"));
    }

    private DB db() {
        return ConnectionManager.getInstance().getDB();
    }

    @Override
    public void write(String message, String user, String room, String isSystem) {
        this.write(message, user, room, isSystem, null);
    }

    @Override
    public void write(String message, String user, String room, String isSystem, String options) {
        DBCollection coll = this.db().getCollection("room_" + room);
        message = StringUtils.chomp((String)message);
        message = message.replaceAll("&", "&#38");
        message = message.replaceAll("<", "&lt;");
        message = message.replaceAll(">", "&gt;");
        message = message.replaceAll("\"", "&quot;");
        message = message.replaceAll("\n", "<br/>");
        message = message.replaceAll("\\\\", "&#92");
        message = message.replaceAll("\t", "  ");
        BasicDBObject doc = new BasicDBObject();
        doc.put("user", (Object)user);
        doc.put("message", (Object)message);
        doc.put("time", (Object)new Date());
        doc.put("timestamp", (Object)System.currentTimeMillis());
        doc.put("isSystem", (Object)isSystem);
        if (options != null) {
            options = options.replaceAll("<", "&lt;");
            options = options.replaceAll(">", "&gt;");
            doc.put("options", (Object)options);
        }
        coll.insert(new DBObject[]{doc});
        this.updateRoomTimestamp(room);
    }

    @Override
    public void delete(String room, String user, String messageId) {
        DBCollection coll = this.db().getCollection("room_" + room);
        BasicDBObject query = new BasicDBObject();
        query.put("_id", (Object)new ObjectId(messageId));
        query.put("user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        if (cursor.hasNext()) {
            DBObject dbo = cursor.next();
            dbo.put("message", (Object)"DELETED");
            dbo.put("type", (Object)"DELETED");
            dbo.put("lastUpdatedTimestamp", (Object)System.currentTimeMillis());
            coll.save(dbo, WriteConcern.NONE);
        }
    }

    @Override
    public void edit(String room, String user, String messageId, String message) {
        DBCollection coll = this.db().getCollection("room_" + room);
        message = StringUtils.chomp((String)message);
        message = message.replaceAll("&", "&#38");
        message = message.replaceAll("<", "&lt;");
        message = message.replaceAll(">", "&gt;");
        message = message.replaceAll("\"", "&quot;");
        message = message.replaceAll("\n", "<br/>");
        message = message.replaceAll("\\\\", "&#92");
        BasicDBObject query = new BasicDBObject();
        query.put("_id", (Object)new ObjectId(messageId));
        query.put("user", (Object)user);
        DBCursor cursor = coll.find((DBObject)query);
        if (cursor.hasNext()) {
            DBObject dbo = cursor.next();
            dbo.put("message", (Object)message);
            dbo.put("type", (Object)"EDITED");
            dbo.put("lastUpdatedTimestamp", (Object)System.currentTimeMillis());
            coll.save(dbo, WriteConcern.NONE);
        }
    }

    @Override
    public String read(String room, UserService userService) {
        return this.read(room, userService, false, null, null);
    }

    @Override
    public String read(String room, UserService userService, boolean isTextOnly, Long fromTimestamp) {
        return this.read(room, userService, isTextOnly, fromTimestamp, null);
    }

    @Override
    public String read(String room, UserService userService, boolean isTextOnly, Long fromTimestamp, Long toTimestamp) {
        StringBuilder sb = new StringBuilder();
        SimpleDateFormat formatter = new SimpleDateFormat("hh:mm aaa");
        SimpleDateFormat formatterDate = new SimpleDateFormat("dd/MM/yyyy hh:mm aaa");
        Calendar calendar = Calendar.getInstance();
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date today = calendar.getTime();
        DBCollection coll = this.db().getCollection("room_" + room);
        BasicDBObject query = new BasicDBObject();
        long from = fromTimestamp != null ? fromTimestamp : System.currentTimeMillis() - this.readMillis;
        BasicDBObject tsobj = new BasicDBObject("$gt", (Object)from);
        if (toTimestamp != null) {
            tsobj.append("$lt", (Object)toTimestamp);
        }
        query.put("timestamp", (Object)tsobj);
        BasicDBObject sort = new BasicDBObject();
        sort.put("timestamp", (Object)-1);
        int limit = isTextOnly ? this.readTotalTxt : this.readTotalJson;
        DBCursor cursor = coll.find((DBObject)query).sort((DBObject)sort).limit(limit);
        if (!cursor.hasNext()) {
            if (isTextOnly) {
                sb.append("no messages");
            } else {
                sb.append("{\"messages\": []}");
            }
        } else {
            HashMap<String, UserBean> users2 = new HashMap<String, UserBean>();
            boolean first = true;
            while (cursor.hasNext()) {
                DBObject dbo = cursor.next();
                String timestamp = dbo.get("timestamp").toString();
                if (first && !isTextOnly) {
                    sb.append("{\"room\": \"").append(room).append("\",");
                    sb.append("\"timestamp\": \"").append(timestamp).append("\",");
                    sb.append("\"messages\": [");
                }
                String user = dbo.get("user").toString();
                String msgId = dbo.get("_id").toString();
                UserBean userBean = (UserBean)users2.get(user);
                if (userBean == null) {
                    userBean = userService.getUser(user);
                    users2.put(user, userBean);
                }
                String fullname = userBean.getFullname();
                String email = userBean.getEmail();
                String date = "";
                try {
                    if (dbo.containsField("time")) {
                        Date date1 = (Date)dbo.get("time");
                        date = date1.before(today) || isTextOnly ? formatterDate.format(date1) : formatter.format(date1);
                    }
                }
                catch (Exception e) {
                    LOG.info("Message Date Format Error : " + e.getMessage());
                }
                if (isTextOnly) {
                    StringBuilder line = new StringBuilder();
                    line.append("[").append(date).append("] ");
                    String message = dbo.get("message").toString();
                    if ("DELETED".equals(message)) {
                        message = "DELETED";
                    }
                    if ("true".equals(dbo.get("isSystem"))) {
                        line.append("System Message: ");
                        if (message.endsWith("<br/>")) {
                            message = message.substring(0, message.length() - 5);
                        }
                        line.append(message).append("\n");
                    } else {
                        line.append(fullname).append(": ");
                        message = message.replaceAll("<br/>", "\n");
                        line.append(message).append("\n");
                    }
                    sb.insert(0, line);
                } else {
                    if (!first) {
                        sb.append(",");
                    }
                    sb.append("{\"id\": \"").append(msgId).append("\",");
                    sb.append("\"timestamp\": ").append(timestamp).append(",");
                    if (dbo.containsField("lastUpdatedTimestamp")) {
                        sb.append("\"lastUpdatedTimestamp\": ").append(dbo.get("lastUpdatedTimestamp").toString()).append(",");
                    }
                    sb.append("\"user\": \"").append(user).append("\",");
                    sb.append("\"fullname\": \"").append(fullname).append("\",");
                    sb.append("\"email\": \"").append(email).append("\",");
                    sb.append("\"date\": \"").append(date).append("\",");
                    sb.append("\"message\": \"").append(StringEscapeUtils.escapeJson((String)dbo.get("message").toString())).append("\",");
                    if (dbo.containsField("options")) {
                        String options = dbo.get("options").toString();
                        if (options.startsWith("{")) {
                            sb.append("\"options\": ").append(options).append(",");
                        } else {
                            sb.append("\"options\": \"").append(options).append("\",");
                        }
                    } else {
                        sb.append("\"options\": \"\",");
                    }
                    sb.append("\"type\": \"").append(dbo.get("type")).append("\",");
                    sb.append("\"isSystem\": \"").append(dbo.get("isSystem")).append("\"}");
                }
                first = false;
            }
            if (!isTextOnly) {
                sb.append("]}");
            }
        }
        return sb.toString();
    }

    private void updateRoomTimestamp(String room) {
        DBCollection coll = this.db().getCollection("room_rooms");
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put("_id", (Object)room);
        DBCursor cursor = coll.find((DBObject)basicDBObject);
        if (cursor.hasNext()) {
            DBObject dbo = cursor.next();
            dbo.put("timestamp", (Object)System.currentTimeMillis());
            coll.save(dbo, WriteConcern.NONE);
        }
    }

    private void ensureIndexInRoom(String room) {
        DBCollection coll = this.db().getCollection("room_" + room);
        BasicDBObject doc = new BasicDBObject();
        doc.put("timestamp", (Object)System.currentTimeMillis());
        coll.insert(new DBObject[]{doc});
        ConnectionManager.getInstance().ensureIndexesInRoom(room);
        coll.remove((DBObject)doc);
    }

    @Override
    public String getSpaceRoom(String space) {
        String room = ChatUtils.getRoomId(space);
        DBCollection coll = this.db().getCollection("room_rooms");
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put("_id", (Object)room);
        DBCursor cursor = coll.find((DBObject)basicDBObject);
        if (!cursor.hasNext()) {
            try {
                basicDBObject.put("space", (Object)space);
                basicDBObject.put("type", (Object)"s");
                coll.insert(new DBObject[]{basicDBObject});
                this.ensureIndexInRoom(room);
            }
            catch (MongoException me) {
                LOG.warning(me.getCode() + " : " + room + " : " + me.getMessage());
            }
        }
        return room;
    }

    @Override
    public String getSpaceRoomByName(String name) {
        String room = null;
        DBCollection coll = this.db().getCollection("room_rooms");
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put("shortName", (Object)name);
        DBCursor cursor = coll.find((DBObject)basicDBObject);
        if (cursor.hasNext()) {
            DBObject doc = cursor.next();
            room = doc.get("_id").toString();
        }
        return room;
    }

    @Override
    public String getTeamRoom(String team, String user) {
        String room = ChatUtils.getRoomId(team, user);
        DBCollection coll = this.db().getCollection("room_rooms");
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put("_id", (Object)room);
        DBCursor cursor = coll.find((DBObject)basicDBObject);
        if (!cursor.hasNext()) {
            try {
                basicDBObject.put("team", (Object)team);
                basicDBObject.put("user", (Object)user);
                basicDBObject.put("type", (Object)"t");
                coll.insert(new DBObject[]{basicDBObject});
                this.ensureIndexInRoom(room);
            }
            catch (MongoException me) {
                LOG.warning(me.getCode() + " : " + room + " : " + me.getMessage());
            }
        }
        return room;
    }

    @Override
    public String getExternalRoom(String identifier) {
        String room = ChatUtils.getExternalRoomId(identifier);
        DBCollection coll = this.db().getCollection("room_rooms");
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put("_id", (Object)room);
        DBCursor cursor = coll.find((DBObject)basicDBObject);
        if (!cursor.hasNext()) {
            try {
                basicDBObject.put("identifier", (Object)identifier);
                basicDBObject.put("type", (Object)"e");
                coll.insert(new DBObject[]{basicDBObject});
                this.ensureIndexInRoom(room);
            }
            catch (MongoException me) {
                LOG.warning(me.getCode() + " : " + room + " : " + me.getMessage());
            }
        }
        return room;
    }

    @Override
    public String getTeamCreator(String room) {
        if (room.indexOf("team-") == 0) {
            room = room.substring("team-".length());
        }
        DBCollection coll = this.db().getCollection("room_rooms");
        String creator = "";
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put("_id", (Object)room);
        DBCursor cursor = coll.find((DBObject)basicDBObject);
        if (cursor.hasNext()) {
            try {
                DBObject dbo = cursor.next();
                creator = dbo.get("user").toString();
            }
            catch (MongoException me) {
                LOG.warning(me.getCode() + " : " + room + " : " + me.getMessage());
            }
        }
        return creator;
    }

    @Override
    public void setRoomName(String room, String name) {
        DBCollection coll = this.db().getCollection("room_rooms");
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put("_id", (Object)room);
        DBCursor cursor = coll.find((DBObject)basicDBObject);
        if (cursor.hasNext()) {
            DBObject dbo = cursor.next();
            dbo.put("team", (Object)name);
            coll.save(dbo, WriteConcern.NONE);
        }
    }

    @Override
    public String getRoom(List<String> users2) {
        Collections.sort(users2);
        String room = ChatUtils.getRoomId(users2);
        DBCollection coll = this.db().getCollection("room_rooms");
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put("_id", (Object)room);
        DBCursor cursor = coll.find((DBObject)basicDBObject);
        if (!cursor.hasNext()) {
            try {
                basicDBObject.put("users", users2);
                basicDBObject.put("type", (Object)"u");
                coll.insert(new DBObject[]{basicDBObject});
                this.ensureIndexInRoom(room);
            }
            catch (MongoException me) {
                LOG.warning(me.getCode() + " : " + room + " : " + me.getMessage());
            }
        }
        return room;
    }

    @Override
    public String getTypeRoomChat(String roomId) {
        DBCollection coll = this.db().getCollection("room_rooms");
        BasicDBObject query = new BasicDBObject();
        query.put("_id", (Object)roomId);
        DBCursor cursor = coll.find((DBObject)query);
        Object roomType = null;
        while (cursor.hasNext()) {
            DBObject doc = cursor.next();
            roomType = doc.get("type");
        }
        return roomType.toString();
    }

    @Override
    public List<RoomBean> getExistingRooms(String user, boolean withPublic, boolean isAdmin, NotificationService notificationService, TokenService tokenService) {
        ArrayList<RoomBean> rooms = new ArrayList<RoomBean>();
        String roomId = null;
        DBCollection coll = this.db().getCollection("room_rooms");
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put("users", (Object)user);
        DBCursor cursor = coll.find((DBObject)basicDBObject);
        while (cursor.hasNext()) {
            DBObject dbo = cursor.next();
            roomId = dbo.get("_id").toString();
            long timestamp = -1L;
            if (dbo.containsField("timestamp")) {
                timestamp = (Long)dbo.get("timestamp");
            }
            List users2 = (List)dbo.get("users");
            users2.remove(user);
            if (users2.size() <= 0 || user.equals(users2.get(0))) continue;
            String targetUser = (String)users2.get(0);
            boolean isDemoUser = tokenService.isDemoUser(targetUser);
            if (isAdmin && (!isAdmin || (withPublic || isDemoUser) && (!withPublic || !isDemoUser))) continue;
            RoomBean roomBean = new RoomBean();
            roomBean.setRoom(roomId);
            roomBean.setUnreadTotal(notificationService.getUnreadNotificationsTotal(user, "chat", "room", roomId));
            roomBean.setUser((String)users2.get(0));
            roomBean.setTimestamp(timestamp);
            rooms.add(roomBean);
        }
        return rooms;
    }

    @Override
    public RoomsBean getRooms(String user, String filter, boolean withUsers, boolean withSpaces, boolean withPublic, boolean withOffline, boolean isAdmin, NotificationService notificationService, UserService userService, TokenService tokenService) {
        return this.getRooms(user, filter, withUsers, withSpaces, withPublic, withOffline, isAdmin, 0, notificationService, userService, tokenService);
    }

    @Override
    public RoomsBean getRooms(String user, String filter, boolean withUsers, boolean withSpaces, boolean withPublic, boolean withOffline, boolean isAdmin, int limit, NotificationService notificationService, UserService userService, TokenService tokenService) {
        List<Object> rooms = new ArrayList();
        ArrayList<RoomBean> roomsOffline = new ArrayList<RoomBean>();
        UserBean userBean = userService.getUser(user, true);
        int unreadOffline = 0;
        int unreadOnline = 0;
        int unreadSpaces = 0;
        int unreadTeams = 0;
        HashMap<String, UserBean> availableUsers = tokenService.getActiveUsersFilterBy(user, withUsers, withPublic, isAdmin, limit);
        rooms = this.getExistingRooms(user, withPublic, isAdmin, notificationService, tokenService);
        if (isAdmin) {
            rooms.addAll(this.getExistingRooms("__support_", withPublic, isAdmin, notificationService, tokenService));
        }
        for (RoomBean roomBean : rooms) {
            UserBean targetUserBean;
            String targetUser = roomBean.getUser();
            roomBean.setFavorite(userBean.isFavorite(targetUser));
            if (availableUsers.keySet().contains(targetUser)) {
                targetUserBean = availableUsers.get(targetUser);
                roomBean.setFullname(targetUserBean.getFullname());
                roomBean.setStatus(targetUserBean.getStatus());
                roomBean.setAvailableUser(true);
                availableUsers.remove(targetUser);
                if (roomBean.getUnreadTotal() <= 0) continue;
                unreadOnline += roomBean.getUnreadTotal();
                continue;
            }
            targetUserBean = userService.getUser(targetUser);
            roomBean.setFullname(targetUserBean.getFullname());
            roomBean.setAvailableUser(false);
            if (!withOffline) {
                roomsOffline.add(roomBean);
            }
            if (roomBean.getUnreadTotal() <= 0) continue;
            unreadOffline += roomBean.getUnreadTotal();
        }
        if (withUsers) {
            if (!withOffline) {
                for (RoomBean roomBean : roomsOffline) {
                    rooms.remove(roomBean);
                }
            }
            for (UserBean userBean2 : availableUsers.values()) {
                RoomBean roomBean = new RoomBean();
                roomBean.setUser(userBean2.getName());
                roomBean.setFullname(userBean2.getFullname());
                roomBean.setStatus(userBean2.getStatus());
                roomBean.setAvailableUser(true);
                roomBean.setFavorite(userBean.isFavorite(roomBean.getUser()));
                String status = roomBean.getStatus();
                if (!withOffline && (withOffline || "invisible".equals(roomBean.getStatus()) || "offline".equals(roomBean.getStatus()))) continue;
                rooms.add(roomBean);
            }
        } else {
            rooms = new ArrayList();
        }
        List<SpaceBean> spaces = userService.getSpaces(user);
        for (SpaceBean space : spaces) {
            RoomBean roomBeanS = new RoomBean();
            roomBeanS.setUser("space-" + space.getRoom());
            roomBeanS.setRoom(space.getRoom());
            roomBeanS.setFullname(space.getDisplayName());
            roomBeanS.setStatus("space");
            roomBeanS.setTimestamp(space.getTimestamp());
            roomBeanS.setAvailableUser(true);
            roomBeanS.setSpace(true);
            roomBeanS.setUnreadTotal(notificationService.getUnreadNotificationsTotal(user, "chat", "room", this.getSpaceRoom("space-" + space.getRoom())));
            if (roomBeanS.getUnreadTotal() > 0) {
                unreadSpaces += roomBeanS.getUnreadTotal();
            }
            roomBeanS.setFavorite(userBean.isFavorite(roomBeanS.getUser()));
            if (!withSpaces) continue;
            rooms.add(roomBeanS);
        }
        List<RoomBean> list = userService.getTeams(user);
        for (RoomBean team : list) {
            RoomBean roomBean = new RoomBean();
            roomBean.setUser("team-" + team.getRoom());
            roomBean.setRoom(team.getRoom());
            roomBean.setFullname(team.getFullname());
            roomBean.setStatus("team");
            roomBean.setTimestamp(team.getTimestamp());
            roomBean.setAvailableUser(true);
            roomBean.setSpace(false);
            roomBean.setTeam(true);
            roomBean.setUnreadTotal(notificationService.getUnreadNotificationsTotal(user, "chat", "room", team.getRoom()));
            if (roomBean.getUnreadTotal() > 0) {
                unreadTeams += roomBean.getUnreadTotal();
            }
            roomBean.setFavorite(userBean.isFavorite(roomBean.getUser()));
            if (!withSpaces) continue;
            rooms.add(roomBean);
        }
        ArrayList<RoomBean> finalRooms = new ArrayList();
        if (filter != null) {
            for (RoomBean roomBean : rooms) {
                String targetUser = roomBean.getFullname();
                if (!this.filter(targetUser, filter)) continue;
                finalRooms.add(roomBean);
            }
        } else {
            finalRooms = rooms;
        }
        RoomsBean roomsBean = new RoomsBean();
        roomsBean.setRooms(finalRooms);
        roomsBean.setUnreadOffline(unreadOffline);
        roomsBean.setUnreadOnline(unreadOnline);
        roomsBean.setUnreadSpaces(unreadSpaces);
        roomsBean.setUnreadTeams(unreadTeams);
        return roomsBean;
    }

    private boolean filter(String user, String filter) {
        if (user == null || filter == null || "".equals(filter)) {
            return true;
        }
        String[] args = filter.toLowerCase().split(" ");
        String s = user.toLowerCase();
        for (String arg : args) {
            int ind = s.indexOf(arg);
            if (ind == -1) {
                return false;
            }
            s = s.substring(ind);
        }
        return true;
    }

    @Override
    public int getNumberOfRooms() {
        DBCollection coll = this.db().getCollection("room_rooms");
        BasicDBObject query = new BasicDBObject();
        DBCursor cursor = coll.find((DBObject)query);
        return cursor.count();
    }

    @Override
    public int getNumberOfMessages() {
        int nb = 0;
        DBCollection coll = this.db().getCollection("room_rooms");
        BasicDBObject query = new BasicDBObject();
        DBCursor cursor = coll.find((DBObject)query);
        while (cursor.hasNext()) {
            DBObject dbo = cursor.next();
            String roomId = dbo.get("_id").toString();
            DBCollection collr = this.db().getCollection("room_" + roomId);
            BasicDBObject queryr = new BasicDBObject();
            DBCursor cursorr = collr.find((DBObject)queryr);
            nb += cursorr.count();
        }
        return nb;
    }
}

