/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.model;

import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class NotificationBean {
    private String user;
    private String from;
    private String fromFullName = "";
    private String type;
    private String content;
    private String link;
    private String category;
    private String categoryId;
    private String options = "";
    private String roomDisplayName = "";
    private Long timestamp;

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public String getOptions() {
        return this.options;
    }

    public void setOptions(String options) {
        this.options = options;
    }

    public String getRoomDisplayName() {
        return this.roomDisplayName;
    }

    public void setRoomDisplayName(String roomDisplayName) {
        this.roomDisplayName = roomDisplayName;
    }

    public String getFromFullName() {
        return this.fromFullName;
    }

    public void setFromFullName(String fromFullName) {
        this.fromFullName = fromFullName;
    }

    public String toJSON() {
        JSONObject obj = new JSONObject();
        try {
            obj.put("user", (Object)this.getUser());
            obj.put("type", (Object)this.getType());
            obj.put("from", (Object)this.getFrom());
            obj.put("fromFullName", (Object)this.getFromFullName());
            obj.put("category", (Object)this.getCategory());
            obj.put("categoryId", (Object)this.getCategoryId());
            obj.put("content", (Object)this.getContent().replaceAll("\n", "<br/>"));
            obj.put("link", (Object)this.getLink());
            String options = this.getOptions();
            if (StringUtils.isNotEmpty((CharSequence)this.getOptions())) {
                if (options.startsWith("{")) {
                    JSONObject optionsJson = new JSONObject(options);
                    obj.put("options", (Object)optionsJson);
                } else {
                    obj.put("options", (Object)options);
                }
            } else {
                obj.put("options", (Object)"");
            }
            obj.put("roomDisplayName", (Object)StringEscapeUtils.escapeHtml4((String)this.getRoomDisplayName()));
            obj.put("timestamp", (Object)this.getTimestamp());
        }
        catch (JSONException e) {
            return obj.toString();
        }
        return obj.toString();
    }

    public static String notificationstoJSON(List<NotificationBean> notificationBeans) {
        StringBuilder sb = new StringBuilder();
        sb.append("\"notifications\": [");
        boolean first = true;
        for (NotificationBean notificationBean : notificationBeans) {
            if (!first) {
                sb.append(",");
            } else {
                first = false;
            }
            sb.append(notificationBean.toJSON());
        }
        sb.append("]");
        return sb.toString();
    }
}

