/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.services;

import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import org.exoplatform.chat.listener.ConnectionManager;
import org.exoplatform.chat.services.mongodb.NotificationCleanupJob;
import org.exoplatform.chat.utils.PropertyManager;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

@Named(value="schedulerService")
@ApplicationScoped
public class SchedulerService {
    private static final Logger LOG = Logger.getLogger("SchedulerService");
    private static Scheduler sched;

    public SchedulerService() {
        LOG.info("Start Scheduler");
        this.startScheduler();
    }

    private void startScheduler() {
        StdSchedulerFactory sf = new StdSchedulerFactory();
        try {
            sched = sf.getScheduler();
            JobDetail notificationCleanupJob = JobBuilder.newJob(NotificationCleanupJob.class).withIdentity("notificationCleanupJobMongo", "chatServer").build();
            CronTrigger notificationTrigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity("notificationTrigger", "chatServer").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)PropertyManager.getProperty("chatCronNotifCleanup"))).build();
            sched.scheduleJob(notificationCleanupJob, (Trigger)notificationTrigger);
            sched.start();
            LOG.info("Scheduler Started");
            if ("mongo".equals(PropertyManager.getProperty("servicesImplementation"))) {
                try {
                    ConnectionManager.getInstance().ensureIndexes();
                    LOG.info("MongoDB Indexes Up to Date");
                }
                catch (Exception e) {
                    LOG.severe("MongoDB Indexes couldn't be created during startup. Chat Extension may be unstable!");
                }
            }
        }
        catch (SchedulerException e) {
            LOG.warning(e.getMessage());
        }
    }

    public void shutdown() throws SchedulerException {
        sched.shutdown();
    }
}

