/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.services.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.WriteConcern;
import java.util.HashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.chat.listener.ConnectionManager;
import org.exoplatform.chat.model.UserBean;
import org.exoplatform.chat.services.TokenService;
import org.exoplatform.chat.utils.MessageDigester;
import org.exoplatform.chat.utils.PropertyManager;

@Named(value="tokenService")
@ApplicationScoped
public class TokenServiceImpl
implements TokenService {
    private int validity_ = -1;

    private DB db(String dbName) {
        if (StringUtils.isEmpty((CharSequence)dbName)) {
            return ConnectionManager.getInstance().getDB();
        }
        return ConnectionManager.getInstance().getDB(dbName);
    }

    @Override
    public String getToken(String user) {
        String passphrase = PropertyManager.getProperty("chatPassPhrase");
        String in = user + passphrase;
        String token = MessageDigester.getHash(in);
        return token;
    }

    @Override
    public boolean hasUserWithToken(String user, String token, String dbName) {
        DBCollection coll = this.db(dbName).getCollection("users");
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"user", (Object)user);
        query.put((Object)"token", (Object)token);
        DBCursor cursor = coll.find((DBObject)query);
        return cursor.hasNext();
    }

    @Override
    public void addUser(String user, String token, String dbName) {
        if (!this.hasUserWithToken(user, token, dbName)) {
            DBCollection coll = this.db(dbName).getCollection("users");
            BasicDBObject query = new BasicDBObject();
            query.put((Object)"user", (Object)user);
            DBCursor cursor = coll.find((DBObject)query);
            if (cursor.hasNext()) {
                DBObject doc = cursor.next();
                doc.put("token", (Object)token);
                doc.put("validity", (Object)System.currentTimeMillis());
                doc.put("isDemoUser", (Object)user.startsWith("__anonim_"));
                coll.save(doc, WriteConcern.SAFE);
            } else {
                BasicDBObject doc = new BasicDBObject();
                doc.put((Object)"_id", (Object)user);
                doc.put((Object)"user", (Object)user);
                doc.put((Object)"token", (Object)token);
                doc.put((Object)"validity", (Object)System.currentTimeMillis());
                doc.put((Object)"isDemoUser", (Object)user.startsWith("__anonim_"));
                coll.insert(new DBObject[]{doc});
            }
        }
    }

    @Override
    public void updateValidity(String user, String token, String dbName) {
        DBCollection coll = this.db(dbName).getCollection("users");
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"user", (Object)user);
        query.put((Object)"token", (Object)token);
        DBCursor cursor = coll.find((DBObject)query);
        while (cursor.hasNext()) {
            DBObject doc = cursor.next();
            doc.put("validity", (Object)System.currentTimeMillis());
            coll.save(doc, WriteConcern.SAFE);
        }
    }

    @Override
    public HashMap<String, UserBean> getActiveUsersFilterBy(String user, String dbName, boolean withUsers, boolean withPublic, boolean isAdmin) {
        return this.getActiveUsersFilterBy(user, dbName, withUsers, withPublic, isAdmin, 0);
    }

    @Override
    public HashMap<String, UserBean> getActiveUsersFilterBy(String user, String dbName, boolean withUsers, boolean withPublic, boolean isAdmin, int limit) {
        HashMap<String, UserBean> users2 = new HashMap<String, UserBean>();
        DBCollection coll = this.db(dbName).getCollection("users");
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"validity", (Object)new BasicDBObject("$gt", (Object)(System.currentTimeMillis() - (long)this.getValidity())));
        if (isAdmin) {
            if (withPublic && !withUsers) {
                query.put((Object)"isDemoUser", (Object)true);
            } else if (!withPublic && withUsers) {
                query.put((Object)"isDemoUser", (Object)false);
            }
        } else {
            query.put((Object)"isDemoUser", (Object)user.startsWith("__anonim_"));
        }
        if (limit < 0) {
            limit = 0;
        }
        DBCursor cursor = coll.find((DBObject)query).limit(limit);
        while (cursor.hasNext()) {
            DBObject doc = cursor.next();
            String target = doc.get("user").toString();
            if (user.equals(target)) continue;
            UserBean userBean = new UserBean();
            userBean.setName(target);
            if (doc.get("fullname") != null) {
                userBean.setFullname(doc.get("fullname").toString());
            }
            if (doc.get("status") != null) {
                userBean.setStatus(doc.get("status").toString());
            }
            users2.put(target, userBean);
        }
        return users2;
    }

    @Override
    public boolean isUserOnline(String user, String dbName) {
        DBCollection coll = this.db(dbName).getCollection("users");
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"user", (Object)user);
        query.put((Object)"validity", (Object)new BasicDBObject("$gt", (Object)(System.currentTimeMillis() - (long)this.getValidity())));
        DBCursor cursor = coll.find((DBObject)query);
        return cursor.hasNext();
    }

    @Override
    public boolean isDemoUser(String user) {
        return user.startsWith("__anonim_");
    }

    private int getValidity() {
        if (this.validity_ == -1) {
            this.validity_ = 60000;
            try {
                this.validity_ = new Integer(PropertyManager.getProperty("chatTokenValidity"));
            }
            catch (Exception e) {
                return this.validity_;
            }
        }
        return this.validity_;
    }
}

