/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.listener;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.logging.Logger;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.exoplatform.chat.services.mongodb.MongoModule;

public class GuiceManager
implements ServletContextListener {
    private static final Logger LOG = Logger.getLogger("GuiceManager");
    private static Injector injector_;

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        LOG.info("INITIALIZING GUICE");
        GuiceManager.forceNew();
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        LOG.info("CLOSING GUICE");
    }

    public static Injector getInstance() {
        return injector_;
    }

    public static void forceNew() {
        if (injector_ == null) {
            injector_ = Guice.createInjector((Module[])new Module[]{new MongoModule()});
        }
    }
}

