/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.chat.services.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.WriteConcern;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.chat.listener.ConnectionManager;
import org.exoplatform.chat.model.UserBean;
import org.exoplatform.chat.services.TokenStorage;
import org.exoplatform.chat.utils.MessageDigester;
import org.exoplatform.chat.utils.PropertyManager;

@Named(value="tokenStorage")
@ApplicationScoped
public class TokenMongoService
implements TokenStorage {
    public static final String M_USERS_COLLECTION = "users";

    private DB db(String dbName) {
        if (StringUtils.isEmpty((CharSequence)dbName)) {
            return ConnectionManager.getInstance().getDB();
        }
        return ConnectionManager.getInstance().getDB(dbName);
    }

    public String getToken(String user) {
        String passphrase = PropertyManager.getProperty("chatPassPhrase");
        String in = user + passphrase;
        String token = MessageDigester.getHash(in);
        return token;
    }

    @Override
    public boolean hasUserWithToken(String user, String token, String dbName) {
        DBCollection coll = this.db(dbName).getCollection(M_USERS_COLLECTION);
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"user", (Object)user);
        query.put((Object)"token", (Object)token);
        DBCursor cursor = coll.find((DBObject)query);
        return cursor.hasNext();
    }

    @Override
    public void addUser(String user, String token, String dbName) {
        if (!this.hasUserWithToken(user, token, dbName)) {
            DBCollection coll = this.db(dbName).getCollection(M_USERS_COLLECTION);
            BasicDBObject query = new BasicDBObject();
            query.put((Object)"user", (Object)user);
            DBCursor cursor = coll.find((DBObject)query);
            if (cursor.hasNext()) {
                DBObject doc = cursor.next();
                doc.put("token", (Object)token);
                doc.put("isDemoUser", (Object)user.startsWith("__anonim_"));
                coll.save(doc, WriteConcern.SAFE);
            } else {
                BasicDBObject doc = new BasicDBObject();
                doc.put((Object)"_id", (Object)user);
                doc.put((Object)"user", (Object)user);
                doc.put((Object)"token", (Object)token);
                doc.put((Object)"isDemoUser", (Object)user.startsWith("__anonim_"));
                coll.insert(new DBObject[]{doc});
            }
        }
    }

    @Override
    public Map<String, UserBean> getActiveUsersFilterBy(String user, List<String> limitedFilter, String dbName, boolean withUsers, boolean withPublic, boolean isAdmin, int limit) {
        BasicDBObject query = new BasicDBObject();
        if (isAdmin) {
            if (withPublic && !withUsers) {
                query.put((Object)"isDemoUser", (Object)true);
            } else if (!withPublic && withUsers) {
                query.put((Object)"isDemoUser", (Object)false);
            }
        } else {
            query.put((Object)"isDemoUser", (Object)user.startsWith("__anonim_"));
        }
        if (limit < 0) {
            limit = 0;
        }
        DBCollection coll = this.db(dbName).getCollection(M_USERS_COLLECTION);
        DBCursor cursor = coll.find((DBObject)query).limit(limit);
        HashMap<String, UserBean> users2 = new HashMap<String, UserBean>();
        while (cursor.hasNext()) {
            DBObject doc = cursor.next();
            String target = doc.get("user").toString();
            if (user.equals(target) || !limitedFilter.contains(target)) continue;
            UserBean userBean = new UserBean();
            userBean.setName(target);
            if (doc.get("fullname") != null) {
                userBean.setFullname(doc.get("fullname").toString());
            }
            if (doc.get("status") != null) {
                userBean.setStatus(doc.get("status").toString());
            }
            users2.put(target, userBean);
        }
        return users2;
    }
}

