/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.gdrive.shaded.google.api.client.googleapis.apache;

import java.io.IOException;
import java.net.ProxySelector;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.http.client.HttpClient;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.google.api.client.googleapis.GoogleUtils;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.google.api.client.http.apache.ApacheHttpTransport;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.google.api.client.util.SslUtils;

public final class GoogleApacheHttpTransport {
    public static ApacheHttpTransport newTrustedTransport() throws GeneralSecurityException, IOException {
        SocketConfig socketConfig = SocketConfig.custom().setRcvBufSize(8192).setSndBufSize(8192).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(-1L, TimeUnit.MILLISECONDS);
        connectionManager.setValidateAfterInactivity(-1);
        KeyStore trustStore = GoogleUtils.getCertificateTrustStore();
        SSLContext sslContext = SslUtils.getTlsSslContext();
        SslUtils.initSslContext(sslContext, trustStore, SslUtils.getPkixTrustManagerFactory());
        SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslContext);
        CloseableHttpClient client = HttpClientBuilder.create().useSystemProperties().setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory).setDefaultSocketConfig(socketConfig).setMaxConnTotal(200).setMaxConnPerRoute(20).setRoutePlanner((HttpRoutePlanner)new SystemDefaultRoutePlanner(ProxySelector.getDefault())).setConnectionManager((HttpClientConnectionManager)connectionManager).disableRedirectHandling().disableAutomaticRetries().build();
        return new ApacheHttpTransport((HttpClient)client);
    }

    private GoogleApacheHttpTransport() {
    }
}

