/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.IExecutors;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.SubscribedSku;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ISubscribedSkuCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ISubscribedSkuCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.SubscribedSkuCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.SubscribedSkuCollectionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.SubscribedSkuCollectionResponse;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.SubscribedSkuRequestBuilder;

public class SubscribedSkuCollectionRequest
extends BaseCollectionRequest<SubscribedSkuCollectionResponse, ISubscribedSkuCollectionPage>
implements ISubscribedSkuCollectionRequest {
    public SubscribedSkuCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, SubscribedSkuCollectionResponse.class, ISubscribedSkuCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ISubscribedSkuCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(SubscribedSkuCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ISubscribedSkuCollectionPage get() throws ClientException {
        SubscribedSkuCollectionResponse response = (SubscribedSkuCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(SubscribedSku newSubscribedSku, ICallback<SubscribedSku> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new SubscribedSkuRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newSubscribedSku, callback);
    }

    @Override
    public SubscribedSku post(SubscribedSku newSubscribedSku) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SubscribedSkuRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newSubscribedSku);
    }

    @Override
    public ISubscribedSkuCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ISubscribedSkuCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ISubscribedSkuCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public ISubscribedSkuCollectionPage buildFromResponse(SubscribedSkuCollectionResponse response) {
        SubscribedSkuCollectionRequestBuilder builder = response.nextLink != null ? new SubscribedSkuCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        SubscribedSkuCollectionPage page = new SubscribedSkuCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

