/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive;

import com.microsoft.graph.models.extensions.DriveItem;
import com.microsoft.graph.models.extensions.File;
import com.microsoft.graph.models.extensions.FileSystemInfo;
import com.microsoft.graph.models.extensions.ItemReference;
import com.microsoft.graph.models.extensions.SharingLink;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.services.cms.clouddrives.CloudDriveException;
import org.exoplatform.services.cms.clouddrives.CloudFile;
import org.exoplatform.services.cms.clouddrives.CloudProvider;
import org.exoplatform.services.cms.clouddrives.CloudUser;
import org.exoplatform.services.cms.clouddrives.SkipSyncException;
import org.exoplatform.services.cms.clouddrives.SyncNotSupportedException;
import org.exoplatform.services.cms.clouddrives.jcr.NodeFinder;
import org.exoplatform.services.cms.clouddrives.onedrive.JCRLocalOneDrive;
import org.exoplatform.services.cms.clouddrives.onedrive.OneDriveAPI;
import org.exoplatform.services.cms.clouddrives.onedrive.OneDriveException;
import org.exoplatform.services.cms.clouddrives.onedrive.OneDriveProvider;
import org.exoplatform.services.cms.clouddrives.onedrive.OneDriveStoredToken;
import org.exoplatform.services.cms.clouddrives.onedrive.OneDriveUser;
import org.exoplatform.services.cms.clouddrives.utils.ExtendedMimeTypeResolver;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class OneDriveFileAPITest {
    private JCRLocalOneDrive.OneDriveFileAPI oneDriveFileAPI;
    private OneDriveAPI oneDriveAPI;
    private JCRLocalOneDrive jcrLocalOneDrive;

    @Before
    public void before() throws RepositoryException, CloudDriveException {
        OneDriveProvider oneDriveProvider = new OneDriveProvider("id", "onedrive", "auth", "s");
        this.oneDriveAPI = (OneDriveAPI)Mockito.mock(OneDriveAPI.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.oneDriveAPI.getStoredToken()).thenReturn((Object)((OneDriveStoredToken)Mockito.mock(OneDriveStoredToken.class)));
        OneDriveUser cloudUser = new OneDriveUser("s", "s", "s", (CloudProvider)oneDriveProvider, this.oneDriveAPI);
        Session session = (Session)Mockito.mock(Session.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)session.getRepository()).thenReturn((Object)((Repository)Mockito.mock(ManageableRepository.class)));
        Mockito.when((Object)session.getWorkspace().getName()).thenReturn((Object)"workspaceName");
        Node driveNode = (Node)Mockito.mock(Node.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)driveNode.getSession()).thenReturn((Object)session);
        Mockito.when((Object)driveNode.isNodeType("ecd:cloudDrive")).thenReturn((Object)false);
        Mockito.when((Object)driveNode.hasProperty("exo:title")).thenReturn((Object)true);
        SessionProviderService sessionProviderService = (SessionProviderService)Mockito.mock(SessionProviderService.class);
        NodeFinder nodeFinder = (NodeFinder)Mockito.mock(NodeFinder.class);
        ExtendedMimeTypeResolver extendedMimeTypeResolver = (ExtendedMimeTypeResolver)Mockito.mock(ExtendedMimeTypeResolver.class);
        this.jcrLocalOneDrive = (JCRLocalOneDrive)Mockito.spy((Object)new JCRLocalOneDrive((CloudUser)cloudUser, driveNode, sessionProviderService, nodeFinder, extendedMimeTypeResolver));
        this.oneDriveFileAPI = this.jcrLocalOneDrive.createFileAPI();
    }

    @Test
    public void removeFile() {
        String testItemId = "testItemId";
        this.oneDriveFileAPI.removeFile(testItemId);
        ((OneDriveAPI)Mockito.verify((Object)this.oneDriveAPI, (VerificationMode)Mockito.times((int)1))).removeFile(testItemId);
    }

    @Test
    public void removeFolder() {
        String testItemId = "testItemId";
        this.oneDriveFileAPI.removeFolder(testItemId);
        ((OneDriveAPI)Mockito.verify((Object)this.oneDriveAPI, (VerificationMode)Mockito.times((int)1))).removeFolder(testItemId);
    }

    @Test
    public void createFile() throws Exception {
        Calendar calendar = Calendar.getInstance();
        String parentId = "dparentId";
        String nodeId = "dparentId";
        String nodeName = "dtestName";
        String nodeLink = "dtestWebUrl";
        String nodePath = "dtestPath";
        String mimetype = "";
        Calendar nodeCreated = calendar;
        Calendar nodeModified = calendar;
        ByteArrayInputStream content = new ByteArrayInputStream(new byte[]{1, 2, 3});
        Node fileNode = (Node)Mockito.mock(Node.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)fileNode.getParent().getProperty("ecd:id").getString()).thenReturn((Object)parentId);
        Mockito.when((Object)fileNode.getProperty("exo:title").getString()).thenReturn((Object)nodeName);
        Mockito.when((Object)fileNode.getPath()).thenReturn((Object)nodePath);
        DriveItem testItem = new DriveItem();
        testItem.id = nodeId;
        testItem.name = nodeName;
        testItem.webUrl = nodeLink;
        testItem.createdDateTime = nodeCreated;
        testItem.lastModifiedDateTime = nodeCreated;
        testItem.file = new File();
        testItem.file.mimeType = mimetype;
        testItem.size = 0L;
        SharingLink sharingLink = new SharingLink();
        sharingLink.type = "";
        sharingLink.webUrl = "";
        ((JCRLocalOneDrive)Mockito.doReturn((Object)sharingLink).when((Object)this.jcrLocalOneDrive)).createLink((DriveItem)Mockito.any(DriveItem.class));
        Mockito.when((Object)this.oneDriveAPI.insert(Mockito.anyString(), Mockito.anyString(), (Calendar)Mockito.any(Calendar.class), (Calendar)Mockito.any(Calendar.class), (InputStream)Mockito.any(InputStream.class), Mockito.anyString())).thenReturn((Object)testItem);
        CloudFile cloudFile = this.oneDriveFileAPI.createFile(fileNode, nodeCreated, nodeModified, mimetype, (InputStream)content);
        ((OneDriveAPI)Mockito.verify((Object)this.oneDriveAPI)).insert(parentId, nodeName, nodeCreated, nodeModified, (InputStream)content, "rename");
        ((JCRLocalOneDrive)Mockito.verify((Object)this.jcrLocalOneDrive)).initCreateFile(fileNode, testItem);
        Assert.assertEquals((Object)nodeId, (Object)cloudFile.getId());
        Assert.assertEquals((Object)nodePath, (Object)cloudFile.getPath());
        Assert.assertEquals((Object)nodeName, (Object)cloudFile.getTitle());
        Assert.assertEquals((Object)testItem.createdDateTime, (Object)cloudFile.getCreatedDate());
        Assert.assertEquals((Object)testItem.lastModifiedDateTime, (Object)cloudFile.getModifiedDate());
    }

    @Test
    public void createFolder() throws Exception {
        Calendar calendar = Calendar.getInstance();
        String parentId = "dparentId";
        String nodeId = "dparentId";
        String nodeName = "dtestName";
        String nodeLink = "dtestWebUrl";
        String nodePath = "dtestPath";
        Calendar nodeCreated = calendar;
        Calendar nodeModified = calendar;
        Node fileNode = (Node)Mockito.mock(Node.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)fileNode.getParent().getProperty("ecd:id").getString()).thenReturn((Object)parentId);
        Mockito.when((Object)fileNode.getProperty("exo:title").getString()).thenReturn((Object)nodeName);
        Mockito.when((Object)fileNode.getPath()).thenReturn((Object)nodePath);
        DriveItem testItem = new DriveItem();
        testItem.id = nodeId;
        testItem.name = nodeName;
        testItem.webUrl = nodeLink;
        testItem.createdDateTime = nodeCreated;
        testItem.lastModifiedDateTime = nodeCreated;
        Mockito.when((Object)this.oneDriveAPI.createFolder(parentId, nodeName, calendar)).thenReturn((Object)testItem);
        ((JCRLocalOneDrive)Mockito.doNothing().when((Object)this.jcrLocalOneDrive)).initFolderByDriveItem((Node)Mockito.any(Node.class), (DriveItem)Mockito.any(DriveItem.class));
        CloudFile cloudFile = this.oneDriveFileAPI.createFolder(fileNode, calendar);
        ((OneDriveAPI)Mockito.verify((Object)this.oneDriveAPI)).createFolder(parentId, nodeName, calendar);
        ((JCRLocalOneDrive)Mockito.verify((Object)this.jcrLocalOneDrive)).initFolderByDriveItem(fileNode, testItem);
        Assert.assertEquals((Object)nodeId, (Object)cloudFile.getId());
        Assert.assertEquals((Object)nodePath, (Object)cloudFile.getPath());
        Assert.assertEquals((Object)nodeName, (Object)cloudFile.getTitle());
        Assert.assertEquals((Object)nodeLink, (Object)cloudFile.getLink());
        Assert.assertEquals((Object)"folder", (Object)cloudFile.getType());
        Assert.assertEquals((Object)testItem.createdDateTime, (Object)cloudFile.getCreatedDate());
        Assert.assertEquals((Object)testItem.lastModifiedDateTime, (Object)cloudFile.getModifiedDate());
    }

    @Test
    public void copyFile() throws RepositoryException, CloudDriveException, IOException {
        Calendar calendar = Calendar.getInstance();
        String parentId = "nodeParentId";
        String nodeId = "dparentId";
        String nodeName = "dtestName";
        String nodeLink = "dtestWebUrl";
        String nodePath = "dtestPath";
        String mimetype = "";
        Calendar nodeCreated = calendar;
        Calendar nodeModified = calendar;
        Node destFileNode = (Node)Mockito.mock(Node.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)destFileNode.getParent().getProperty("ecd:id").getString()).thenReturn((Object)parentId);
        Mockito.when((Object)destFileNode.getProperty("exo:title").getString()).thenReturn((Object)nodeName);
        Mockito.when((Object)destFileNode.getPath()).thenReturn((Object)nodePath);
        String srcFileNodeId = "scrNodeId";
        Node scrFileNode = (Node)Mockito.mock(Node.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)scrFileNode.getProperty("ecd:id").getString()).thenReturn((Object)srcFileNodeId);
        DriveItem testItem = new DriveItem();
        testItem.id = nodeId;
        testItem.name = nodeName;
        testItem.webUrl = nodeLink;
        testItem.createdDateTime = nodeCreated;
        testItem.lastModifiedDateTime = nodeCreated;
        testItem.file = new File();
        testItem.file.mimeType = mimetype;
        testItem.size = 0L;
        SharingLink sharingLink = new SharingLink();
        sharingLink.type = "";
        sharingLink.webUrl = "";
        ((JCRLocalOneDrive)Mockito.doReturn((Object)sharingLink).when((Object)this.jcrLocalOneDrive)).createLink((DriveItem)Mockito.any(DriveItem.class));
        Mockito.when((Object)this.oneDriveAPI.copyFile(Mockito.anyString(), Mockito.anyString(), Mockito.anyString())).thenReturn((Object)testItem);
        CloudFile cloudFile = this.oneDriveFileAPI.copyFile(scrFileNode, destFileNode);
        ((OneDriveAPI)Mockito.verify((Object)this.oneDriveAPI)).copyFile(parentId, nodeName, srcFileNodeId);
        ((JCRLocalOneDrive)Mockito.verify((Object)this.jcrLocalOneDrive)).initCreateFile(destFileNode, testItem);
        Assert.assertEquals((Object)nodeId, (Object)cloudFile.getId());
        Assert.assertEquals((Object)nodePath, (Object)cloudFile.getPath());
        Assert.assertEquals((Object)nodeName, (Object)cloudFile.getTitle());
        Assert.assertEquals((Object)testItem.createdDateTime, (Object)cloudFile.getCreatedDate());
        Assert.assertEquals((Object)testItem.lastModifiedDateTime, (Object)cloudFile.getModifiedDate());
    }

    @Test
    public void updateFile() throws RepositoryException, SkipSyncException, OneDriveException {
        Calendar calendar = Calendar.getInstance();
        String parentId = "dparentId";
        String nodeId = "dparentId";
        String nodeName = "dtestName";
        String nodeLink = "dtestWebUrl";
        String nodePath = "dtestPath";
        String mimetype = "";
        Calendar nodeCreated = calendar;
        Calendar nodeModified = calendar;
        DriveItem testItem = new DriveItem();
        testItem.id = nodeId;
        testItem.name = nodeName;
        testItem.webUrl = nodeLink;
        testItem.createdDateTime = nodeCreated;
        testItem.lastModifiedDateTime = nodeCreated;
        testItem.file = new File();
        testItem.file.mimeType = mimetype;
        testItem.size = 0L;
        SharingLink sharingLink = new SharingLink();
        sharingLink.type = "";
        sharingLink.webUrl = "";
        ((JCRLocalOneDrive)Mockito.doReturn((Object)sharingLink).when((Object)this.jcrLocalOneDrive)).createLink((DriveItem)Mockito.any(DriveItem.class));
        Node fileNode = (Node)Mockito.mock(Node.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)fileNode.getParent().getProperty("ecd:id").getString()).thenReturn((Object)parentId);
        Mockito.when((Object)fileNode.getProperty("exo:title").getString()).thenReturn((Object)nodeName);
        Mockito.when((Object)fileNode.getPath()).thenReturn((Object)nodePath);
        Mockito.when((Object)fileNode.getProperty("ecd:id").getString()).thenReturn((Object)nodeId);
        Calendar newDate = Calendar.getInstance();
        Mockito.when((Object)this.oneDriveAPI.updateFile((DriveItem)Mockito.any(DriveItem.class))).thenReturn((Object)testItem);
        CloudFile cloudFile = this.oneDriveFileAPI.updateFile(fileNode, calendar);
        DriveItem preparedItem = new DriveItem();
        preparedItem.id = nodeId;
        preparedItem.name = nodeName;
        preparedItem.parentReference = new ItemReference();
        preparedItem.parentReference.id = parentId;
        preparedItem.fileSystemInfo = new FileSystemInfo();
        preparedItem.fileSystemInfo.lastModifiedDateTime = calendar;
        ((OneDriveAPI)Mockito.verify((Object)this.oneDriveAPI)).updateFile((DriveItem)Mockito.argThat((ArgumentMatcher)new DriveItemArgumentMatcher(this, preparedItem)));
        Assert.assertEquals((Object)nodeId, (Object)cloudFile.getId());
        Assert.assertEquals((Object)nodePath, (Object)cloudFile.getPath());
        Assert.assertEquals((Object)nodeName, (Object)cloudFile.getTitle());
        Assert.assertEquals((Object)testItem.createdDateTime, (Object)cloudFile.getCreatedDate());
        Assert.assertEquals((Object)testItem.lastModifiedDateTime, (Object)cloudFile.getModifiedDate());
    }

    @Test
    public void isTrashSupported() {
        Assert.assertFalse((boolean)this.oneDriveFileAPI.isTrashSupported());
    }

    @Test(expected=SyncNotSupportedException.class)
    public void restore() throws SyncNotSupportedException {
        this.oneDriveFileAPI.restore("", "");
    }

    @Test(expected=SyncNotSupportedException.class)
    public void trashFile() throws CloudDriveException {
        this.oneDriveFileAPI.trashFile("");
    }

    @Test(expected=SyncNotSupportedException.class)
    public void trashFolder() throws CloudDriveException {
        this.oneDriveFileAPI.trashFolder("");
    }

    @Test(expected=SyncNotSupportedException.class)
    public void untrashFile() throws CloudDriveException {
        this.oneDriveFileAPI.untrashFile((Node)Mockito.mock(Node.class));
    }

    @Test(expected=SyncNotSupportedException.class)
    public void untrashFolder() throws CloudDriveException {
        this.oneDriveFileAPI.untrashFolder((Node)Mockito.any(Node.class));
    }

    private class DriveItemArgumentMatcher
    implements ArgumentMatcher<DriveItem> {
        DriveItem driveItem;

        public DriveItemArgumentMatcher(OneDriveFileAPITest oneDriveFileAPITest, DriveItem driveItem) {
            this.driveItem = driveItem;
        }

        public boolean matches(DriveItem item) {
            if (this.driveItem == item) {
                return true;
            }
            return this.driveItem.id.equals(item.id) && this.driveItem.name.equals(item.name) && this.driveItem.parentReference.id.equals(item.parentReference.id) && this.driveItem.fileSystemInfo.lastModifiedDateTime.equals(item.fileSystemInfo.lastModifiedDateTime);
        }
    }
}

