/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.IExecutors;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.MessageRule;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IMessageRuleCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IMessageRuleCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.MessageRuleCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.MessageRuleCollectionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.MessageRuleCollectionResponse;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.MessageRuleRequestBuilder;

public class MessageRuleCollectionRequest
extends BaseCollectionRequest<MessageRuleCollectionResponse, IMessageRuleCollectionPage>
implements IMessageRuleCollectionRequest {
    public MessageRuleCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, MessageRuleCollectionResponse.class, IMessageRuleCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IMessageRuleCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(MessageRuleCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IMessageRuleCollectionPage get() throws ClientException {
        MessageRuleCollectionResponse response = (MessageRuleCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(MessageRule newMessageRule, ICallback<MessageRule> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new MessageRuleRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newMessageRule, callback);
    }

    @Override
    public MessageRule post(MessageRule newMessageRule) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new MessageRuleRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newMessageRule);
    }

    @Override
    public IMessageRuleCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IMessageRuleCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IMessageRuleCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IMessageRuleCollectionPage buildFromResponse(MessageRuleCollectionResponse response) {
        MessageRuleCollectionRequestBuilder builder = response.nextLink != null ? new MessageRuleCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        MessageRuleCollectionPage page = new MessageRuleCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

