/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.IExecutors;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.OnenotePage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IOnenotePageCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IOnenotePageCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.OnenotePageCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.OnenotePageCollectionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.OnenotePageCollectionResponse;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.OnenotePageRequestBuilder;

public class OnenotePageCollectionRequest
extends BaseCollectionRequest<OnenotePageCollectionResponse, IOnenotePageCollectionPage>
implements IOnenotePageCollectionRequest {
    public OnenotePageCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, OnenotePageCollectionResponse.class, IOnenotePageCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IOnenotePageCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(OnenotePageCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IOnenotePageCollectionPage get() throws ClientException {
        OnenotePageCollectionResponse response = (OnenotePageCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(byte[] newOnenotePage, ICallback<OnenotePage> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new OnenotePageRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newOnenotePage, callback);
    }

    @Override
    public OnenotePage post(byte[] newOnenotePage) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new OnenotePageRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newOnenotePage);
    }

    @Override
    public IOnenotePageCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IOnenotePageCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IOnenotePageCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IOnenotePageCollectionPage buildFromResponse(OnenotePageCollectionResponse response) {
        OnenotePageCollectionRequestBuilder builder = response.nextLink != null ? new OnenotePageCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        OnenotePageCollectionPage page = new OnenotePageCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

