/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.IExecutors;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.ItemActivityStat;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IItemActivityStatCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IItemActivityStatCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ItemActivityStatCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ItemActivityStatCollectionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ItemActivityStatCollectionResponse;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ItemActivityStatRequestBuilder;

public class ItemActivityStatCollectionRequest
extends BaseCollectionRequest<ItemActivityStatCollectionResponse, IItemActivityStatCollectionPage>
implements IItemActivityStatCollectionRequest {
    public ItemActivityStatCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ItemActivityStatCollectionResponse.class, IItemActivityStatCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IItemActivityStatCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ItemActivityStatCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IItemActivityStatCollectionPage get() throws ClientException {
        ItemActivityStatCollectionResponse response = (ItemActivityStatCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ItemActivityStat newItemActivityStat, ICallback<ItemActivityStat> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ItemActivityStatRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newItemActivityStat, callback);
    }

    @Override
    public ItemActivityStat post(ItemActivityStat newItemActivityStat) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ItemActivityStatRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newItemActivityStat);
    }

    @Override
    public IItemActivityStatCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IItemActivityStatCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IItemActivityStatCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IItemActivityStatCollectionPage buildFromResponse(ItemActivityStatCollectionResponse response) {
        ItemActivityStatCollectionRequestBuilder builder = response.nextLink != null ? new ItemActivityStatCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ItemActivityStatCollectionPage page = new ItemActivityStatCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

