/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.IExecutors;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.IdentityProvider;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IIdentityProviderCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IIdentityProviderCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IdentityProviderCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IdentityProviderCollectionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IdentityProviderCollectionResponse;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IdentityProviderRequestBuilder;

public class IdentityProviderCollectionRequest
extends BaseCollectionRequest<IdentityProviderCollectionResponse, IIdentityProviderCollectionPage>
implements IIdentityProviderCollectionRequest {
    public IdentityProviderCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, IdentityProviderCollectionResponse.class, IIdentityProviderCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IIdentityProviderCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(IdentityProviderCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IIdentityProviderCollectionPage get() throws ClientException {
        IdentityProviderCollectionResponse response = (IdentityProviderCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(IdentityProvider newIdentityProvider, ICallback<IdentityProvider> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new IdentityProviderRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newIdentityProvider, callback);
    }

    @Override
    public IdentityProvider post(IdentityProvider newIdentityProvider) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new IdentityProviderRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newIdentityProvider);
    }

    @Override
    public IIdentityProviderCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IIdentityProviderCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IIdentityProviderCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IIdentityProviderCollectionPage buildFromResponse(IdentityProviderCollectionResponse response) {
        IdentityProviderCollectionRequestBuilder builder = response.nextLink != null ? new IdentityProviderCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        IdentityProviderCollectionPage page = new IdentityProviderCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

