/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.IExecutors;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.TeamsTab;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ITeamsTabCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ITeamsTabCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.TeamsTabCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.TeamsTabCollectionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.TeamsTabCollectionResponse;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.TeamsTabRequestBuilder;

public class TeamsTabCollectionRequest
extends BaseCollectionRequest<TeamsTabCollectionResponse, ITeamsTabCollectionPage>
implements ITeamsTabCollectionRequest {
    public TeamsTabCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, TeamsTabCollectionResponse.class, ITeamsTabCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ITeamsTabCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(TeamsTabCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ITeamsTabCollectionPage get() throws ClientException {
        TeamsTabCollectionResponse response = (TeamsTabCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(TeamsTab newTeamsTab, ICallback<TeamsTab> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new TeamsTabRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newTeamsTab, callback);
    }

    @Override
    public TeamsTab post(TeamsTab newTeamsTab) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new TeamsTabRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newTeamsTab);
    }

    @Override
    public ITeamsTabCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ITeamsTabCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ITeamsTabCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public ITeamsTabCollectionPage buildFromResponse(TeamsTabCollectionResponse response) {
        TeamsTabCollectionRequestBuilder builder = response.nextLink != null ? new TeamsTabCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        TeamsTabCollectionPage page = new TeamsTabCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

