/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.HttpMethod;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.Entity;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IEntityWithReferenceRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.serializer.IJsonBackedObject;

public class EntityWithReferenceRequest
extends BaseRequest
implements IEntityWithReferenceRequest {
    public EntityWithReferenceRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Entity.class);
    }

    @Override
    public void post(Entity newEntity, IJsonBackedObject payload, ICallback<Entity> callback) {
        this.send(HttpMethod.POST, callback, payload);
    }

    @Override
    public Entity post(Entity newEntity, IJsonBackedObject payload) throws ClientException {
        IJsonBackedObject response = (IJsonBackedObject)this.send(HttpMethod.POST, payload);
        if (response != null) {
            return newEntity;
        }
        return null;
    }

    @Override
    public void get(ICallback<Entity> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public Entity get() throws ClientException {
        return (Entity)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<Entity> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(Entity sourceEntity, ICallback<Entity> callback) {
        this.send(HttpMethod.PATCH, callback, sourceEntity);
    }

    @Override
    public Entity patch(Entity sourceEntity) throws ClientException {
        return (Entity)this.send(HttpMethod.PATCH, sourceEntity);
    }

    @Override
    public IEntityWithReferenceRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IEntityWithReferenceRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

