/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.IExecutors;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.PlannerPlan;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IPlannerPlanCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IPlannerPlanCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.PlannerPlanCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.PlannerPlanCollectionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.PlannerPlanCollectionResponse;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.PlannerPlanRequestBuilder;

public class PlannerPlanCollectionRequest
extends BaseCollectionRequest<PlannerPlanCollectionResponse, IPlannerPlanCollectionPage>
implements IPlannerPlanCollectionRequest {
    public PlannerPlanCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, PlannerPlanCollectionResponse.class, IPlannerPlanCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IPlannerPlanCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(PlannerPlanCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IPlannerPlanCollectionPage get() throws ClientException {
        PlannerPlanCollectionResponse response = (PlannerPlanCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(PlannerPlan newPlannerPlan, ICallback<PlannerPlan> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new PlannerPlanRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newPlannerPlan, callback);
    }

    @Override
    public PlannerPlan post(PlannerPlan newPlannerPlan) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new PlannerPlanRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newPlannerPlan);
    }

    @Override
    public IPlannerPlanCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IPlannerPlanCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IPlannerPlanCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IPlannerPlanCollectionPage buildFromResponse(PlannerPlanCollectionResponse response) {
        PlannerPlanCollectionRequestBuilder builder = response.nextLink != null ? new PlannerPlanCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        PlannerPlanCollectionPage page = new PlannerPlanCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

