/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.box;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIConnectionListener;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxEnterprise;
import com.box.sdk.BoxEvent;
import com.box.sdk.BoxFile;
import com.box.sdk.BoxFolder;
import com.box.sdk.BoxItem;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxSharedLink;
import com.box.sdk.BoxTrash;
import com.box.sdk.BoxUser;
import com.box.sdk.ExoBoxEvent;
import com.box.sdk.PartialCollection;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.clouddrive.box.BoxException;
import org.exoplatform.services.cms.clouddrives.CloudDriveException;
import org.exoplatform.services.cms.clouddrives.ConflictException;
import org.exoplatform.services.cms.clouddrives.FileTrashRemovedException;
import org.exoplatform.services.cms.clouddrives.NotFoundException;
import org.exoplatform.services.cms.clouddrives.RefreshAccessException;
import org.exoplatform.services.cms.clouddrives.oauth2.UserToken;
import org.exoplatform.services.cms.clouddrives.utils.ChunkIterator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class BoxAPI {
    protected static final Log LOG = ExoLogger.getLogger(BoxAPI.class);
    public static final int BOX_PAGE_SIZE = 100;
    public static final String BOX_ROOT_ID = "0";
    public static final String BOX_TRASH_ID = "1";
    public static final String BOX_ITEM_STATE_ACTIVE = "active";
    public static final String BOX_ITEM_STATE_TRASHED = "trashed";
    public static final String BOX_ITEM_STATE_DELETED = "deleted";
    public static final String BOX_APP_URL = "https://app.box.com/";
    protected static final String BOX_FILES_PATH = "files/0/f/";
    public static final String BOX_FILE_URL = "https://app.box.com/files/0/f/";
    public static final String BOX_WEBDOCUMENT_EXT = "webdoc";
    public static final String BOX_WEBDOCUMENT_MIMETYPE = "application/x-exo.box.webdoc";
    public static final String BOX_NOTE_EXT = "boxnote";
    public static final String BOX_NOTE_MIMETYPE = "application/x-exo.box.note";
    public static final String BOX_EMBED_URL = "https://%sapp.box.com/embed_widget/000000000000/%s?view=list&sort=date&theme=gray&show_parent_path=no&show_item_feed_actions=no&session_expired=true";
    public static final String BOX_EMBED_URL_SSO = "https://app.box.com/login/auto_initiate_sso?enterprise_id=%s&redirect_url=%s";
    public static final Pattern BOX_URL_CUSTOM_PATTERN = Pattern.compile("^https://([\\p{ASCII}]*){1}?\\.app\\.box\\.com/.*\\z");
    public static final Pattern BOX_URL_MAKE_CUSTOM_PATTERN = Pattern.compile("^(https)://(app\\.box\\.com/.*)\\z");
    public static final long STREAM_POSITION_NOW = -1L;
    public static final String FOLDER_TYPE = "folder";
    public static final Set<BoxEvent.Type> BOX_EVENTS = new HashSet<BoxEvent.Type>();
    public static final String[] ITEM_FIELDS;
    public static final String[] USER_FIELDS;
    private final BoxAPIConnection api;
    private final StoredToken token;
    private ChangesLink changesLink;
    private String enterpriseId;
    private String enterpriseName;
    private String customDomain;

    BoxAPI(String clientId, String clientSecret, String authCode, String redirectUri) throws BoxException, CloudDriveException {
        try {
            this.api = new BoxAPIConnection(clientId, clientSecret, authCode);
            this.token = new StoredToken();
            this.token.store();
            this.api.addListener((BoxAPIConnectionListener)this.token);
        }
        catch (BoxAPIException e) {
            throw new BoxException("Error submiting authentication code: " + e.getMessage(), e);
        }
        this.updateChangesLink();
        this.initUser();
    }

    BoxAPI(String clientId, String clientSecret, String accessToken, String refreshToken, long expirationTime) throws CloudDriveException {
        try {
            this.api = new BoxAPIConnection(clientId, clientSecret, accessToken, refreshToken);
            this.api.setExpires(expirationTime);
            this.token = new StoredToken();
            this.token.store();
            this.api.addListener((BoxAPIConnectionListener)this.token);
        }
        catch (BoxAPIException e) {
            throw new BoxException("Error creating client with authentication tokens: " + e.getMessage(), e);
        }
        this.initUser();
    }

    void updateToken(UserToken newToken) throws CloudDriveException {
        this.token.merge(newToken);
        this.api.setAccessToken(this.token.getAccessToken());
        this.api.setRefreshToken(this.token.getRefreshToken());
        this.api.setExpires(this.token.getExpirationTime().longValue());
    }

    StoredToken getToken() {
        return this.token;
    }

    BoxUser.Info getCurrentUser() throws BoxException, RefreshAccessException {
        try {
            BoxUser user = BoxUser.getCurrentUser((BoxAPIConnection)this.api);
            BoxUser.Info info = user.getInfo(USER_FIELDS);
            return info;
        }
        catch (BoxAPIException e) {
            this.checkTokenState(e);
            throw new BoxException("Error requesting current user: " + e.getMessage(), e);
        }
    }

    BoxFolder getRootFolder() throws BoxException, RefreshAccessException {
        try {
            BoxFolder root = BoxFolder.getRootFolder((BoxAPIConnection)this.api);
            return root;
        }
        catch (BoxAPIException e) {
            this.checkTokenState(e);
            throw new BoxException("Error getting root folder: " + e.getMessage(), e);
        }
    }

    ItemsIterator getFolderItems(String folderId) throws CloudDriveException {
        return new ItemsIterator(folderId);
    }

    Calendar parseDate(String dateString) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        Date d = BoxDateFormat.parse((String)dateString);
        calendar.setTime(d);
        return calendar;
    }

    String formatDate(Calendar date) {
        return BoxDateFormat.format((Date)date.getTime());
    }

    String getLink(BoxItem.Info item) {
        CharSequence link;
        BoxSharedLink shared = item.getSharedLink();
        if (shared != null && (link = shared.getURL()) != null) {
            return this.link((String)link);
        }
        link = new StringBuilder();
        ((StringBuilder)link).append(this.link(BOX_FILE_URL));
        String id = item.getID();
        if (BOX_ROOT_ID.equals(id)) {
            ((StringBuilder)link).append(id);
        } else if (item instanceof BoxFile.Info) {
            String parentId = item.getParent().getID();
            ((StringBuilder)link).append(parentId);
            ((StringBuilder)link).append("/1/f_");
            ((StringBuilder)link).append(id);
        } else if (item instanceof BoxFolder.Info) {
            ((StringBuilder)link).append(id);
            ((StringBuilder)link).append('/');
            ((StringBuilder)link).append(item.getName());
        } else {
            ((StringBuilder)link).append(BOX_ROOT_ID);
        }
        ((StringBuilder)link).append("/");
        return ((StringBuilder)link).toString();
    }

    String getEmbedLink(BoxItem.Info item) {
        String link;
        String[] lparts;
        StringBuilder linkValue = new StringBuilder();
        BoxSharedLink shared = item.getSharedLink();
        if (shared != null && (lparts = (link = shared.getURL()).split("/")).length > 3 && lparts[lparts.length - 2].equals("s")) {
            linkValue.append("s/");
            linkValue.append(lparts[lparts.length - 1]);
        }
        if (linkValue.length() == 0) {
            linkValue.append(BOX_FILES_PATH);
            String id = item.getID();
            if (BOX_ROOT_ID.equals(id)) {
                linkValue.append(id);
            } else if (item instanceof BoxFile.Info) {
                String parentId = item.getParent().getID();
                linkValue.append(parentId);
                linkValue.append("/1/f_");
                linkValue.append(id);
            } else if (item instanceof BoxFolder.Info) {
                linkValue.append(id);
            } else {
                linkValue.append(BOX_ROOT_ID);
            }
        }
        if (this.customDomain != null) {
            return String.format(BOX_EMBED_URL, this.customDomain + ".", linkValue.toString());
        }
        return String.format(BOX_EMBED_URL, "", linkValue.toString());
    }

    String getThumbnailLink(BoxItem.Info item) {
        return this.getLink(item);
    }

    ChangesLink getChangesLink() throws BoxException, RefreshAccessException {
        if (this.changesLink == null || this.changesLink.isOutdated()) {
            this.updateChangesLink();
        }
        return this.changesLink;
    }

    void updateChangesLink() throws BoxException, RefreshAccessException {
        try {
            long retryTimeout;
            long maxRetries;
            long ttl;
            String type;
            String url;
            URL eventsUrl = new URL(this.api.getBaseURL() + "events");
            BoxAPIRequest request = new BoxAPIRequest(this.api, eventsUrl, "OPTIONS");
            BoxJSONResponse response = (BoxJSONResponse)request.send();
            JsonObject jsonObject = JsonObject.readFrom((String)response.getJSON());
            JsonArray entries = jsonObject.get("entries").asArray();
            if (entries.size() > 0) {
                JsonObject firstEntry = entries.get(0).asObject();
                JsonValue urlVal = firstEntry.get("url");
                url = urlVal != null ? urlVal.asString() : null;
                JsonValue typeVal = firstEntry.get("type");
                type = typeVal != null ? typeVal.asString() : null;
                JsonValue ttlVal = firstEntry.get("ttl");
                try {
                    ttl = ttlVal != null ? Long.parseLong(ttlVal.asString()) : 10L;
                }
                catch (NumberFormatException e) {
                    LOG.warn((Object)("Error parsing ttl value in Events response [" + ttlVal + "]: " + e));
                    ttl = 10L;
                }
                JsonValue maxRetriesVal = firstEntry.get("max_retries");
                try {
                    maxRetries = maxRetriesVal != null ? Long.parseLong(maxRetriesVal.asString()) : 0L;
                }
                catch (NumberFormatException e) {
                    LOG.warn((Object)("Error parsing max_retries value in Events response [" + maxRetriesVal + "]: " + e));
                    maxRetries = 2L;
                }
                JsonValue retryTimeoutVal = firstEntry.get("retry_timeout");
                try {
                    retryTimeout = retryTimeoutVal != null ? retryTimeoutVal.asLong() * 1000L : 600000L;
                }
                catch (NumberFormatException e) {
                    LOG.warn((Object)("Error parsing retry_timeout value in Events response [" + retryTimeoutVal + "]: " + e));
                    retryTimeout = 600000L;
                }
            } else {
                throw new BoxException("Empty entries from Events service.");
            }
            this.changesLink = new ChangesLink(type, url, ttl, maxRetries, retryTimeout);
        }
        catch (BoxAPIException e) {
            this.checkTokenState(e);
            throw new BoxException("Error requesting Events service for long polling URL: " + e.getMessage(), e);
        }
        catch (MalformedURLException e) {
            throw new BoxException("Error constructing Events service URL: " + e.getMessage(), e);
        }
    }

    EventsIterator getEvents(long streamPosition) throws CloudDriveException {
        return new EventsIterator(streamPosition);
    }

    BoxFile.Info createFile(String parentId, String name, Calendar created, InputStream data) throws BoxException, NotFoundException, RefreshAccessException, ConflictException {
        try {
            try {
                this.readFolder(parentId);
            }
            catch (NotFoundException e) {
                throw new NotFoundException("Parent not found " + parentId + ". Cannot start file uploading " + name, (Throwable)e);
            }
            BoxFolder parent = new BoxFolder(this.api, parentId);
            return parent.uploadFile(data, name);
        }
        catch (BoxAPIException e) {
            this.checkTokenState(e);
            int status = e.getResponseCode();
            if (status == 404 || status == 412) {
                throw new NotFoundException("Parent not found " + parentId + ". File uploading canceled for " + name, (Throwable)e);
            }
            if (status == 403) {
                throw new NotFoundException("The user doesn't have access to upload a file " + name, (Throwable)e);
            }
            if (status == 409) {
                throw new ConflictException("File with the same name as creating already exists " + name, (Throwable)e);
            }
            throw new BoxException("Error uploading file: " + this.getErrorMessage(e), e);
        }
    }

    BoxFolder.Info createFolder(String parentId, String name, Calendar created) throws BoxException, NotFoundException, RefreshAccessException, ConflictException {
        try {
            BoxFolder parent = new BoxFolder(this.api, parentId);
            return parent.createFolder(name);
        }
        catch (BoxAPIException e) {
            this.checkTokenState(e);
            int status = e.getResponseCode();
            if (status == 404 || status == 412) {
                throw new NotFoundException("Parent not found " + parentId, (Throwable)e);
            }
            if (status == 403) {
                throw new NotFoundException("The user doesn't have access to create a folder " + name, (Throwable)e);
            }
            if (status == 409) {
                throw new ConflictException("File with the same name as creating already exists " + name, (Throwable)e);
            }
            throw new BoxException("Error creating folder: " + this.getErrorMessage(e), e);
        }
    }

    void deleteFile(String id) throws BoxException, NotFoundException, RefreshAccessException {
        try {
            BoxFile file = new BoxFile(this.api, id);
            file.delete();
        }
        catch (BoxAPIException e) {
            this.checkTokenState(e);
            int status = e.getResponseCode();
            if (status == 404 || status == 412) {
                throw new NotFoundException("File not found " + id, (Throwable)e);
            }
            if (status == 403) {
                throw new NotFoundException("The user doesn't have access to the file " + id, (Throwable)e);
            }
            throw new BoxException("Error deleting file: " + this.getErrorMessage(e), e);
        }
    }

    void deleteFolder(String id) throws BoxException, NotFoundException, RefreshAccessException {
        try {
            BoxFolder folder = new BoxFolder(this.api, id);
            folder.delete(true);
        }
        catch (BoxAPIException e) {
            this.checkTokenState(e);
            int status = e.getResponseCode();
            if (status == 404 || status == 412) {
                throw new NotFoundException("File not found " + id, (Throwable)e);
            }
            if (status == 403) {
                throw new NotFoundException("The user doesn't have access to the folder " + id, (Throwable)e);
            }
            throw new BoxException("Error deleting folder: " + this.getErrorMessage(e), e);
        }
    }

    BoxFile.Info trashFile(String id) throws BoxException, FileTrashRemovedException, NotFoundException, RefreshAccessException {
        try {
            BoxFile file = new BoxFile(this.api, id);
            file.delete();
            try {
                BoxTrash trash = new BoxTrash(this.api);
                return trash.getFileInfo(id, ITEM_FIELDS);
            }
            catch (BoxAPIException e) {
                this.checkTokenState(e);
                int status = e.getResponseCode();
                if (status == 404 || status == 412) {
                    throw new FileTrashRemovedException("Trashed file deleted permanently " + id);
                }
                throw new BoxException("Error reading trashed file: " + this.getErrorMessage(e), e);
            }
        }
        catch (BoxAPIException e) {
            this.checkTokenState(e);
            int status = e.getResponseCode();
            if (status == 404 || status == 412) {
                throw new NotFoundException("File not found " + id, (Throwable)e);
            }
            if (status == 403) {
                throw new NotFoundException("The user doesn't have access to the file " + id, (Throwable)e);
            }
            throw new BoxException("Error trashing file: " + this.getErrorMessage(e), e);
        }
    }

    BoxFolder.Info trashFolder(String id) throws BoxException, FileTrashRemovedException, NotFoundException, RefreshAccessException {
        try {
            BoxFolder folder = new BoxFolder(this.api, id);
            folder.delete(true);
            try {
                BoxTrash trash = new BoxTrash(this.api);
                return trash.getFolderInfo(id, ITEM_FIELDS);
            }
            catch (BoxAPIException e) {
                this.checkTokenState(e);
                int status = e.getResponseCode();
                if (status == 404 || status == 412) {
                    throw new FileTrashRemovedException("Trashed folder deleted permanently " + id);
                }
                throw new BoxException("Error reading trashed foler: " + this.getErrorMessage(e), e);
            }
        }
        catch (BoxAPIException e) {
            this.checkTokenState(e);
            int status = e.getResponseCode();
            if (status == 404 || status == 412) {
                throw new NotFoundException("File not found " + id, (Throwable)e);
            }
            if (status == 403) {
                throw new NotFoundException("The user doesn't have access to the folder " + id, (Throwable)e);
            }
            throw new BoxException("Error trashing foler: " + this.getErrorMessage(e), e);
        }
    }

    BoxFile.Info untrashFile(String id, String name) throws BoxException, NotFoundException, RefreshAccessException, ConflictException {
        try {
            BoxTrash trash = new BoxTrash(this.api);
            return trash.restoreFile(id);
        }
        catch (BoxAPIException e) {
            this.checkTokenState(e);
            int status = e.getResponseCode();
            if (status == 404 || status == 412) {
                throw new NotFoundException("Trashed file not found " + id, (Throwable)e);
            }
            if (status == 405) {
                throw new NotFoundException("File not in the trash " + id, (Throwable)e);
            }
            if (status == 409) {
                throw new ConflictException("File with the same name as untrashed already exists " + id, (Throwable)e);
            }
            throw new BoxException("Error untrashing file: " + this.getErrorMessage(e), e);
        }
    }

    BoxFolder.Info untrashFolder(String id, String name) throws BoxException, NotFoundException, RefreshAccessException, ConflictException {
        try {
            BoxTrash trash = new BoxTrash(this.api);
            return trash.restoreFolder(id);
        }
        catch (BoxAPIException e) {
            this.checkTokenState(e);
            int status = e.getResponseCode();
            if (status == 404 || status == 412) {
                throw new NotFoundException("Trashed folder not found " + id, (Throwable)e);
            }
            if (status == 405) {
                throw new NotFoundException("Folder not in the trash " + id, (Throwable)e);
            }
            if (status == 409) {
                throw new ConflictException("Folder with the same name as untrashed already exists " + id, (Throwable)e);
            }
            throw new BoxException("Error untrashing folder: " + this.getErrorMessage(e), e);
        }
    }

    BoxFile.Info updateFile(String parentId, String id, String name) throws BoxException, NotFoundException, RefreshAccessException, ConflictException {
        boolean parentChanged;
        BoxFile.Info existing = this.readFile(id);
        int attemts = 0;
        boolean nameChanged = !existing.getName().equals(name);
        boolean bl = parentChanged = !existing.getParent().getID().equals(parentId);
        while ((nameChanged || parentChanged) && attemts < 3) {
            ++attemts;
            try {
                BoxFile file = new BoxFile(this.api, id);
                if (parentChanged) {
                    BoxFolder destination = new BoxFolder(this.api, parentId);
                    return (BoxFile.Info)file.move(destination, nameChanged ? name : null);
                }
                BoxFile.Info info = new BoxFile.Info(file);
                info.setName(name);
                file.updateInfo(info);
                return info;
            }
            catch (BoxAPIException e) {
                this.checkTokenState(e);
                int status = e.getResponseCode();
                if (status == 404 || status == 412) {
                    throw new NotFoundException("File not found " + id, (Throwable)e);
                }
                if (status == 409) {
                    if (attemts < 3) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("File with the same name as updated already exists " + id + ". Trying again."));
                        }
                        nameChanged = !(existing = this.readFile(id)).getName().equalsIgnoreCase(name);
                        parentChanged = !existing.getParent().getID().equals(parentId);
                        continue;
                    }
                    throw new ConflictException("File with the same name as updated already exists " + id);
                }
                throw new BoxException("Error updating file: " + this.getErrorMessage(e), e);
            }
        }
        return existing;
    }

    BoxFile.Info updateFileContent(String id, Calendar modified, InputStream data) throws BoxException, NotFoundException, RefreshAccessException {
        try {
            BoxFile file = new BoxFile(this.api, id);
            file.uploadVersion(data, modified.getTime());
            return file.getInfo(ITEM_FIELDS);
        }
        catch (BoxAPIException e) {
            this.checkTokenState(e);
            int status = e.getResponseCode();
            if (status == 404 || status == 412) {
                throw new NotFoundException("File not found " + id, (Throwable)e);
            }
            throw new BoxException("Error uploading new version of file: " + this.getErrorMessage(e), e);
        }
    }

    BoxFolder.Info updateFolder(String parentId, String id, String name) throws BoxException, NotFoundException, RefreshAccessException, ConflictException {
        boolean parentChanged;
        BoxFolder.Info existing = this.readFolder(id);
        int attemts = 0;
        boolean nameChanged = !existing.getName().equals(name);
        boolean bl = parentChanged = !existing.getParent().getID().equals(parentId);
        while ((nameChanged || parentChanged) && attemts < 3) {
            ++attemts;
            try {
                BoxFolder folder = new BoxFolder(this.api, id);
                if (parentChanged) {
                    BoxFolder destination = new BoxFolder(this.api, parentId);
                    return (BoxFolder.Info)folder.move(destination);
                }
                BoxFolder.Info info = new BoxFolder.Info(folder);
                info.setName(name);
                folder.updateInfo(info);
                return info;
            }
            catch (BoxAPIException e) {
                this.checkTokenState(e);
                int status = e.getResponseCode();
                if (status == 404 || status == 412) {
                    throw new NotFoundException("Folder not found " + id, (Throwable)e);
                }
                if (status == 409) {
                    if (attemts < 3) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Folder with the same name as updated already exists " + id + ". Trying again."));
                        }
                        nameChanged = !(existing = this.readFolder(id)).getName().equalsIgnoreCase(name);
                        parentChanged = !existing.getParent().getID().equals(parentId);
                        continue;
                    }
                    throw new ConflictException("Folder with the same name as updated already exists " + id);
                }
                throw new BoxException("Error updating folder: " + this.getErrorMessage(e), e);
            }
        }
        return existing;
    }

    BoxFile.Info copyFile(String id, String parentId, String name) throws BoxException, NotFoundException, RefreshAccessException, ConflictException {
        try {
            BoxFile file = new BoxFile(this.api, id);
            BoxFolder destination = new BoxFolder(this.api, parentId);
            BoxFile.Info info = file.copy(destination, name);
            return info;
        }
        catch (BoxAPIException e) {
            this.checkTokenState(e);
            int status = e.getResponseCode();
            if (status == 404 || status == 412) {
                throw new NotFoundException("File not found " + id, (Throwable)e);
            }
            if (status == 409) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("File with the same name as copying already exists " + id + ". Trying again."));
                }
                throw new ConflictException("File with the same name as copying already exists " + id);
            }
            throw new BoxException("Error copying file: " + this.getErrorMessage(e), e);
        }
    }

    BoxFolder.Info copyFolder(String id, String parentId, String name) throws BoxException, NotFoundException, RefreshAccessException, ConflictException {
        try {
            BoxFolder folder = new BoxFolder(this.api, id);
            BoxFolder destination = new BoxFolder(this.api, parentId);
            BoxFolder.Info info = folder.copy(destination, name);
            return info;
        }
        catch (BoxAPIException e) {
            this.checkTokenState(e);
            int status = e.getResponseCode();
            if (status == 404 || status == 412) {
                throw new NotFoundException("Folder not found " + id, (Throwable)e);
            }
            if (status == 409) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Folder with the same name as copying already exists " + id + ". Trying again."));
                }
                throw new ConflictException("Folder with the same name as copying already exists " + id);
            }
            throw new BoxException("Error copying folder: " + this.getErrorMessage(e), e);
        }
    }

    BoxFile.Info readFile(String id) throws BoxException, NotFoundException, RefreshAccessException {
        try {
            BoxFile file = new BoxFile(this.api, id);
            BoxFile.Info info = file.getInfo(ITEM_FIELDS);
            return info;
        }
        catch (BoxAPIException e) {
            this.checkTokenState(e);
            int status = e.getResponseCode();
            if (status == 404 || status == 412) {
                throw new NotFoundException("File not found " + id, (Throwable)e);
            }
            throw new BoxException("Error reading file: " + e.getMessage(), e);
        }
    }

    BoxFolder.Info readFolder(String id) throws BoxException, NotFoundException, RefreshAccessException {
        try {
            BoxFolder folder = new BoxFolder(this.api, id);
            BoxFolder.Info info = folder.getInfo(ITEM_FIELDS);
            return info;
        }
        catch (BoxAPIException e) {
            this.checkTokenState(e);
            int status = e.getResponseCode();
            if (status == 404 || status == 412) {
                throw new NotFoundException("Folder not found " + id, (Throwable)e);
            }
            throw new BoxException("Error reading folder: " + e.getMessage(), e);
        }
    }

    String getEnterpriseName() {
        return this.enterpriseName;
    }

    String getEnterpriseId() {
        return this.enterpriseId;
    }

    String getCustomDomain() {
        return this.customDomain;
    }

    private String getErrorMessage(BoxAPIException e) {
        if (e.getResponseCode() >= 400) {
            JsonValue errorsVal;
            JsonValue contextVal;
            JsonValue messageVal;
            String code;
            StringBuilder message = new StringBuilder();
            JsonObject jsonObject = JsonObject.readFrom((String)e.getResponse());
            JsonValue codeVal = jsonObject.get("code");
            if (codeVal != null && (code = codeVal.asString()).length() > 0) {
                message.append('[');
                message.append(code);
                message.append(']');
            }
            if ((messageVal = jsonObject.get("message")) != null) {
                if (message.length() > 0) {
                    message.append(' ');
                }
                message.append(messageVal.asString());
                message.append('.');
            }
            if ((contextVal = jsonObject.get("context_info")) != null && (errorsVal = contextVal.asObject().get("errors")) != null && (messageVal = errorsVal.asObject().get("message")) != null) {
                if (message.length() > 0) {
                    message.append(' ');
                }
                message.append(messageVal.asString());
            }
            if (message.length() > 0) {
                return message.toString();
            }
        }
        return e.getMessage();
    }

    private void checkTokenState(BoxAPIException e) throws RefreshAccessException {
        String resp = e.getResponse();
        if (e.getResponseCode() == 400 && resp.indexOf("invalid_grant") > 0) {
            throw new RefreshAccessException("Authentication failure. Reauthenticate.");
        }
    }

    private void initUser() throws BoxException, RefreshAccessException, NotFoundException {
        BoxEnterprise enterprise;
        BoxUser.Info user = this.getCurrentUser();
        String avatarUrl = user.getAvatarURL();
        Matcher m = BOX_URL_CUSTOM_PATTERN.matcher(avatarUrl);
        if (m.matches()) {
            this.customDomain = m.group(1);
        }
        if ((enterprise = user.getEnterprise()) != null) {
            this.enterpriseName = enterprise.getName();
            this.enterpriseId = enterprise.getID();
        }
    }

    private String link(String fileLink) {
        Matcher m;
        if (this.customDomain != null && (m = BOX_URL_MAKE_CUSTOM_PATTERN.matcher(fileLink)).matches()) {
            return m.replaceFirst("$1://" + this.customDomain + ".$2");
        }
        return fileLink;
    }

    static {
        BOX_EVENTS.add(BoxEvent.Type.ITEM_CREATE);
        BOX_EVENTS.add(BoxEvent.Type.ITEM_UPLOAD);
        BOX_EVENTS.add(BoxEvent.Type.ITEM_MOVE);
        BOX_EVENTS.add(BoxEvent.Type.ITEM_COPY);
        BOX_EVENTS.add(BoxEvent.Type.ITEM_TRASH);
        BOX_EVENTS.add(BoxEvent.Type.ITEM_UNDELETE_VIA_TRASH);
        BOX_EVENTS.add(BoxEvent.Type.ITEM_RENAME);
        ITEM_FIELDS = new String[]{"type", "id", "sequence_id", "etag", "name", "description", "size", "path_collection", "created_at", "modified_at", "created_by", "modified_by", "owned_by", "shared_link", "parent", "item_status", "item_collection"};
        USER_FIELDS = new String[]{"type", "id", "name", "login", "created_at", "modified_at", "role", "language", "timezone", "status", "avatar_url", "enterprise"};
    }

    public static class ChangesLink {
        final String type;
        final String url;
        final long maxRetries;
        final long retryTimeout;
        final long ttl;
        final long outdatedTimeout;
        final long created;

        ChangesLink(String type, String url, long ttl, long maxRetries, long retryTimeout) {
            this.type = type;
            this.url = url;
            this.ttl = ttl;
            this.maxRetries = maxRetries;
            this.retryTimeout = retryTimeout;
            this.outdatedTimeout = retryTimeout - (long)Math.round((float)retryTimeout * 0.05f);
            this.created = System.currentTimeMillis();
        }

        public String getType() {
            return this.type;
        }

        public String getUrl() {
            return this.url;
        }

        public long getTtl() {
            return this.ttl;
        }

        public long getMaxRetries() {
            return this.maxRetries;
        }

        public long getRetryTimeout() {
            return this.retryTimeout;
        }

        public long getOutdatedTimeout() {
            return this.outdatedTimeout;
        }

        public long getCreated() {
            return this.created;
        }

        public boolean isOutdated() {
            return System.currentTimeMillis() - this.created > this.outdatedTimeout;
        }
    }

    class EventsIterator
    extends ChunkIterator<BoxEvent> {
        final Set<String> eventIds = new HashSet<String>();
        Long streamPosition;
        Integer offset = 0;
        Integer chunkSize = 0;

        EventsIterator(long streamPosition) throws CloudDriveException {
            this.streamPosition = streamPosition <= -1L ? -1L : streamPosition;
            this.iter = this.nextChunk();
        }

        protected Iterator<BoxEvent> nextChunk() throws CloudDriveException {
            try {
                StringBuilder url = new StringBuilder();
                url.append(BoxAPI.this.api.getBaseURL());
                url.append("events?limit=");
                url.append(100);
                url.append("&stream_position=");
                url.append(this.streamPosition);
                url.append("&stream_type=changes");
                BoxAPIRequest request = new BoxAPIRequest(BoxAPI.this.api, new URL(url.toString()), "GET");
                BoxJSONResponse response = (BoxJSONResponse)request.send();
                JsonObject jsonObject = JsonObject.readFrom((String)response.getJSON());
                JsonArray entries = jsonObject.get("entries").asArray();
                ArrayList<ExoBoxEvent> events = new ArrayList<ExoBoxEvent>();
                for (JsonValue entry : entries) {
                    String id;
                    ExoBoxEvent event = new ExoBoxEvent(BoxAPI.this.api, entry.asObject());
                    if (!BOX_EVENTS.contains(event.getType()) || this.eventIds.contains(id = event.getID())) continue;
                    this.eventIds.add(id);
                    events.add(event);
                }
                this.streamPosition = jsonObject.get("next_stream_position").asLong();
                this.chunkSize = events.size();
                return events.iterator();
            }
            catch (BoxAPIException e) {
                BoxAPI.this.checkTokenState(e);
                throw new BoxException("Error requesting Events service: " + BoxAPI.this.getErrorMessage(e), e);
            }
            catch (MalformedURLException e) {
                throw new CloudDriveException("Error constructing Events service URL: " + e.getMessage(), (Throwable)e);
            }
        }

        protected boolean hasNextChunk() {
            return this.chunkSize > 0;
        }

        long getNextStreamPosition() {
            return this.streamPosition;
        }
    }

    class ItemsIterator
    extends ChunkIterator<BoxItem.Info> {
        final BoxFolder parent;
        long offset = 0L;
        long total = 0L;

        ItemsIterator(String folderId) throws CloudDriveException {
            this.parent = new BoxFolder(BoxAPI.this.api, folderId);
            this.iter = this.nextChunk();
        }

        protected Iterator<BoxItem.Info> nextChunk() throws CloudDriveException {
            try {
                PartialCollection items = this.parent.getChildrenRange(this.offset, 100L, ITEM_FIELDS);
                this.total = items.fullSize();
                if (this.offset == 0L) {
                    this.available(this.total);
                }
                this.offset += (long)items.size();
                return items.iterator();
            }
            catch (BoxAPIException e) {
                BoxAPI.this.checkTokenState(e);
                int status = e.getResponseCode();
                if (status == 404 || status == 412) {
                    throw new NotFoundException("Folder not found " + this.parent.getID(), (Throwable)e);
                }
                throw new BoxException("Error getting folder items: " + BoxAPI.this.getErrorMessage(e), e);
            }
        }

        protected boolean hasNextChunk() {
            return this.total > this.offset;
        }

        BoxFolder.Info getParent() {
            return this.parent.getInfo(ITEM_FIELDS);
        }
    }

    class StoredToken
    extends UserToken
    implements BoxAPIConnectionListener {
        StoredToken() {
        }

        void store() throws CloudDriveException {
            this.store(BoxAPI.this.api.getAccessToken(), BoxAPI.this.api.getRefreshToken(), BoxAPI.this.api.getExpires());
        }

        public void onRefresh(BoxAPIConnection api) {
            try {
                this.store();
            }
            catch (CloudDriveException e) {
                LOG.error((Object)"Error saving access token", (Throwable)e);
            }
        }

        public void onError(BoxAPIConnection api, BoxAPIException error) {
            LOG.error((Object)"Error refreshing access token", (Throwable)error);
        }
    }
}

