/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.shaded.google.api.client.googleapis.auth.oauth2;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.exoplatform.shaded.google.api.client.googleapis.auth.oauth2.SystemEnvironmentProvider;
import org.exoplatform.shaded.google.api.client.http.GenericUrl;
import org.exoplatform.shaded.google.api.client.http.HttpHeaders;
import org.exoplatform.shaded.google.api.client.http.HttpRequest;
import org.exoplatform.shaded.google.api.client.http.HttpResponse;
import org.exoplatform.shaded.google.api.client.http.HttpTransport;
import org.exoplatform.shaded.google.api.client.util.Beta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public class OAuth2Utils {
    static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Logger LOGGER = Logger.getLogger(OAuth2Utils.class.getName());
    private static final String DEFAULT_METADATA_SERVER_URL = "http://169.254.169.254";
    private static final int MAX_COMPUTE_PING_TRIES = 3;
    private static final int COMPUTE_PING_CONNECTION_TIMEOUT_MS = 500;

    static <T extends Throwable> T exceptionWithCause(T exception, Throwable cause) {
        exception.initCause(cause);
        return exception;
    }

    static boolean headersContainValue(HttpHeaders headers, String headerName, String value) {
        Object values = headers.get(headerName);
        if (values instanceof Collection) {
            Collection valuesList = (Collection)values;
            for (Object headerValue : valuesList) {
                if (!(headerValue instanceof String) || !((String)headerValue).equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean runningOnComputeEngine(HttpTransport transport, SystemEnvironmentProvider environment) {
        if (Boolean.parseBoolean(environment.getEnv("NO_GCE_CHECK"))) {
            return false;
        }
        GenericUrl tokenUrl = new GenericUrl(OAuth2Utils.getMetadataServerUrl(environment));
        for (int i = 1; i <= 3; ++i) {
            boolean bl;
            HttpRequest request = transport.createRequestFactory().buildGetRequest(tokenUrl);
            request.setConnectTimeout(500);
            HttpResponse response = request.execute();
            try {
                HttpHeaders headers = response.getHeaders();
                bl = OAuth2Utils.headersContainValue(headers, "Metadata-Flavor", "Google");
            }
            catch (Throwable throwable) {
                try {
                    response.disconnect();
                    throw throwable;
                }
                catch (SocketTimeoutException expected) {
                    continue;
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to detect whether we are running on Google Compute Engine.", e);
                }
            }
            response.disconnect();
            return bl;
        }
        return false;
    }

    public static String getMetadataServerUrl() {
        return OAuth2Utils.getMetadataServerUrl(SystemEnvironmentProvider.INSTANCE);
    }

    static String getMetadataServerUrl(SystemEnvironmentProvider environment) {
        String metadataServerAddress = environment.getEnv("GCE_METADATA_HOST");
        if (metadataServerAddress != null) {
            return "http://" + metadataServerAddress;
        }
        return DEFAULT_METADATA_SERVER_URL;
    }
}

