/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.fileproperties.PropertyGroup;
import com.dropbox.core.v2.files.CommitInfo;
import com.dropbox.core.v2.files.WriteMode;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Date;
import java.util.List;

class CommitInfoWithProperties
extends CommitInfo {
    public CommitInfoWithProperties(String path, WriteMode mode, boolean autorename, Date clientModified, boolean mute, List<PropertyGroup> propertyGroups) {
        super(path, mode, autorename, clientModified, mute, propertyGroups);
    }

    public CommitInfoWithProperties(String path) {
        this(path, WriteMode.ADD, false, null, false, null);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public WriteMode getMode() {
        return this.mode;
    }

    @Override
    public boolean getAutorename() {
        return this.autorename;
    }

    @Override
    public Date getClientModified() {
        return this.clientModified;
    }

    @Override
    public boolean getMute() {
        return this.mute;
    }

    @Override
    public List<PropertyGroup> getPropertyGroups() {
        return this.propertyGroups;
    }

    public static Builder newBuilder(String path) {
        return new Builder(path);
    }

    @Override
    public int hashCode() {
        return this.getClass().toString().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            CommitInfoWithProperties other = (CommitInfoWithProperties)obj;
            return !(this.path != other.path && !this.path.equals(other.path) || this.mode != other.mode && !this.mode.equals(other.mode) || this.autorename != other.autorename || this.clientModified != other.clientModified && (this.clientModified == null || !this.clientModified.equals(other.clientModified)) || this.mute != other.mute || this.propertyGroups != other.propertyGroups && (this.propertyGroups == null || !this.propertyGroups.equals(other.propertyGroups)));
        }
        return false;
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    @Override
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<CommitInfoWithProperties> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(CommitInfoWithProperties value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("path");
            StoneSerializers.string().serialize(value.path, g);
            g.writeFieldName("mode");
            WriteMode.Serializer.INSTANCE.serialize(value.mode, g);
            g.writeFieldName("autorename");
            StoneSerializers.boolean_().serialize((Boolean)value.autorename, g);
            if (value.clientModified != null) {
                g.writeFieldName("client_modified");
                StoneSerializers.nullable(StoneSerializers.timestamp()).serialize(value.clientModified, g);
            }
            g.writeFieldName("mute");
            StoneSerializers.boolean_().serialize((Boolean)value.mute, g);
            if (value.propertyGroups != null) {
                g.writeFieldName("property_groups");
                StoneSerializers.nullable(StoneSerializers.list(PropertyGroup.Serializer.INSTANCE)).serialize((List<PropertyGroup>)value.propertyGroups, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public CommitInfoWithProperties deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            List<PropertyGroup> f_propertyGroups;
            Boolean f_mute;
            Date f_clientModified;
            Boolean f_autorename;
            WriteMode f_mode;
            String f_path;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_path = null;
                f_mode = WriteMode.ADD;
                f_autorename = false;
                f_clientModified = null;
                f_mute = false;
                f_propertyGroups = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("path".equals(field)) {
                        f_path = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("mode".equals(field)) {
                        f_mode = WriteMode.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("autorename".equals(field)) {
                        f_autorename = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("client_modified".equals(field)) {
                        f_clientModified = StoneSerializers.nullable(StoneSerializers.timestamp()).deserialize(p);
                        continue;
                    }
                    if ("mute".equals(field)) {
                        f_mute = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("property_groups".equals(field)) {
                        f_propertyGroups = StoneSerializers.nullable(StoneSerializers.list(PropertyGroup.Serializer.INSTANCE)).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_path == null) {
                    throw new JsonParseException(p, "Required field \"path\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            CommitInfoWithProperties value = new CommitInfoWithProperties(f_path, f_mode, f_autorename, f_clientModified, f_mute, f_propertyGroups);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static class Builder
    extends CommitInfo.Builder {
        protected Builder(String path) {
            super(path);
        }

        @Override
        public Builder withMode(WriteMode mode) {
            super.withMode(mode);
            return this;
        }

        @Override
        public Builder withAutorename(Boolean autorename) {
            super.withAutorename(autorename);
            return this;
        }

        @Override
        public Builder withClientModified(Date clientModified) {
            super.withClientModified(clientModified);
            return this;
        }

        @Override
        public Builder withMute(Boolean mute) {
            super.withMute(mute);
            return this;
        }

        @Override
        public Builder withPropertyGroups(List<PropertyGroup> propertyGroups) {
            super.withPropertyGroups(propertyGroups);
            return this;
        }

        @Override
        public CommitInfoWithProperties build() {
            return new CommitInfoWithProperties(this.path, this.mode, this.autorename, this.clientModified, this.mute, this.propertyGroups);
        }
    }
}

