/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.users.Team;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class TeamMemberInfo {
    protected final Team teamInfo;
    protected final String displayName;
    protected final String memberId;

    public TeamMemberInfo(Team teamInfo, String displayName, String memberId) {
        if (teamInfo == null) {
            throw new IllegalArgumentException("Required value for 'teamInfo' is null");
        }
        this.teamInfo = teamInfo;
        if (displayName == null) {
            throw new IllegalArgumentException("Required value for 'displayName' is null");
        }
        this.displayName = displayName;
        this.memberId = memberId;
    }

    public TeamMemberInfo(Team teamInfo, String displayName) {
        this(teamInfo, displayName, null);
    }

    public Team getTeamInfo() {
        return this.teamInfo;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getMemberId() {
        return this.memberId;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.teamInfo, this.displayName, this.memberId});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            TeamMemberInfo other = (TeamMemberInfo)obj;
            return !(this.teamInfo != other.teamInfo && !this.teamInfo.equals(other.teamInfo) || this.displayName != other.displayName && !this.displayName.equals(other.displayName) || this.memberId != other.memberId && (this.memberId == null || !this.memberId.equals(other.memberId)));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<TeamMemberInfo> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(TeamMemberInfo value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("team_info");
            Team.Serializer.INSTANCE.serialize(value.teamInfo, g);
            g.writeFieldName("display_name");
            StoneSerializers.string().serialize(value.displayName, g);
            if (value.memberId != null) {
                g.writeFieldName("member_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.memberId, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public TeamMemberInfo deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_memberId;
            String f_displayName;
            Team f_teamInfo;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_teamInfo = null;
                f_displayName = null;
                f_memberId = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("team_info".equals(field)) {
                        f_teamInfo = (Team)Team.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("display_name".equals(field)) {
                        f_displayName = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("member_id".equals(field)) {
                        f_memberId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_teamInfo == null) {
                    throw new JsonParseException(p, "Required field \"team_info\" missing.");
                }
                if (f_displayName == null) {
                    throw new JsonParseException(p, "Required field \"display_name\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            TeamMemberInfo value = new TeamMemberInfo(f_teamInfo, f_displayName, f_memberId);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

