/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.teamlog.UserLogInfo;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class TeamMemberLogInfo
extends UserLogInfo {
    protected final String teamMemberId;
    protected final String memberExternalId;

    public TeamMemberLogInfo(String accountId, String displayName, String email, String teamMemberId, String memberExternalId) {
        super(accountId, displayName, email);
        this.teamMemberId = teamMemberId;
        if (memberExternalId != null && memberExternalId.length() > 64) {
            throw new IllegalArgumentException("String 'memberExternalId' is longer than 64");
        }
        this.memberExternalId = memberExternalId;
    }

    public TeamMemberLogInfo() {
        this(null, null, null, null, null);
    }

    @Override
    public String getAccountId() {
        return this.accountId;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    public String getTeamMemberId() {
        return this.teamMemberId;
    }

    public String getMemberExternalId() {
        return this.memberExternalId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.teamMemberId, this.memberExternalId});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            TeamMemberLogInfo other = (TeamMemberLogInfo)obj;
            return (this.accountId == other.accountId || this.accountId != null && this.accountId.equals(other.accountId)) && (this.displayName == other.displayName || this.displayName != null && this.displayName.equals(other.displayName)) && (this.email == other.email || this.email != null && this.email.equals(other.email)) && (this.teamMemberId == other.teamMemberId || this.teamMemberId != null && this.teamMemberId.equals(other.teamMemberId)) && (this.memberExternalId == other.memberExternalId || this.memberExternalId != null && this.memberExternalId.equals(other.memberExternalId));
        }
        return false;
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    @Override
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<TeamMemberLogInfo> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(TeamMemberLogInfo value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            this.writeTag("team_member", g);
            if (value.accountId != null) {
                g.writeFieldName("account_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.accountId, g);
            }
            if (value.displayName != null) {
                g.writeFieldName("display_name");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.displayName, g);
            }
            if (value.email != null) {
                g.writeFieldName("email");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.email, g);
            }
            if (value.teamMemberId != null) {
                g.writeFieldName("team_member_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.teamMemberId, g);
            }
            if (value.memberExternalId != null) {
                g.writeFieldName("member_external_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.memberExternalId, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public TeamMemberLogInfo deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_memberExternalId;
            String f_teamMemberId;
            String f_email;
            String f_displayName;
            String f_accountId;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
                if ("team_member".equals(tag)) {
                    tag = null;
                }
            }
            if (tag == null) {
                f_accountId = null;
                f_displayName = null;
                f_email = null;
                f_teamMemberId = null;
                f_memberExternalId = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("account_id".equals(field)) {
                        f_accountId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("display_name".equals(field)) {
                        f_displayName = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("email".equals(field)) {
                        f_email = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("team_member_id".equals(field)) {
                        f_teamMemberId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("member_external_id".equals(field)) {
                        f_memberExternalId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            TeamMemberLogInfo value = new TeamMemberLogInfo(f_accountId, f_displayName, f_email, f_teamMemberId, f_memberExternalId);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static class Builder
    extends UserLogInfo.Builder {
        protected String teamMemberId = null;
        protected String memberExternalId = null;

        protected Builder() {
        }

        public Builder withTeamMemberId(String teamMemberId) {
            this.teamMemberId = teamMemberId;
            return this;
        }

        public Builder withMemberExternalId(String memberExternalId) {
            if (memberExternalId != null && memberExternalId.length() > 64) {
                throw new IllegalArgumentException("String 'memberExternalId' is longer than 64");
            }
            this.memberExternalId = memberExternalId;
            return this;
        }

        @Override
        public Builder withAccountId(String accountId) {
            super.withAccountId(accountId);
            return this;
        }

        @Override
        public Builder withDisplayName(String displayName) {
            super.withDisplayName(displayName);
            return this;
        }

        @Override
        public Builder withEmail(String email) {
            super.withEmail(email);
            return this;
        }

        @Override
        public TeamMemberLogInfo build() {
            return new TeamMemberLogInfo(this.accountId, this.displayName, this.email, this.teamMemberId, this.memberExternalId);
        }
    }
}

