/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.jcr;

import com.ibm.icu.text.Transliterator;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.clouddrive.BaseCloudDriveListener;
import org.exoplatform.clouddrive.CannotConnectDriveException;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveEnvironment;
import org.exoplatform.clouddrive.CloudDriveEvent;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudDriveMessage;
import org.exoplatform.clouddrive.CloudDriveSecurity;
import org.exoplatform.clouddrive.CloudDriveStorage;
import org.exoplatform.clouddrive.CloudFile;
import org.exoplatform.clouddrive.CloudFileAPI;
import org.exoplatform.clouddrive.CloudFileSynchronizer;
import org.exoplatform.clouddrive.CloudProviderException;
import org.exoplatform.clouddrive.CloudUser;
import org.exoplatform.clouddrive.ConflictException;
import org.exoplatform.clouddrive.ConstraintException;
import org.exoplatform.clouddrive.DriveRemovedException;
import org.exoplatform.clouddrive.DriveTrashedException;
import org.exoplatform.clouddrive.FileTrashRemovedException;
import org.exoplatform.clouddrive.NotCloudDriveException;
import org.exoplatform.clouddrive.NotCloudFileException;
import org.exoplatform.clouddrive.NotConnectedException;
import org.exoplatform.clouddrive.NotFoundException;
import org.exoplatform.clouddrive.NotYetCloudFileException;
import org.exoplatform.clouddrive.RefreshAccessException;
import org.exoplatform.clouddrive.RetryLaterException;
import org.exoplatform.clouddrive.SkipChangeException;
import org.exoplatform.clouddrive.SkipSyncException;
import org.exoplatform.clouddrive.SyncNotSupportedException;
import org.exoplatform.clouddrive.ThreadExecutor;
import org.exoplatform.clouddrive.jcr.JCRLocalCloudFile;
import org.exoplatform.clouddrive.jcr.LostRemovalSynchronizer;
import org.exoplatform.clouddrive.jcr.NodeFinder;
import org.exoplatform.clouddrive.utils.ChunkIterator;
import org.exoplatform.clouddrive.utils.ExtendedMimeTypeResolver;
import org.exoplatform.clouddrive.utils.IdentityHelper;
import org.exoplatform.clouddrive.viewer.ContentReader;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.security.ConversationState;

public abstract class JCRLocalCloudDrive
extends CloudDrive
implements CloudDriveStorage,
CloudDriveSecurity {
    public static final String ECD_CLOUDDRIVE = "ecd:cloudDrive";
    public static final String ECD_CLOUDFILE = "ecd:cloudFile";
    public static final String ECD_CLOUDFOLDER = "ecd:cloudFolder";
    public static final String ECD_CLOUDFILERESOURCE = "ecd:cloudFileResource";
    public static final String ECD_IGNORED = "ecd:ignored";
    public static final String EXO_DATETIME = "exo:datetime";
    public static final String EXO_MODIFY = "exo:modify";
    public static final String EXO_TRASHFOLDER = "exo:trashFolder";
    public static final String EXO_THUMBNAILS = "exo:thumbnails";
    public static final String EXO_THUMBNAIL = "exo:thumbnail";
    public static final String NT_FOLDER = "nt:folder";
    public static final String NT_FILE = "nt:file";
    public static final String NT_RESOURCE = "nt:resource";
    public static final String NT_UNSTRUCTURED = "nt:unstructured";
    public static final String MIX_REFERENCEABLE = "mix:referenceable";
    public static final String MIX_VERSIONABLE = "mix:versionable";
    public static final String ECD_LOCALFORMAT = "ecd:localFormat";
    public static final double CURRENT_LOCALFORMAT = 1.1;
    public static final long HISTORY_EXPIRATION = 691200000L;
    public static final int HISTORY_MAX_LENGTH = 1000;
    public static final int COMMAND_CHANGES_CHUNK = 15;
    public static final String DUMMY_DATA = "".intern();
    public static final String USER_WORKSPACE = "user.workspace";
    public static final String USER_NODEPATH = "user.nodePath";
    public static final String USER_SESSIONPROVIDER = "user.sessionProvider";
    protected static final CloudDrive.Command ALREADY_DONE = new AlreadyDone();
    protected static final ThreadLocal<CloudDrive> actionDrive = new ThreadLocal();
    protected static final Transliterator accentsConverter = Transliterator.getInstance((String)"Latin; NFD; [:Nonspacing Mark:] Remove; NFC;");
    protected final String rootWorkspace;
    protected final ManageableRepository repository;
    protected final SessionProviderService sessionProviders;
    protected final CloudUser user;
    protected final String rootUUID;
    protected final ThreadLocal<SoftReference<Node>> rootNodeHolder;
    protected final ThreadLocal<SoftReference<Node>> rootSystemNodeHolder;
    protected final JCRListener jcrListener;
    protected final ConnectCommand noConnect = new NoConnectCommand();
    protected final AtomicReference<ConnectCommand> currentConnect = new AtomicReference<ConnectCommand>(this.noConnect);
    protected final SyncCommand noSync = new NoSyncCommand();
    protected final AtomicReference<SyncCommand> currentSync = new AtomicReference<SyncCommand>(this.noSync);
    protected final AtomicReference<SyncFilesCommand> delayedSyncFiles = new AtomicReference();
    protected final ReadWriteLock syncLock = new ReentrantReadWriteLock(true);
    protected final ConcurrentHashMap<String, FileChange> fileChanges = new ConcurrentHashMap();
    protected final ThreadLocal<Map<String, FileChange>> fileRemovals = new ThreadLocal();
    protected final ConcurrentHashMap<String, String> fileCopies = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, FileTrashing> fileTrash = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, Set<String>> fileHistory = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, AtomicLong> updating = new ConcurrentHashMap();
    protected final AtomicLong currentChangeId = new AtomicLong(-1L);
    protected final AtomicLong fileChangeSequencer = new AtomicLong(1L);
    protected final ThreadExecutor workerExecutor = ThreadExecutor.getInstance();
    protected final CloudDriveEnvironment commandEnv = new ExoJCREnvironment();
    protected final Set<CloudFileSynchronizer> fileSynchronizers = new LinkedHashSet<CloudFileSynchronizer>();
    protected final CloudFileAPI fileAPI;
    protected final NodeFinder finder;
    protected final ExtendedMimeTypeResolver mimeTypes;
    protected final Queue<CloudDriveMessage> syncFilesMessages = new ConcurrentLinkedQueue<CloudDriveMessage>();
    protected final Queue<CloudDrive.Command> driveCommands = new ConcurrentLinkedQueue<CloudDrive.Command>();
    protected DriveState state = new DriveState();
    private String titleCached;

    protected JCRLocalCloudDrive(CloudUser user, Node driveNode, SessionProviderService sessionProviders, NodeFinder finder, ExtendedMimeTypeResolver mimeTypes) throws CloudDriveException, RepositoryException {
        boolean existing;
        this.user = user;
        this.sessionProviders = sessionProviders;
        this.finder = finder;
        this.mimeTypes = mimeTypes;
        Session session = driveNode.getSession();
        this.repository = (ManageableRepository)session.getRepository();
        this.rootWorkspace = session.getWorkspace().getName();
        this.fileAPI = this.createFileAPI();
        if (driveNode.isNodeType(ECD_CLOUDDRIVE)) {
            this.ensureSame(user, driveNode);
            if (driveNode.hasProperty("exo:title")) {
                this.titleCached = driveNode.getProperty("exo:title").getString();
            }
            existing = true;
        } else {
            try {
                this.initDrive(driveNode);
                driveNode.save();
            }
            catch (RepositoryException e) {
                this.rollback(driveNode);
                throw e;
            }
            catch (RuntimeException e) {
                this.rollback(driveNode);
                throw e;
            }
            existing = false;
        }
        this.rootUUID = driveNode.getUUID();
        this.rootNodeHolder = new ThreadLocal();
        this.rootNodeHolder.set(new SoftReference<Node>(driveNode));
        this.rootSystemNodeHolder = new ThreadLocal();
        this.jcrListener = this.addJCRListener(driveNode);
        this.addListener(this.jcrListener.changesListener);
        if (existing) {
            this.loadHistory();
        }
    }

    @Override
    public String getTitle() throws DriveRemovedException, RepositoryException {
        return this.rootNode(true).getProperty("exo:title").getString();
    }

    @Override
    public String getLink() throws DriveRemovedException, NotConnectedException, RepositoryException {
        Node rootNode = this.rootNode(true);
        try {
            return rootNode.getProperty("ecd:url").getString();
        }
        catch (PathNotFoundException e) {
            if (rootNode.getProperty("ecd:connected").getBoolean()) {
                throw e;
            }
            throw new NotConnectedException("Drive not connected " + this.title());
        }
    }

    @Override
    public String getId() throws DriveRemovedException, NotConnectedException, RepositoryException {
        Node rootNode = this.rootNode(true);
        try {
            return rootNode.getProperty("ecd:id").getString();
        }
        catch (PathNotFoundException e) {
            if (rootNode.getProperty("ecd:connected").getBoolean()) {
                throw e;
            }
            throw new NotConnectedException("Drive not connected " + this.title());
        }
    }

    @Override
    public String getLocalUser() throws DriveRemovedException, RepositoryException {
        return this.rootNode(true).getProperty("ecd:localUserName").getString();
    }

    @Override
    public Calendar getInitDate() throws DriveRemovedException, RepositoryException {
        return this.rootNode(true).getProperty("ecd:initDate").getDate();
    }

    @Override
    public String getPath() throws DriveRemovedException, RepositoryException {
        return this.rootNode(true).getPath();
    }

    @Override
    public String getWorkspace() throws DriveRemovedException, RepositoryException {
        return this.rootNode(true).getSession().getWorkspace().getName();
    }

    @Override
    public Calendar getConnectDate() throws DriveRemovedException, NotConnectedException, RepositoryException {
        if (this.isConnected()) {
            return this.rootNode(true).getProperty("ecd:connectDate").getDate();
        }
        throw new NotConnectedException("Drive '" + this.title() + "' not connected.");
    }

    @Override
    public CloudDrive.Command connect() throws CloudDriveException, RepositoryException {
        if (this.isConnected()) {
            return ALREADY_DONE;
        }
        ConnectCommand connect = this.getConnectCommand();
        if (this.currentConnect.compareAndSet(this.noConnect, connect)) {
            connect.start();
        } else {
            ConnectCommand existingConnect = this.currentConnect.get();
            if (existingConnect != this.noConnect) {
                connect = existingConnect;
            } else {
                connect.start();
            }
        }
        return connect;
    }

    @Override
    public CloudFile getFile(String path) throws DriveRemovedException, NotCloudDriveException, NotCloudFileException, NotYetCloudFileException, RepositoryException {
        Node driveNode = this.rootNode(true);
        Item target = this.finder.findItem(driveNode.getSession(), path);
        String nodePath = target.getPath();
        String drivePath = driveNode.getPath();
        if (nodePath.length() > drivePath.length() && nodePath.startsWith(drivePath)) {
            if (target.isNode()) {
                Node fileNode = this.fileNode((Node)target);
                if (fileNode != null) {
                    return this.readFile(fileNode);
                }
                if (this.isNewOrUpdating(nodePath)) {
                    throw new NotYetCloudFileException("Node '" + path + "' is creating in cloud but not yet a cloud file.");
                }
                throw new NotCloudFileException("Node '" + path + "' is not a cloud file.");
            }
            throw new NotCloudFileException("Item at path '" + path + "' is Property and cannot be treatet as cloud file.");
        }
        if (nodePath.equals(drivePath)) {
            throw new NotCloudFileException("Item at path '" + path + "' is a drive root.");
        }
        throw new NotCloudDriveException("Item at path '" + path + "' does not belong to Cloud Drive '" + this.title() + "'");
    }

    @Override
    public boolean hasFile(String path) throws DriveRemovedException, RepositoryException {
        block3: {
            Node driveNode = this.rootNode(true);
            try {
                Item target = this.finder.findItem(driveNode.getSession(), path);
                String nodePath = target.getPath();
                String drivePath = driveNode.getPath();
                if (nodePath.length() > drivePath.length() && nodePath.startsWith(drivePath) && target.isNode()) {
                    return this.fileNode((Node)target) != null;
                }
            }
            catch (ItemNotFoundException | PathNotFoundException e) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug((Object)("File not found in drive " + this.title() + ": " + path + ". " + e.getMessage()));
            }
        }
        return false;
    }

    public List<CloudFile> listFiles() throws DriveRemovedException, CloudDriveException, RepositoryException {
        return this.listFiles(this.rootNode(true));
    }

    @Override
    public boolean isLocal(Node node) throws RepositoryException, DriveRemovedException {
        String nodePath = node.getPath();
        String drivePath = this.rootNode(true).getPath();
        if (nodePath.length() > drivePath.length() && nodePath.startsWith(drivePath)) {
            return !this.fileAPI.isFile(node) && !this.fileAPI.isIgnored(node) && !this.isUpdating(nodePath);
        }
        return false;
    }

    @Override
    public boolean isIgnored(Node node) throws RepositoryException, NotCloudDriveException, NotCloudFileException, DriveRemovedException {
        String nodePath = node.getPath();
        String drivePath = this.rootNode(true).getPath();
        if (nodePath.length() > drivePath.length() && nodePath.startsWith(drivePath)) {
            return this.fileAPI.isIgnored(node);
        }
        if (nodePath.equals(drivePath)) {
            throw new NotCloudFileException("Item at path " + nodePath + " is a drive root.");
        }
        throw new NotCloudDriveException("Not in cloud drive " + nodePath);
    }

    @Override
    public boolean ignore(Node node) throws RepositoryException, DriveRemovedException, NotCloudDriveException, NotCloudFileException {
        String nodePath = node.getPath();
        String drivePath = this.rootNode().getPath();
        if (nodePath.length() > drivePath.length() && nodePath.startsWith(drivePath)) {
            if (this.fileAPI.isFile(node)) {
                boolean res = this.fileAPI.ignore(node);
                if (res) {
                    node.save();
                }
                return res;
            }
            throw new NotCloudFileException("Not cloud file " + drivePath);
        }
        throw new NotCloudDriveException("Not in cloud drive " + drivePath);
    }

    @Override
    public boolean unignore(Node node) throws RepositoryException, NotCloudDriveException, DriveRemovedException, NotCloudFileException {
        String nodePath = node.getPath();
        String drivePath = this.rootNode().getPath();
        if (nodePath.length() > drivePath.length() && nodePath.startsWith(drivePath)) {
            if (this.fileAPI.isFile(node)) {
                boolean res = this.fileAPI.unignore(node);
                if (res) {
                    node.save();
                }
                return res;
            }
            throw new NotCloudFileException("Not cloud file " + drivePath);
        }
        throw new NotCloudFileException("Not in cloud drive " + drivePath);
    }

    @Override
    public boolean create(Node node) throws RepositoryException, NotCloudDriveException, DriveRemovedException, CloudDriveException {
        String nodePath = node.getPath();
        String drivePath = this.rootNode().getPath();
        if (nodePath.length() > drivePath.length() && nodePath.startsWith(drivePath)) {
            boolean res;
            if (this.fileAPI.isFile(node)) {
                res = false;
            } else if (this.fileAPI.isIgnored(node)) {
                res = false;
            } else if (!this.isUpdating(nodePath)) {
                ArrayList<FileChange> changes = new ArrayList<FileChange>();
                changes.add(new FileChange(nodePath, "A"));
                new SyncFilesCommand(changes).start();
                res = true;
            } else {
                res = true;
            }
            return res;
        }
        if (nodePath.equals(drivePath)) {
            throw new NotCloudFileException("Item at path " + nodePath + " is a drive root.");
        }
        throw new NotCloudDriveException("Not in cloud drive " + nodePath);
    }

    @Override
    public CloudDrive.Command getCurentCommand() {
        CloudDrive.Command cmd = this.currentConnect.get();
        if (cmd == this.noConnect) {
            cmd = this.currentSync.get();
        }
        return cmd;
    }

    @Override
    public void await() throws ExecutionException, InterruptedException {
        for (CloudDrive.Command c : this.driveCommands) {
            c.await();
        }
    }

    @Override
    public <R> R localChange(CloudDriveStorage.Change<R> change) throws NotCloudDriveException, DriveRemovedException, RepositoryException, CloudDriveException {
        try {
            this.jcrListener.disable();
            R r = change.apply();
            return r;
        }
        finally {
            this.jcrListener.enable();
        }
    }

    @Override
    public ContentReader getFileContent(String fileId) throws RepositoryException, CloudDriveException {
        return null;
    }

    @Override
    public ContentReader getFilePreview(String fileId) throws RepositoryException, CloudDriveException {
        return null;
    }

    @Override
    public void shareFile(Node fileNode, String ... users) throws RepositoryException, CloudDriveException {
        throw new CloudDriveException("Sharing not supported");
    }

    @Override
    public void unshareFile(Node fileNode, String ... users) throws RepositoryException, CloudDriveException {
        throw new CloudDriveException("Sharing not supported");
    }

    @Override
    public boolean isSharingSupported() {
        return false;
    }

    protected abstract ConnectCommand getConnectCommand() throws DriveRemovedException, RepositoryException;

    protected abstract SyncCommand getSyncCommand() throws DriveRemovedException, SyncNotSupportedException, RepositoryException;

    protected abstract CloudFileAPI createFileAPI() throws DriveRemovedException, SyncNotSupportedException, RepositoryException;

    protected void initDrive(Node rootNode) throws CloudDriveException, RepositoryException {
        rootNode.addMixin(ECD_CLOUDDRIVE);
        if (!rootNode.hasProperty("exo:title")) {
            this.titleCached = this.getUser().createDriveTitle();
            rootNode.setProperty("exo:title", this.titleCached);
        } else {
            this.titleCached = rootNode.getProperty("exo:title").getString();
        }
        rootNode.setProperty("ecd:connected", false);
        rootNode.setProperty("ecd:localUserName", this.currentUserName());
        rootNode.setProperty("ecd:initDate", Calendar.getInstance());
        rootNode.setProperty("ecd:provider", this.getUser().getProvider().getId());
        rootNode.setProperty("ecd:id", DUMMY_DATA);
        rootNode.setProperty("ecd:url", DUMMY_DATA);
        rootNode.setProperty(ECD_LOCALFORMAT, 1.1);
    }

    protected List<CloudFile> listFiles(Node parentNode) throws RepositoryException {
        ArrayList<CloudFile> files = new ArrayList<CloudFile>();
        NodeIterator fileNodes = parentNode.getNodes();
        while (fileNodes.hasNext()) {
            Node fileNode = fileNodes.nextNode();
            if (!fileNode.isNodeType(ECD_CLOUDFILE)) continue;
            JCRLocalCloudFile local = this.readFile(fileNode);
            files.add(local);
            if (!local.isFolder()) continue;
            files.addAll(this.listFiles(fileNode));
        }
        return files;
    }

    private synchronized void disconnect(Node driveNode) throws CloudDriveException, RepositoryException {
        try {
            try {
                driveNode.setProperty("ecd:connected", false);
                driveNode.getProperty("ecd:connected").save();
                NodeIterator niter = driveNode.getNodes();
                while (niter.hasNext()) {
                    Node node = niter.nextNode();
                    this.removeLinks(node);
                    node.remove();
                }
                driveNode.save();
            }
            catch (RepositoryException e) {
                this.rollback(driveNode);
                throw e;
            }
            catch (RuntimeException e) {
                this.rollback(driveNode);
                throw e;
            }
        }
        catch (ItemNotFoundException e) {
            throw new DriveRemovedException("Drive '" + this.title() + "' was removed.", e);
        }
    }

    @Override
    protected void disconnect() throws CloudDriveException, RepositoryException {
        if (this.isConnected()) {
            Node driveRoot = this.rootNode();
            this.disconnect(driveRoot);
            this.listeners.fireOnDisconnect(new CloudDriveEvent(this.getUser(), this.rootWorkspace, driveRoot.getPath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloudDrive.Command synchronize() throws SyncNotSupportedException, DriveRemovedException, CloudDriveException, RepositoryException {
        if (this.isConnected()) {
            String currentUser = this.currentUserName();
            String driveOwner = this.rootNode(true).getProperty("ecd:localUserName").getString();
            if (driveOwner.equals(currentUser)) {
                this.refreshAccess();
                SyncCommand sync = this.getSyncCommand();
                if (!this.currentSync.compareAndSet(this.noSync, sync)) {
                    AtomicReference<SyncCommand> atomicReference = this.currentSync;
                    synchronized (atomicReference) {
                        SyncCommand existingSync = this.currentSync.get();
                        if (existingSync != this.noSync) {
                            return existingSync;
                        }
                        this.currentSync.set(sync);
                    }
                }
                sync.start();
                return sync;
            }
            return this.currentSync.get();
        }
        throw new NotConnectedException("Cloud drive '" + this.title() + "' not connected.");
    }

    @Override
    public boolean isConnected() throws DriveRemovedException, RepositoryException {
        return this.rootNode(true).getProperty("ecd:connected").getBoolean();
    }

    @Override
    public boolean isDrive(Node node) throws DriveRemovedException, RepositoryException {
        Node driveNode = this.rootNode(true);
        if (driveNode.getSession().getWorkspace().getName().equals(node.getSession().getWorkspace().getName())) {
            return this.isSameDrive(node);
        }
        return false;
    }

    @Override
    public CloudDrive.FilesState getState() throws DriveRemovedException, RefreshAccessException, CloudProviderException, RepositoryException {
        return this.state;
    }

    @Override
    protected void initRemove(Node node) throws SyncNotSupportedException, CloudDriveException, RepositoryException {
        if (!this.fileAPI.isIgnored(node) && this.fileAPI.isFile(node)) {
            Map<String, FileChange> planned;
            String path = node.getPath();
            String id = this.fileAPI.getId(node);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Init file removal " + id + " " + path));
            }
            FileChange remove = new FileChange(path, id, this.fileAPI.isFolder(node), "D", this.synchronizer(node));
            if (node.isNodeType(MIX_REFERENCEABLE)) {
                remove.setFileUUID(node.getUUID());
            }
            if ((planned = this.fileRemovals.get()) == null) {
                planned = new ConcurrentHashMap<String, FileChange>();
                this.fileRemovals.set(planned);
            }
            planned.put(path, remove);
        }
    }

    @Override
    protected void initCopy(Node file, Node destParent) throws RepositoryException, CloudDriveException {
        String filePath = file.getPath();
        String fileId = this.fileAPI.getId(file);
        this.fileCopies.put(fileId, filePath);
    }

    CloudFileSynchronizer synchronizer(Node file) throws RepositoryException, SkipSyncException, SyncNotSupportedException {
        for (CloudFileSynchronizer s : this.fileSynchronizers) {
            if (!s.accept(file)) continue;
            return s;
        }
        throw new SyncNotSupportedException("Synchronization not supported for file type " + file.getPrimaryNodeType().getName() + " in node " + file.getPath());
    }

    CloudFileSynchronizer synchronizer(Class<?> clazz) throws RepositoryException, SkipSyncException, SyncNotSupportedException {
        for (CloudFileSynchronizer s : this.fileSynchronizers) {
            if (!clazz.isAssignableFrom(s.getClass())) continue;
            return s;
        }
        if (LostRemovalSynchronizer.class.equals(clazz)) {
            return new LostRemovalSynchronizer();
        }
        throw new SyncNotSupportedException("Synchronizer cannot be found " + clazz.getName());
    }

    private void addChanged(String fileId, String changeType) throws RepositoryException, CloudDriveException {
        Set<String> existing;
        Set<String> changes = this.fileHistory.get(fileId);
        if (changes == null && (existing = this.fileHistory.putIfAbsent(fileId, changes = new LinkedHashSet<String>())) != null) {
            changes = existing;
        }
        changes.add(changeType + this.getChangeId());
    }

    private boolean hasChanged(String fileId, String ... changeTypes) throws RepositoryException, CloudDriveException {
        Set<String> changes = this.fileHistory.get(fileId);
        if (changes != null) {
            long changeId = this.getChangeId();
            for (String changeType : changeTypes) {
                if (!changes.contains(changeType + changeId)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean hasUpdated(String fileId) throws RepositoryException, CloudDriveException {
        return this.hasChanged(fileId, "U", "A");
    }

    protected boolean hasRemoved(String fileId) throws RepositoryException, CloudDriveException {
        return this.hasChanged(fileId, "D");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanChanged(String fileId, String ... changeTypes) throws RepositoryException, CloudDriveException {
        Set<String> changes = this.fileHistory.get(fileId);
        if (changes != null) {
            long changeId = this.getChangeId();
            for (String changeType : changeTypes) {
                changes.remove(changeType + changeId);
            }
            if (changes.size() == 0) {
                Set<String> set = changes;
                synchronized (set) {
                    if (changes.size() == 0) {
                        this.fileHistory.remove(fileId);
                    }
                }
            }
        }
    }

    protected void cleanUpdated(String fileId) throws RepositoryException, CloudDriveException {
        this.cleanChanged(fileId, "U", "A");
    }

    protected void cleanRemoved(String fileId) throws RepositoryException, CloudDriveException {
        this.cleanChanged(fileId, "D");
    }

    protected String nextChangeId() throws RepositoryException, CloudDriveException {
        Long driveChangeId = this.getChangeId();
        return driveChangeId.toString() + '-' + this.fileChangeSequencer.getAndIncrement();
    }

    protected synchronized void saveChanges(List<FileChange> changes) throws RepositoryException, CloudDriveException {
        StringBuilder store = new StringBuilder();
        for (FileChange ch : changes) {
            store.append(ch.changeId);
            store.append('=');
            store.append(ch.changeType);
            store.append(ch.isFolder ? (char)'Y' : 'N');
            store.append(String.format("%010d", ch.path.length()));
            store.append(ch.path);
            if (ch.fileId != null) {
                if (ch.fileId.length() > 9999) {
                    throw new CloudDriveException("File id too long (greater of 4 digits): " + ch.fileId);
                }
                store.append('I');
                store.append(String.format("%04d", ch.fileId.length()));
                store.append(ch.fileId);
            }
            if (ch.synchronizer != null) {
                store.append('S');
                store.append(ch.synchronizer.getClass().getName());
            }
            store.append('\n');
        }
        Node driveNode = this.rootNode();
        try {
            Property localChanges = driveNode.getProperty("ecd:localChanges");
            String current = localChanges.getString();
            if (current.length() > 0) {
                store.insert(0, current);
            }
            localChanges.setValue(store.toString());
            localChanges.save();
        }
        catch (PathNotFoundException e) {
            driveNode.setProperty("ecd:localChanges", store.toString());
            driveNode.save();
        }
    }

    protected synchronized void commitChanges(Collection<FileChange> changes, Collection<FileChange> skipped) throws RepositoryException, CloudDriveException {
        Node driveNode = this.rootNode();
        Long timestamp = System.currentTimeMillis();
        StringBuilder store = new StringBuilder();
        StringBuilder history = new StringBuilder();
        try {
            Property localChanges = driveNode.getProperty("ecd:localChanges");
            String current = localChanges.getString();
            if (current.length() > 0) {
                block6: for (String ch : current.split("\n")) {
                    if (ch.length() <= 0) continue;
                    for (FileChange fch : changes) {
                        if (!ch.startsWith(fch.changeId)) continue;
                        history.append(timestamp.toString());
                        history.append(':');
                        history.append(ch);
                        history.append('\n');
                        continue block6;
                    }
                    for (FileChange sch : skipped) {
                        if (!ch.startsWith(sch.changeId)) continue;
                        continue block6;
                    }
                    store.append(ch);
                    store.append('\n');
                }
            }
            localChanges.setValue(store.toString());
            localChanges.save();
        }
        catch (PathNotFoundException e) {
            driveNode.setProperty("ecd:localChanges", store.toString());
            driveNode.save();
        }
        try {
            StringBuilder currentHistory = new StringBuilder();
            Property localHistory = driveNode.getProperty("ecd:localHistory");
            String current = localHistory.getString();
            if (current.length() > 0) {
                int i;
                String[] fchs = current.split("\n");
                int n = i = fchs.length > 1000 ? fchs.length - 1000 : 0;
                while (i > fchs.length) {
                    String ch;
                    ch = fchs[i];
                    if (ch.length() > 0) {
                        int cindex = ch.indexOf(58);
                        try {
                            long chTimestamp = Long.parseLong(ch.substring(0, cindex));
                            if (timestamp - chTimestamp < 691200000L) {
                                currentHistory.append(ch);
                                currentHistory.append('\n');
                            }
                        }
                        catch (NumberFormatException e) {
                            throw new CloudDriveException("Error parsing change timestamp: " + ch, e);
                        }
                    }
                    ++i;
                }
            }
            if (currentHistory.length() > 0) {
                history.insert(0, currentHistory.toString());
            }
            localHistory.setValue(history.toString());
            localHistory.save();
        }
        catch (PathNotFoundException e) {
            driveNode.setProperty("ecd:localHistory", history.toString());
            driveNode.save();
        }
        for (FileChange ch : changes) {
            if (ch.fileId != null) {
                this.addChanged(ch.fileId, ch.changeType);
                continue;
            }
            LOG.warn((Object)("Cannot cache file change with null file id: " + ch.changeType + ", " + ch.path));
        }
    }

    protected synchronized void rollbackAllChanges() throws RepositoryException, CloudDriveException {
        Node driveNode = this.rootNode();
        try {
            Property localChanges = driveNode.getProperty("ecd:localChanges");
            localChanges.setValue(DUMMY_DATA);
            localChanges.save();
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    protected List<FileChange> savedChanges() throws RepositoryException, CloudDriveException {
        ArrayList<FileChange> changes = new ArrayList<FileChange>();
        Node driveNode = this.rootNode();
        try {
            Property localChanges = driveNode.getProperty("ecd:localChanges");
            String current = localChanges.getString();
            if (current.length() > 0) {
                for (String ch : current.split("\n")) {
                    if (ch.length() <= 0) continue;
                    changes.add(this.parseChange(ch));
                }
            }
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        return changes;
    }

    protected boolean hasChange(FileChange change) throws RepositoryException, CloudDriveException {
        Node driveNode = this.rootNode();
        try {
            Property localChanges = driveNode.getProperty("ecd:localChanges");
            String current = localChanges.getString();
            if (current.length() > 0) {
                return current.indexOf(change.changeId + "=") >= 0;
            }
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        return false;
    }

    protected void loadHistory() throws RepositoryException, CloudDriveException {
        Node driveNode = this.rootNode();
        try {
            Property localChanges = driveNode.getProperty("ecd:localHistory");
            String current = localChanges.getString();
            if (current.length() > 0) {
                LOG.info((Object)("Loading local history of " + this.title()));
                for (String ch : current.split("\n")) {
                    if (ch.length() <= 0) continue;
                    this.loadChanged(ch);
                }
            }
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    private FileChange parseChange(String ch) throws CloudDriveException, RepositoryException {
        Class<Object> syncClass;
        String fileId;
        String path;
        int cindex = ch.indexOf(61);
        String changeId = ch.substring(0, cindex);
        String changeType = new String(new char[]{ch.charAt(++cindex)});
        boolean isFolder = ch.charAt(cindex++) == 'Y';
        try {
            int pathIndex = ++cindex + 10;
            int pathLen = Integer.parseInt(ch.substring(cindex, pathIndex));
            cindex = pathIndex + pathLen;
            path = ch.substring(pathIndex, cindex);
        }
        catch (NumberFormatException e) {
            throw new CloudDriveException("Cannot parse path from local changes: " + ch, e);
        }
        if (cindex < ch.length() && ch.charAt(cindex) == 'I') {
            try {
                int idIndex = ++cindex + 4;
                int idLen = Integer.parseInt(ch.substring(cindex, idIndex));
                cindex = idIndex + idLen;
                fileId = ch.substring(idIndex, cindex);
            }
            catch (NumberFormatException e) {
                throw new CloudDriveException("Cannot parse file id from local changes: " + ch, e);
            }
        } else {
            fileId = null;
        }
        if (cindex < ch.length() && ch.charAt(cindex) == 'S') {
            try {
                syncClass = Class.forName(ch.substring(cindex + 1));
            }
            catch (ClassNotFoundException e) {
                LOG.warn((Object)("Cannot find stored synchronizer class from local changes: " + ch), (Throwable)e);
                syncClass = LostRemovalSynchronizer.class;
            }
        } else {
            syncClass = null;
        }
        return new FileChange(changeId, path, fileId, isFolder, changeType, syncClass != null ? this.synchronizer(syncClass) : null);
    }

    private void loadChanged(String ch) throws CloudDriveException, RepositoryException {
        int cindex = ch.indexOf(61);
        String changeType = new String(new char[]{ch.charAt(++cindex)});
        ++cindex;
        try {
            int pathIndex = ++cindex + 10;
            int pathLen = Integer.parseInt(ch.substring(cindex, pathIndex));
            cindex = pathIndex + pathLen;
        }
        catch (NumberFormatException e) {
            throw new CloudDriveException("Cannot parse path from local changes: " + ch, e);
        }
        if (cindex < ch.length() && ch.charAt(cindex) == 'I') {
            String fileId;
            try {
                int idIndex = ++cindex + 4;
                int idLen = Integer.parseInt(ch.substring(cindex, idIndex));
                cindex = idIndex + idLen;
                fileId = ch.substring(idIndex, cindex);
            }
            catch (NumberFormatException e) {
                throw new CloudDriveException("Cannot parse file id from local changes: " + ch, e);
            }
            if (fileId != null) {
                this.addChanged(fileId, changeType);
            } else {
                LOG.warn((Object)("Cannot load file change with null file id: " + ch));
            }
        }
    }

    protected void setChangeId(Long id) throws CloudDriveException, RepositoryException {
        this.saveChangeId(id);
        this.currentChangeId.set(id);
        this.fileChangeSequencer.addAndGet(1L - this.fileChangeSequencer.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long getChangeId() throws RepositoryException, CloudDriveException {
        Long id = this.currentChangeId.get();
        if (id < 0L) {
            AtomicLong atomicLong = this.currentChangeId;
            synchronized (atomicLong) {
                id = this.currentChangeId.get();
                if (id < 0L) {
                    id = this.readChangeId();
                }
            }
        }
        return id;
    }

    @Override
    protected boolean isDrive(String workspace, String path, boolean includeFiles) throws DriveRemovedException, RepositoryException {
        block7: {
            Node driveNode = this.rootNode(true);
            if (driveNode.getSession().getWorkspace().getName().equals(workspace)) {
                try {
                    Item target = this.finder.findItem(driveNode.getSession(), path);
                    if (target.isNode()) {
                        Node node = (Node)target;
                        if (this.isConnected()) {
                            if (this.isSameDrive(node)) {
                                return true;
                            }
                            if (includeFiles) {
                                return node.getPath().startsWith(driveNode.getPath());
                            }
                        }
                    }
                }
                catch (ItemNotFoundException | PathNotFoundException e) {
                    if (!LOG.isDebugEnabled()) break block7;
                    LOG.debug((Object)("File not found in drive " + this.title() + ": " + path + ". " + e.getMessage()));
                }
            }
        }
        return false;
    }

    protected boolean isSameDrive(Node anotherNode) throws RepositoryException {
        if (anotherNode.isNodeType(ECD_CLOUDDRIVE)) {
            return this.rootUUID.equals(anotherNode.getUUID());
        }
        return false;
    }

    protected Node fileNode(Node node) throws RepositoryException {
        Node parent;
        Node fileNode = this.getOrCleanFileNode(node);
        if (fileNode != null) {
            return fileNode;
        }
        if (this.fileAPI.isFileResource(node) && this.fileAPI.isFile(parent = node.getParent())) {
            return this.ensureOwned(parent);
        }
        return null;
    }

    protected Session systemSession() throws LoginException, NoSuchWorkspaceException, RepositoryException {
        SessionProvider ssp = this.sessionProviders.getSystemSessionProvider(null);
        if (ssp != null) {
            return ssp.getSession(this.rootWorkspace, this.repository);
        }
        throw new RepositoryException("Cannot get system session provider.");
    }

    protected Session session() throws LoginException, NoSuchWorkspaceException, RepositoryException {
        SessionProvider sp = this.sessionProviders.getSessionProvider(null);
        if (sp != null) {
            return sp.getSession(this.rootWorkspace, this.repository);
        }
        throw new RepositoryException("Cannot get session provider.");
    }

    protected Node rootNode() throws DriveRemovedException, RepositoryException {
        return this.rootNode(false);
    }

    protected Node rootNode(boolean systemSession) throws DriveRemovedException, RepositoryException {
        Node rootNode;
        if (systemSession) {
            Node rootNode2;
            SoftReference<Node> rootNodeRef = this.rootSystemNodeHolder.get();
            if (rootNodeRef != null && (rootNode2 = rootNodeRef.get()) != null && rootNode2.getSession().isLive() && this.isPrivilegedUser(rootNode2.getSession().getUserID())) {
                try {
                    rootNode2.getIndex();
                    return rootNode2;
                }
                catch (InvalidItemStateException e) {
                    throw new DriveRemovedException("Drive " + this.title() + " was removed.", e);
                }
                catch (RepositoryException e) {
                    // empty catch block
                }
            }
            try {
                rootNode2 = this.systemSession().getNodeByUUID(this.rootUUID);
            }
            catch (ItemNotFoundException e) {
                throw new DriveRemovedException("Drive " + this.title() + " was removed.", e);
            }
            this.rootSystemNodeHolder.set(new SoftReference<Node>(rootNode2));
            return rootNode2;
        }
        SoftReference<Node> rootNodeRef = this.rootNodeHolder.get();
        if (rootNodeRef != null) {
            rootNode = rootNodeRef.get();
            String currentUser = this.currentUserName();
            if (rootNode != null && rootNode.getSession().isLive() && currentUser != null && currentUser.equals(rootNode.getSession().getUserID())) {
                try {
                    rootNode.getIndex();
                    return rootNode;
                }
                catch (InvalidItemStateException e) {
                    throw new DriveRemovedException("Drive " + this.title() + " was removed.", e);
                }
                catch (RepositoryException repositoryException) {
                    // empty catch block
                }
            }
        }
        try {
            rootNode = this.session().getNodeByUUID(this.rootUUID);
        }
        catch (ItemNotFoundException e) {
            throw new DriveRemovedException("Drive " + this.title() + " was removed.", e);
        }
        this.rootNodeHolder.set(new SoftReference<Node>(rootNode));
        return rootNode;
    }

    protected void rollback(Node rootNode) {
        try {
            rootNode.refresh(false);
        }
        catch (RepositoryException e) {
            LOG.warn((Object)("Error rolling back the changes on drive '" + this.title() + "': " + e.getMessage()));
        }
    }

    void handleError(Node rootNode, Throwable error, String commandName) {
        String rootPath = null;
        if (rootNode != null) {
            try {
                rootPath = rootNode.getPath();
            }
            catch (RepositoryException e) {
                LOG.warn((Object)("Error reading drive root '" + e.getMessage() + "' " + (commandName != null ? "of " + commandName + " command " : "") + "to listeners on Cloud Drive '" + this.title() + "':" + e.getMessage()));
            }
            if (commandName.equals("connect")) {
                try {
                    this.removeJCRListener(rootNode.getSession());
                }
                catch (Throwable e) {
                    LOG.warn((Object)("Error removing observation listener on connect error '" + error.getMessage() + "'  on Cloud Drive '" + this.title() + "':" + e.getMessage()));
                }
            }
            this.rollback(rootNode);
        }
        try {
            this.listeners.fireOnError(new CloudDriveEvent(this.getUser(), this.rootWorkspace, rootPath), error, commandName);
        }
        catch (Throwable e) {
            LOG.warn((Object)("Error firing error '" + error.getMessage() + "' " + (commandName != null ? "of " + commandName + " command " : "") + "to listeners on Cloud Drive '" + this.title() + "':" + e.getMessage()));
        }
    }

    private Node openNode(String fileId, String fileTitle, Node parent, String nodeType) throws RepositoryException, CloudDriveException {
        Node node;
        String baseName;
        String name = baseName = this.nodeName(fileTitle);
        String internalName = null;
        boolean titleTried = false;
        int siblingNumber = 1;
        block4: while (true) {
            try {
                while (true) {
                    StringBuilder newName;
                    if (this.fileAPI.isFile(node = parent.getNode(name))) {
                        if (fileId.equals(this.fileAPI.getId(node))) {
                            this.ensureOwned(node);
                            break block4;
                        }
                        newName = new StringBuilder();
                        newName.append(baseName);
                        newName.append('-');
                        newName.append(siblingNumber);
                        name = newName.toString();
                        ++siblingNumber;
                        continue;
                    }
                    if (this.getOrCleanFileNode(node) != null || !parent.hasNode(name)) continue;
                    newName = new StringBuilder();
                    newName.append(baseName);
                    newName.append('-');
                    newName.append(siblingNumber);
                    name = newName.toString();
                    ++siblingNumber;
                }
            }
            catch (PathNotFoundException e) {
                block12: {
                    if (internalName == null) {
                        internalName = name;
                        String finderName = this.finder.cleanName(fileTitle);
                        if (finderName.length() > 1) {
                            name = finderName;
                            continue;
                        }
                    }
                    if (!titleTried) {
                        titleTried = true;
                        try {
                            if (parent.hasNode(fileTitle)) {
                                name = fileTitle;
                                continue;
                            }
                            break block12;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                            break block12;
                        }
                        continue;
                    }
                }
                node = parent.addNode(internalName, nodeType);
            }
            break;
        }
        return node;
    }

    private Node ensureOwned(Node node) throws RepositoryException {
        return IdentityHelper.ensureOwned(node, this.systemSession());
    }

    protected Node openFile(String fileId, String fileTitle, Node parent) throws RepositoryException, CloudDriveException {
        Node localNode = this.openNode(fileId, fileTitle, parent, NT_FILE);
        if (localNode.isNew() && !localNode.hasNode("jcr:content")) {
            Node content = localNode.addNode("jcr:content", NT_RESOURCE);
            content.setProperty("jcr:data", DUMMY_DATA);
        }
        return localNode;
    }

    protected Node openFolder(String folderId, String folderTitle, Node parent) throws RepositoryException, CloudDriveException {
        return this.openNode(folderId, folderTitle, parent, NT_FOLDER);
    }

    protected Node moveFile(String id, String title, Node source, Node destParent) throws RepositoryException, CloudDriveException {
        Node place = this.openNode(id, title, destParent, NT_FILE);
        if (place.isNew() && !place.hasProperty("ecd:id")) {
            String nodeName = place.getName();
            this.removeLinks(place);
            place.remove();
            Session session = destParent.getSession();
            String destPath = destParent.getPath() + "/" + nodeName;
            session.move(source.getPath(), destPath);
            source.refresh(true);
            return source;
        }
        return place;
    }

    protected Node copyFile(Node node, Node destParent) throws RepositoryException, CloudDriveException {
        String title;
        String id = this.fileAPI.getId(node);
        Node place = this.openNode(id, title = this.fileAPI.getTitle(node), destParent, NT_FILE);
        if (place.isNew() && !place.hasProperty("ecd:id")) {
            String nodeName = place.getName();
            this.removeLinks(place);
            place.remove();
            Node nodeCopy = destParent.addNode(nodeName, node.getPrimaryNodeType().getName());
            for (NodeType mixin : node.getMixinNodeTypes()) {
                String mixinName = mixin.getName();
                if (nodeCopy.isNodeType(mixinName)) continue;
                nodeCopy.addMixin(mixin.getName());
            }
            PropertyIterator piter = node.getProperties();
            while (piter.hasNext()) {
                Property ep = piter.nextProperty();
                PropertyDefinition pdef = ep.getDefinition();
                if (pdef.isProtected()) continue;
                if (pdef.isMultiple()) {
                    nodeCopy.setProperty(ep.getName(), ep.getValues());
                    continue;
                }
                nodeCopy.setProperty(ep.getName(), ep.getValue());
            }
            NodeIterator niter = node.getNodes();
            while (niter.hasNext()) {
                Node ecn = niter.nextNode();
                NodeDefinition ndef = ecn.getDefinition();
                if (ndef.isProtected()) continue;
                this.copyFile(ecn, nodeCopy);
            }
            return nodeCopy;
        }
        return place;
    }

    protected void readNodes(Node parent, Map<String, List<Node>> nodes, boolean deep) throws RepositoryException {
        NodeIterator niter = parent.getNodes();
        while (niter.hasNext()) {
            Node node = this.getOrCleanFileNode(niter.nextNode());
            if (node == null) continue;
            String fileId = this.fileAPI.getId(node);
            nodes.computeIfAbsent(fileId, k -> new ArrayList()).add(node);
            if (!deep || !this.fileAPI.isFolder(node)) continue;
            this.readNodes(node, nodes, deep);
        }
    }

    protected Node readNode(Node parent, String fileTitle, String fileId) throws RepositoryException {
        Node node;
        String baseName;
        String name = baseName = this.nodeName(fileTitle);
        String internalName = null;
        int siblingNumber = 1;
        block2: while (true) {
            try {
                while (this.fileAPI.isFile(node = parent.getNode(name))) {
                    if (fileId != null && !fileId.equals(this.fileAPI.getId(node))) {
                        StringBuilder newName = new StringBuilder();
                        newName.append(baseName);
                        newName.append('-');
                        newName.append(siblingNumber);
                        name = newName.toString();
                        ++siblingNumber;
                        continue;
                    }
                    break block2;
                }
                LOG.warn((Object)("Not a cloud file under clodu drive folder: " + node.getPath()));
                return null;
            }
            catch (PathNotFoundException e) {
                if (internalName == null) {
                    internalName = name;
                    if ((name = this.finder.cleanName(fileTitle)).length() > 0) continue;
                }
                return null;
            }
            break;
        }
        return node;
    }

    protected Node findNode(String id) throws RepositoryException, DriveRemovedException {
        Node rootNode = this.rootNode();
        if (this.fileAPI.getId(rootNode).equals(id)) {
            return rootNode;
        }
        QueryManager qm = rootNode.getSession().getWorkspace().getQueryManager();
        Query q = qm.createQuery("SELECT * FROM ecd:cloudFile WHERE ecd:id='" + id + "' AND jcr:path LIKE '" + rootNode.getPath() + "/%'", "sql");
        QueryResult qr = q.execute();
        NodeIterator nodes = qr.getNodes();
        if (nodes.hasNext()) {
            return this.ensureOwned(nodes.nextNode());
        }
        return null;
    }

    protected Collection<Node> findNodes(Collection<String> ids) throws RepositoryException, DriveRemovedException {
        LinkedHashSet<Node> res = new LinkedHashSet<Node>();
        Node rootNode = this.rootNode();
        if (ids.contains(this.fileAPI.getId(rootNode))) {
            res.add(rootNode);
        }
        QueryManager qm = rootNode.getSession().getWorkspace().getQueryManager();
        StringBuilder idstmt = new StringBuilder();
        Iterator<String> ii = ids.iterator();
        while (ii.hasNext()) {
            String id = ii.next();
            idstmt.append("ecd:id='");
            idstmt.append(id);
            idstmt.append('\'');
            if (!ii.hasNext()) continue;
            idstmt.append(" OR ");
        }
        Query q = qm.createQuery("SELECT * FROM ecd:cloudFile WHERE " + idstmt + " AND jcr:path LIKE '" + rootNode.getPath() + "/%'", "sql");
        QueryResult qr = q.execute();
        NodeIterator niter = qr.getNodes();
        while (niter.hasNext()) {
            res.add(niter.nextNode());
        }
        return res;
    }

    protected JCRLocalCloudFile readFile(Node fileNode) throws RepositoryException {
        String title = this.fileAPI.getTitle(fileNode);
        boolean isFolder = fileNode.isNodeType(ECD_CLOUDFOLDER);
        String type = fileNode.getProperty("ecd:type").getString();
        String typeMode = isFolder ? null : this.mimeTypes.getMimeTypeMode(type, title);
        String link = this.link(fileNode);
        String previewLink = isFolder ? null : this.previewLink(type, fileNode);
        String editLink = isFolder ? null : this.editLink(link, type, fileNode);
        long size = this.size(fileNode);
        return new JCRLocalCloudFile(fileNode.getPath(), this.fileAPI.getId(fileNode), title, link, editLink, previewLink, this.thumbnailLink(fileNode), type, typeMode, this.fileAPI.getLastUser(fileNode), this.fileAPI.getAuthor(fileNode), this.fileAPI.getCreated(fileNode), this.fileAPI.getModified(fileNode), isFolder, size, fileNode, false);
    }

    protected void initFile(Node fileNode, String title, String id, String type, String link, String previewLink, String thumbnailLink, String author, String lastUser, Calendar created, Calendar modified, long size) throws RepositoryException {
        if (!fileNode.isNodeType(ECD_CLOUDFILE)) {
            fileNode.addMixin(ECD_CLOUDFILE);
            if (modified == null) {
                modified = Calendar.getInstance();
            }
        }
        this.initCommon(fileNode, title, id, type, link, author, lastUser, created, modified);
        fileNode.setProperty("ecd:size", size);
        Node content = fileNode.getNode("jcr:content");
        if (!content.isNodeType(ECD_CLOUDFILERESOURCE)) {
            content.addMixin(ECD_CLOUDFILERESOURCE);
        }
        content.setProperty("jcr:mimeType", type);
        content.setProperty("jcr:lastModified", modified);
        fileNode.setProperty("ecd:previewUrl", previewLink);
        fileNode.setProperty("ecd:downloadUrl", (String)null);
        fileNode.setProperty("ecd:thumbnailUrl", thumbnailLink);
    }

    protected void initFolder(Node localNode, String id, String title, String type, String link, String author, String lastUser, Calendar created, Calendar modified) throws RepositoryException {
        if (!localNode.isNodeType(ECD_CLOUDFOLDER)) {
            localNode.addMixin(ECD_CLOUDFOLDER);
        }
        this.initCommon(localNode, id, title, type, link, author, lastUser, created, modified);
    }

    protected void initCommon(Node node, String id, String title, String type, String link, String author, String lastUser, Calendar created, Calendar modified) throws RepositoryException {
        node.setProperty("exo:title", title);
        if (node.hasProperty("exo:name")) {
            node.setProperty("exo:name", title);
        }
        node.setProperty("ecd:id", id);
        node.setProperty("ecd:driveUUID", this.rootUUID);
        if (type != null) {
            node.setProperty("ecd:type", type);
        }
        if (link != null) {
            node.setProperty("ecd:url", link);
        }
        if (author != null) {
            node.setProperty("ecd:author", author);
        }
        if (lastUser != null) {
            node.setProperty("ecd:lastUser", lastUser);
        }
        if (created != null) {
            node.setProperty("ecd:created", created);
        }
        if (modified != null) {
            node.setProperty("ecd:modified", modified);
        }
        node.setProperty("ecd:synchronized", Calendar.getInstance());
        if (node.isNodeType(EXO_DATETIME)) {
            if (created != null) {
                node.setProperty("exo:dateCreated", created);
            }
            if (modified != null) {
                node.setProperty("exo:dateModified", modified);
            }
        }
        if (node.isNodeType(EXO_MODIFY) && modified != null && lastUser != null) {
            node.setProperty("exo:lastModifiedDate", modified);
            node.setProperty("exo:lastModifier", lastUser);
        }
    }

    @Override
    protected String title() {
        return this.titleCached;
    }

    protected JCRListener addJCRListener(Node driveNode) throws RepositoryException {
        JCRListener handler = new JCRListener(driveNode.getPath());
        ObservationManager observation = driveNode.getSession().getWorkspace().getObservationManager();
        observation.addEventListener((EventListener)handler.removeListener, 2, driveNode.getParent().getPath(), false, null, null, false);
        observation.addEventListener((EventListener)handler.trashListener, 1, null, false, null, new String[]{EXO_TRASHFOLDER}, false);
        LinkedHashSet<String> supported = new LinkedHashSet<String>();
        for (CloudFileSynchronizer s : this.fileSynchronizers) {
            for (String nt : s.getSupportedNodetypes()) {
                supported.add(nt);
            }
        }
        observation.addEventListener((EventListener)handler.changesListener, 19, driveNode.getPath(), true, null, supported.size() > 0 ? supported.toArray(new String[supported.size()]) : null, false);
        return handler;
    }

    protected void removeJCRListener(Session session) throws RepositoryException {
        ObservationManager observation = session.getWorkspace().getObservationManager();
        observation.removeEventListener((EventListener)this.jcrListener.removeListener);
        observation.removeEventListener((EventListener)this.jcrListener.trashListener);
        observation.removeEventListener((EventListener)this.jcrListener.changesListener);
    }

    @Override
    protected void configure(CloudDriveEnvironment env, Collection<CloudFileSynchronizer> synchronizers) {
        this.commandEnv.chain(env);
        this.fileSynchronizers.addAll(synchronizers);
    }

    protected boolean cleanup(Node node) {
        try {
            if (node.isNodeType(EXO_THUMBNAILS) || node.isNodeType(EXO_THUMBNAIL)) {
                String path = node.getPath();
                Item cleanIt = this.systemSession().getItem(path);
                Node parent = cleanIt.getParent();
                cleanIt.remove();
                parent.save();
                LOG.info((Object)("Not a cloud file node removed from the drive: " + path));
                return true;
            }
        }
        catch (Throwable e) {
            LOG.error((Object)"Error removing not a cloud file node", e);
        }
        return false;
    }

    protected Node getOrCleanFileNode(Node node) throws RepositoryException {
        if (this.fileAPI.isFile(node)) {
            return this.ensureOwned(node);
        }
        if (this.fileAPI.isIgnored(node)) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Not a cloud file detected " + node.getPath()));
        }
        if (!this.cleanup(node)) {
            this.ensureOwned(node);
        }
        return null;
    }

    protected void fixNameConflict(Node file) throws RepositoryException {
        block7: {
            StringBuilder titleBuilder;
            String newTitle;
            String newName;
            int index;
            String baseExt;
            String baseTitle;
            Session session = file.getSession();
            Node parent = file.getParent();
            String title = this.fileAPI.getTitle(file);
            String[] titleParts = title.split("\\.");
            if (titleParts.length >= 2) {
                baseTitle = titleParts[0];
                baseExt = titleParts[titleParts.length - 1];
            } else {
                baseTitle = title;
                baseExt = null;
            }
            int openingParenthesesPos = baseTitle.lastIndexOf(40);
            int closingParenthesesPos = baseTitle.lastIndexOf(41);
            if (openingParenthesesPos > 0 && closingParenthesesPos > 0 && closingParenthesesPos > openingParenthesesPos) {
                try {
                    index = Integer.valueOf(baseTitle.substring(++openingParenthesesPos, closingParenthesesPos));
                    baseTitle = baseTitle.substring(0, openingParenthesesPos);
                }
                catch (NumberFormatException e) {
                    index = 1;
                }
            } else {
                index = 1;
            }
            do {
                titleBuilder = new StringBuilder(baseTitle).append(" (").append(index++).append(')');
                if (baseExt == null) continue;
                titleBuilder.append('.').append(baseExt);
            } while (parent.hasNode(newName = this.nodeName(newTitle = titleBuilder.toString())));
            session.move(file.getPath(), parent.getPath() + '/' + newName);
            file.setProperty("exo:title", newTitle);
            if (!file.hasProperty("exo:name")) break block7;
            file.setProperty("exo:name", newTitle);
        }
    }

    protected String previewLink(String type, Node fileNode) throws RepositoryException {
        try {
            return fileNode.getProperty("ecd:previewUrl").getString();
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    protected String thumbnailLink(Node fileNode) throws RepositoryException {
        String link;
        try {
            link = fileNode.getProperty("ecd:thumbnailUrl").getString();
        }
        catch (PathNotFoundException e) {
            try {
                link = fileNode.getProperty("ecd:downloadUrl").getString();
            }
            catch (PathNotFoundException e1) {
                link = null;
            }
        }
        return link;
    }

    protected String link(Node fileNode) throws PathNotFoundException, RepositoryException {
        return fileNode.getProperty("ecd:url").getString();
    }

    protected String editLink(String fileLink, String type, Node fileNode) throws RepositoryException {
        return null;
    }

    protected long size(Node fileNode) throws RepositoryException {
        try {
            return fileNode.getProperty("ecd:size").getLong();
        }
        catch (PathNotFoundException e) {
            return -1L;
        }
    }

    protected boolean isUpdating(String key) {
        AtomicLong counter = this.updating.get(key);
        if (counter != null) {
            return counter.longValue() > 0L;
        }
        return false;
    }

    protected boolean isNew(String key) {
        AtomicLong counter = this.updating.get(key);
        if (counter != null) {
            return counter.longValue() == 0L;
        }
        return false;
    }

    protected boolean isNewOrUpdating(String key) {
        AtomicLong counter = this.updating.get(key);
        if (counter != null) {
            return counter.longValue() >= 0L;
        }
        return false;
    }

    protected boolean initUpdating(String key) {
        AtomicLong existingCounter = this.updating.putIfAbsent(key, new AtomicLong(0L));
        boolean res = existingCounter != null ? existingCounter.longValue() == 0L : true;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(">> initUpdating " + key + " " + res));
        }
        return res;
    }

    protected long addUpdating(String key) {
        AtomicLong newCounter = new AtomicLong(1L);
        AtomicLong existingCounter = this.updating.putIfAbsent(key, newCounter);
        long counter = existingCounter != null ? existingCounter.incrementAndGet() : newCounter.longValue();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(">> addUpdating " + key + " " + counter));
        }
        return counter;
    }

    protected boolean removeUpdating(String key) {
        AtomicLong counter = this.updating.get(key);
        boolean res = false;
        if (counter != null && counter.decrementAndGet() <= 0L) {
            res = this.updating.remove(key, counter);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<< removeUpdating " + key + " " + (counter != null ? Long.valueOf(counter.longValue()) : "")));
        }
        return res;
    }

    protected void ensureSame(CloudUser user, Node driveNode) throws RepositoryException, CannotConnectDriveException {
        try {
            boolean res;
            boolean bl = res = driveNode.getProperty("ecd:cloudUserId").getString().equals(this.getUser().getId()) && driveNode.getProperty("ecd:cloudUserName").getString().equals(this.getUser().getUsername()) && driveNode.getProperty("ecd:userEmail").getString().equals(this.getUser().getEmail());
            if (!res) {
                LOG.warn((Object)("Cannot connect drive. Node " + driveNode.getPath() + " was connected to another user/drive."));
                throw new CannotConnectDriveException("Node already initialized by another user " + driveNode.getName());
            }
        }
        catch (PathNotFoundException e) {
            throw new CannotConnectDriveException("Mandatory drive property not found: " + e.getMessage());
        }
    }

    @Override
    protected boolean isInDrive(Node node) throws DriveRemovedException, RepositoryException {
        block5: {
            Node driveNode = this.rootNode(true);
            if (driveNode.getSession().getWorkspace().getName().equals(node.getSession().getWorkspace().getName())) {
                if (this.isSameDrive(node)) {
                    return true;
                }
                String path = node.getPath();
                try {
                    Item target = this.finder.findItem(node.getSession(), path);
                    if (target.isNode()) {
                        node = (Node)target;
                        return node.getPath().startsWith(driveNode.getPath());
                    }
                }
                catch (ItemNotFoundException | PathNotFoundException e) {
                    if (!LOG.isDebugEnabled()) break block5;
                    LOG.debug((Object)("File not found in drive " + this.title() + ": " + path + ". " + e.getMessage()));
                }
            }
        }
        return false;
    }

    protected boolean isInTrash(Node node) {
        block4: {
            try {
                String nodePath = node.getPath();
                Node nodeParent = this.systemSession().getItem(nodePath).getParent();
                if (nodeParent.isNodeType(EXO_TRASHFOLDER)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("File in Trash " + nodePath));
                    }
                    return true;
                }
            }
            catch (Throwable t) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug((Object)("Error reading node caused check for Trash " + node));
            }
        }
        return false;
    }

    protected String nodeName(String title) {
        return JCRLocalCloudDrive.cleanName(title);
    }

    protected abstract Long readChangeId() throws CloudDriveException, RepositoryException;

    protected abstract void saveChangeId(Long var1) throws CloudDriveException, RepositoryException;

    public static String cleanName(String name) {
        String str = accentsConverter.transliterate(name.trim());
        StringBuilder cleanedStr = new StringBuilder(str.trim());
        if (cleanedStr.length() == 1) {
            char c = cleanedStr.charAt(0);
            if (c == '.' || c == '/' || c == ':' || c == '[' || c == ']' || c == '*' || c == '\'' || c == '\"' || c == '|') {
                cleanedStr.deleteCharAt(0);
                cleanedStr.append('_');
                cleanedStr.append(Integer.toHexString(c).toUpperCase());
            }
        } else {
            for (int i = 0; i < cleanedStr.length(); ++i) {
                char c = cleanedStr.charAt(i);
                if (c == '/' || c == ':' || c == '[' || c == ']' || c == '*' || c == '\'' || c == '\"' || c == '|') {
                    cleanedStr.deleteCharAt(i);
                    cleanedStr.insert(i, '_');
                    continue;
                }
                if (Character.isLetterOrDigit(c) || Character.isWhitespace(c) || c == '.' || c == '-' || c == '_') continue;
                cleanedStr.deleteCharAt(i--);
            }
        }
        return cleanedStr.toString().trim();
    }

    static void startAction(CloudDrive drive) {
        actionDrive.set(drive);
    }

    static boolean acceptAction(CloudDrive drive) {
        return drive != null && drive != actionDrive.get();
    }

    static void doneAction() {
        actionDrive.remove();
    }

    public static void checkNotTrashed(Node node) throws RepositoryException, DriveRemovedException {
        if (node.getParent().isNodeType(EXO_TRASHFOLDER)) {
            throw new DriveTrashedException("Drive " + node.getPath() + " was moved to Trash.");
        }
    }

    public static void migrateName(Node node) throws RepositoryException {
        if (node.isNodeType(ECD_CLOUDDRIVE)) {
            boolean upgrade;
            try {
                double localFormat = node.getProperty(ECD_LOCALFORMAT).getDouble();
                if (localFormat == 1.1) {
                    upgrade = false;
                } else {
                    LOG.warn((Object)("Local format unknown: " + localFormat + ". Supported format: " + 1.1 + " or lower."));
                    upgrade = false;
                }
            }
            catch (PathNotFoundException e) {
                upgrade = true;
            }
            if (upgrade) {
                String name = node.getName();
                Session session = node.getSession();
                try {
                    session.move(node.getPath(), node.getParent().getPath() + '/' + JCRLocalCloudDrive.cleanName(name));
                    node.setProperty(ECD_LOCALFORMAT, 1.1);
                    session.save();
                }
                catch (RepositoryException e) {
                    try {
                        session.refresh(false);
                    }
                    catch (RepositoryException re) {
                        LOG.warn((Object)("Error rolling back the session during root node migration: " + (Object)((Object)re)));
                    }
                    throw e;
                }
            }
        } else {
            LOG.warn((Object)("Not a Cloud Drive root node: " + node.getPath()));
        }
    }

    protected String currentUserName() {
        ConversationState cs = ConversationState.getCurrent();
        return cs != null ? cs.getIdentity().getUserId() : null;
    }

    protected void removeLinks(Session session, String fileUUID) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        for (Node linked : this.finder.findLinked(session, fileUUID)) {
            Node parent = this.ensureOwned(linked.getParent());
            this.ensureOwned(linked).remove();
            parent.save();
        }
    }

    protected void removeLinks(Node node) throws ItemNotFoundException, AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
        if (node.isNodeType(MIX_REFERENCEABLE)) {
            this.removeLinks(node.getSession(), node.getUUID());
        }
    }

    protected void removeNode(Node node) throws RepositoryException {
        if (!this.fileAPI.isIgnored(node)) {
            try {
                this.removeLinks(node);
                node.remove();
            }
            catch (PathNotFoundException pathNotFoundException) {
                // empty catch block
            }
        }
    }

    protected String parentPath(String path) {
        if (path.isEmpty() || path.length() == 1 && path.charAt(0) == '/') {
            return null;
        }
        int parentEndIndex = path.lastIndexOf(47);
        if (parentEndIndex > 0 && parentEndIndex == path.length() - 1) {
            parentEndIndex = path.lastIndexOf(47, parentEndIndex - 1);
        }
        String parentPath = parentEndIndex > 0 ? path.substring(0, parentEndIndex) : null;
        return parentPath;
    }

    protected boolean isPrivilegedUser(String userId) {
        return IdentityHelper.SYSTEM_USER_ID.equals(userId) || "root".equals(userId);
    }

    protected class DriveState
    implements CloudDrive.FilesState {
        protected DriveState() {
        }

        @Override
        public Collection<String> getUpdating() {
            return Collections.unmodifiableCollection(JCRLocalCloudDrive.this.updating.keySet());
        }

        @Override
        public boolean isUpdating(String fileIdOrPath) {
            return JCRLocalCloudDrive.this.isUpdating(fileIdOrPath);
        }

        @Override
        public boolean isNew(String fileIdOrPath) {
            return JCRLocalCloudDrive.this.isNew(fileIdOrPath);
        }
    }

    protected class FileChange {
        public static final String REMOVE = "D";
        public static final String CREATE = "A";
        public static final String UPDATE = "U";
        public static final String UPDATE_CONTENT = "C";
        public static final int CONFLICT_ATTEMPTS_MAX = 100;
        protected final CountDownLatch applied = new CountDownLatch(1);
        protected final boolean isFolder;
        protected final String path;
        protected final CloudFileSynchronizer synchronizer;
        protected String changeType;
        protected String filePath;
        protected String fileId;
        protected String changeId;
        protected String fileUUID;
        protected Node node;
        protected CloudFile file;

        protected FileChange(String path, String fileId, boolean isFolder, String changeType, CloudFileSynchronizer synchronizer) throws CloudDriveException, RepositoryException {
            this.changeId = JCRLocalCloudDrive.this.nextChangeId();
            this.path = path;
            this.fileId = fileId;
            this.isFolder = isFolder;
            this.changeType = changeType;
            this.synchronizer = synchronizer;
        }

        protected FileChange(String changeId, String path, String fileId, boolean isFolder, String changeType, CloudFileSynchronizer synchronizer) {
            this.changeId = changeId;
            this.path = path;
            this.fileId = fileId;
            this.isFolder = isFolder;
            this.changeType = changeType;
            this.synchronizer = synchronizer;
        }

        protected FileChange(String path, String changeType) throws RepositoryException, CloudDriveException {
            this(path, null, false, changeType, null);
        }

        public boolean isFolder() {
            return this.isFolder;
        }

        public String getPath() {
            return this.path;
        }

        public CloudFileSynchronizer getSynchronizer() {
            return this.synchronizer;
        }

        public String getChangeType() {
            return this.changeType;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public String getFileId() {
            return this.fileId;
        }

        public String getChangeId() {
            return this.changeId;
        }

        public String getFileUUID() {
            return this.fileUUID;
        }

        public Node getNode() {
            return this.node;
        }

        public CloudFile getFile() {
            return this.file;
        }

        public long getApplied() {
            return this.applied.getCount();
        }

        void setFileUUID(String fileUUID) {
            this.fileUUID = fileUUID;
        }

        boolean accept() throws DriveRemovedException, CloudDriveException, PathNotFoundException, RepositoryException, InterruptedException {
            if (REMOVE.equals(this.changeType)) {
                if (this.synchronizer == null) {
                    throw new SyncNotSupportedException("Synchronization not available for file removal: " + this.path);
                }
                this.filePath = this.path;
                return true;
            }
            Session session = JCRLocalCloudDrive.this.session();
            Item item = session.getItem(this.path);
            Node node = null;
            if (item.isNode()) {
                node = (Node)item;
                if (JCRLocalCloudDrive.this.fileAPI.isFile(node)) {
                    if (JCRLocalCloudDrive.this.rootUUID.equals(node.getProperty("ecd:driveUUID").getString())) {
                        this.fileId = JCRLocalCloudDrive.this.fileAPI.getId(node);
                    } else if (!JCRLocalCloudDrive.this.fileAPI.isIgnored(node)) {
                        LOG.warn((Object)("Cannot add or update file from other cloud drive " + this.path + ". Ignoring the file."));
                        try {
                            JCRLocalCloudDrive.this.fileAPI.ignore(node);
                        }
                        catch (Throwable t) {
                            LOG.error((Object)("Error ignoring file from other drive " + this.path), t);
                        }
                        return false;
                    }
                } else if (JCRLocalCloudDrive.this.fileAPI.isFileResource(node)) {
                    return false;
                }
            } else {
                Node parentNode = item.getParent();
                if (UPDATE.equals(this.changeType)) {
                    if (JCRLocalCloudDrive.this.fileAPI.isFile(parentNode)) {
                        node = parentNode;
                        this.fileId = JCRLocalCloudDrive.this.fileAPI.getId(node);
                    } else if (JCRLocalCloudDrive.this.fileAPI.isFileResource(parentNode) && JCRLocalCloudDrive.this.fileAPI.isFile(parentNode = parentNode.getParent())) {
                        this.changeType = UPDATE_CONTENT;
                        node = parentNode;
                        this.fileId = JCRLocalCloudDrive.this.fileAPI.getId(node);
                    }
                }
            }
            if (node != null) {
                if (!JCRLocalCloudDrive.this.fileAPI.isIgnored(node)) {
                    this.node = node;
                    this.filePath = node.getPath();
                    return true;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Synchronization not available for ignored cloud item (" + this.changeType + "): " + this.path));
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Skip file node (" + this.changeType + "): " + this.path));
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void apply() throws DriveRemovedException, CloudDriveException, RepositoryException, InterruptedException {
            if (this.applied.getCount() > 0L) {
                try {
                    block33: {
                        if (REMOVE.equals(this.changeType)) {
                            if (JCRLocalCloudDrive.this.fileAPI.isTrashSupported()) {
                                this.trash();
                            } else {
                                this.remove();
                                FileTrashing confirmation = JCRLocalCloudDrive.this.fileTrash.get(this.fileId);
                                if (confirmation != null) {
                                    try {
                                        confirmation.complete();
                                    }
                                    finally {
                                        JCRLocalCloudDrive.this.fileTrash.remove(this.fileId, confirmation);
                                    }
                                }
                            }
                        } else if (this.node != null) {
                            this.node = JCRLocalCloudDrive.this.ensureOwned(this.node);
                            try {
                                if (CREATE.equals(this.changeType)) {
                                    if (this.fileId != null) {
                                        Node srcFile;
                                        block34: {
                                            if (this.node.hasProperty("ecd:trashed")) {
                                                this.untrash();
                                                break block33;
                                            }
                                            srcFile = null;
                                            String srcPath = JCRLocalCloudDrive.this.fileCopies.remove(this.fileId);
                                            if (srcPath != null) {
                                                try {
                                                    Item srcItem = this.node.getSession().getItem(srcPath);
                                                    if (srcItem.isNode()) {
                                                        srcFile = (Node)srcItem;
                                                        break block34;
                                                    }
                                                    LOG.warn((Object)("Copy's source path points to a Property " + srcPath));
                                                }
                                                catch (PathNotFoundException e) {
                                                    LOG.warn((Object)("Copy source node not found: " + srcPath), (Throwable)e);
                                                }
                                            } else if (srcFile == null) {
                                                for (Node n : JCRLocalCloudDrive.this.findNodes(Arrays.asList(this.fileId))) {
                                                    if (this.node.isSame((Item)n)) continue;
                                                    srcFile = n;
                                                }
                                            }
                                        }
                                        if (srcFile == null) {
                                            this.update();
                                        } else {
                                            this.copy(srcFile);
                                        }
                                        break block33;
                                    }
                                    this.create();
                                    break block33;
                                }
                                if (UPDATE.equals(this.changeType)) {
                                    this.update();
                                } else if (UPDATE_CONTENT.equals(this.changeType)) {
                                    this.updateContent();
                                }
                            }
                            catch (SyncNotSupportedException e) {
                                LOG.warn((Object)("Cannot synchronize cloud file (" + this.changeType + "): " + e.getMessage() + ". Ignoring the file."));
                                try {
                                    JCRLocalCloudDrive.this.fileAPI.ignore(this.node);
                                }
                                catch (Throwable t) {
                                    LOG.error((Object)("Error ignoring not a cloud item " + this.filePath), t);
                                }
                                throw e;
                            }
                            catch (SkipSyncException skipSyncException) {
                                // empty catch block
                            }
                        }
                    }
                    this.applied.countDown();
                }
                finally {
                    this.complete();
                }
            }
        }

        private void await() throws InterruptedException {
            while (this.applied.getCount() > 0L) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(">>>> Await " + this.filePath));
                }
                this.applied.await();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void begin() throws InterruptedException {
            ConcurrentHashMap<String, FileChange> concurrentHashMap = JCRLocalCloudDrive.this.fileChanges;
            synchronized (concurrentHashMap) {
                String lockedPath = this.filePath;
                FileChange other = JCRLocalCloudDrive.this.fileChanges.putIfAbsent(lockedPath, this);
                if (other != this && (other = JCRLocalCloudDrive.this.fileChanges.put(lockedPath, this)) != this) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(">>> Waiting for " + other.filePath));
                    }
                    other.await();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("<<< Done for " + other.filePath));
                    }
                }
                for (FileChange c : JCRLocalCloudDrive.this.fileChanges.values()) {
                    if (c == this || !c.filePath.startsWith(lockedPath)) continue;
                    LOG.info((Object)(">>> Waiting for child " + c.filePath));
                    c.await();
                    LOG.info((Object)("<<< Done for child " + c.filePath));
                }
            }
        }

        private void complete() throws PathNotFoundException, RepositoryException, CloudDriveException {
            JCRLocalCloudDrive.this.fileChanges.remove(this.filePath, this);
        }

        private void remove() throws PathNotFoundException, CloudDriveException, RepositoryException, InterruptedException {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Remove file " + this.fileId + " " + this.filePath));
            }
            this.begin();
            try {
                this.synchronizer.remove(this.filePath, this.fileId, this.isFolder, JCRLocalCloudDrive.this.fileAPI);
            }
            catch (NotFoundException e) {
                LOG.warn((Object)("File not found in cloud for file removal " + this.filePath + ". " + e.getMessage()));
            }
            catch (ConstraintException e) {
                LOG.warn((Object)("Constraint violation while synchronizing cloud file removal: " + e.getMessage() + ". " + (e.getCause() != null ? e.getCause().getMessage() : "") + ". Restoring local file " + this.filePath));
                JCRLocalCloudDrive.this.fileAPI.restore(this.fileId, this.filePath);
                throw new SkipChangeException(e.getMessage() + ". Removed file restored.", e);
            }
            if (this.fileUUID != null) {
                JCRLocalCloudDrive.this.removeLinks(JCRLocalCloudDrive.this.session(), this.fileUUID);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void trash() throws PathNotFoundException, CloudDriveException, RepositoryException, InterruptedException {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Trash file " + this.fileId + " " + this.filePath));
            }
            this.begin();
            FileTrashing confirmation = new FileTrashing();
            FileTrashing existing = JCRLocalCloudDrive.this.fileTrash.putIfAbsent(this.fileId, confirmation);
            if (existing != null) {
                confirmation = existing;
            }
            try {
                this.synchronizer.trash(this.filePath, this.fileId, this.isFolder, JCRLocalCloudDrive.this.fileAPI);
            }
            catch (FileTrashRemovedException e) {
                confirmation.remove();
            }
            catch (NotFoundException e) {
                confirmation.remove();
            }
            catch (ConstraintException e) {
                LOG.warn((Object)("Constraint violation while synchronizing cloud file trash: " + e.getMessage() + ". " + (e.getCause() != null ? e.getCause().getMessage() : "") + ". Restoring local file " + this.filePath));
                JCRLocalCloudDrive.this.fileAPI.restore(this.fileId, this.filePath);
                throw new SkipChangeException(e.getMessage() + ". Removed file restored.", e);
            }
            try {
                confirmation.complete();
            }
            finally {
                JCRLocalCloudDrive.this.fileTrash.remove(this.fileId, confirmation);
            }
        }

        private void untrash() throws SkipSyncException, SyncNotSupportedException, CloudDriveException, RepositoryException, InterruptedException {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Untrash file " + this.fileId + " " + this.filePath));
            }
            this.begin();
            int attempts = 0;
            while (true) {
                ++attempts;
                try {
                    this.file = JCRLocalCloudDrive.this.synchronizer(this.node).untrash(this.node, JCRLocalCloudDrive.this.fileAPI);
                    this.filePath = this.file.getPath();
                    this.node.setProperty("ecd:trashed", (String)null);
                }
                catch (NotFoundException e) {
                    LOG.warn((Object)("Trashed cloud file or its destination parent not found for untrashing " + this.filePath + ". " + e.getMessage()));
                    JCRLocalCloudDrive.this.removeNode(this.node);
                }
                catch (ConflictException e) {
                    if (attempts <= 100) {
                        JCRLocalCloudDrive.this.fixNameConflict(this.node);
                        continue;
                    }
                    JCRLocalCloudDrive.this.fileAPI.restore(this.fileId, this.filePath);
                    throw new SkipChangeException(e.getMessage() + ". Local file restored.", e);
                }
                catch (ConstraintException e) {
                    LOG.warn((Object)("Constraint violation while synchronizing cloud file untrash: " + e.getMessage() + ". " + (e.getCause() != null ? e.getCause().getMessage() + ". " : "") + "Restoring local file state " + this.filePath));
                    JCRLocalCloudDrive.this.fileAPI.restore(this.fileId, this.filePath);
                    throw new SkipChangeException(e.getMessage() + ". Drive state refreshed.", e);
                }
                break;
            }
        }

        private void update() throws SkipSyncException, SyncNotSupportedException, CloudDriveException, RepositoryException, InterruptedException {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Update file " + this.fileId + " " + this.filePath));
            }
            this.begin();
            int attempts = 0;
            while (true) {
                ++attempts;
                try {
                    this.file = JCRLocalCloudDrive.this.synchronizer(this.node).update(this.node, JCRLocalCloudDrive.this.fileAPI);
                    this.filePath = this.file.getPath();
                }
                catch (ConflictException e) {
                    if (attempts <= 100) {
                        JCRLocalCloudDrive.this.fixNameConflict(this.node);
                        continue;
                    }
                    JCRLocalCloudDrive.this.fileAPI.restore(this.fileId, this.filePath);
                    throw new SkipChangeException(e.getMessage() + ". Local file restored.", e);
                }
                catch (ConstraintException e) {
                    LOG.warn((Object)("Constraint violation while synchronizing cloud file update. " + e.getMessage() + ". " + (e.getCause() != null ? e.getCause().getMessage() : "") + ". Restoring local file state " + this.filePath));
                    JCRLocalCloudDrive.this.fileAPI.restore(this.fileId, this.filePath);
                    throw new SkipChangeException(e.getMessage() + ". Local file restored.", e);
                }
                break;
            }
        }

        private void updateContent() throws SkipSyncException, SyncNotSupportedException, CloudDriveException, RepositoryException, InterruptedException {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Update content of file " + this.fileId + " " + this.filePath));
            }
            this.begin();
            int attempts = 0;
            while (true) {
                ++attempts;
                try {
                    this.file = JCRLocalCloudDrive.this.synchronizer(this.node).updateContent(this.node, JCRLocalCloudDrive.this.fileAPI);
                }
                catch (ConflictException e) {
                    if (attempts <= 100) {
                        JCRLocalCloudDrive.this.fixNameConflict(this.node);
                        continue;
                    }
                    JCRLocalCloudDrive.this.fileAPI.restore(this.fileId, this.filePath);
                    throw new SkipChangeException(e.getMessage() + ". Local file content not synchronized.", e);
                }
                catch (ConstraintException e) {
                    LOG.warn((Object)("Constraint violation while synchronizing cloud file content update: " + e.getMessage() + ". " + (e.getCause() != null ? e.getCause().getMessage() : "") + ". Restoring local file state " + this.filePath));
                    try {
                        String localId = JCRLocalCloudDrive.this.fileAPI.getId(this.node);
                        JCRLocalCloudDrive.this.fileAPI.restore(localId, this.filePath);
                    }
                    catch (PathNotFoundException pathNotFoundException) {
                        // empty catch block
                    }
                    throw new SkipChangeException(e.getMessage() + ". Local file content not synchronized.", e);
                }
                break;
            }
        }

        private void copy(Node srcFile) throws SkipSyncException, SyncNotSupportedException, CloudDriveException, RepositoryException, InterruptedException {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Copy file " + this.fileId + " " + srcFile.getPath() + " -> " + this.filePath));
            }
            this.begin();
            int attempts = 0;
            while (true) {
                ++attempts;
                try {
                    this.file = JCRLocalCloudDrive.this.synchronizer(this.node).copy(srcFile, this.node, JCRLocalCloudDrive.this.fileAPI);
                    this.filePath = this.file.getPath();
                }
                catch (NotFoundException e) {
                    LOG.warn((Object)("Source or destination not found for cloud file copy " + this.filePath + ". " + e.getMessage()));
                    JCRLocalCloudDrive.this.removeNode(this.node);
                    return;
                }
                catch (ConflictException e) {
                    if (attempts <= 100) {
                        JCRLocalCloudDrive.this.fixNameConflict(this.node);
                        continue;
                    }
                    JCRLocalCloudDrive.this.removeNode(this.node);
                    throw new SkipChangeException(e.getMessage() + ". Locally copied file removed.", e);
                }
                catch (ConstraintException e) {
                    LOG.warn((Object)("Constraint violation while synchronizing cloud file copy: " + e.getMessage() + ". " + (e.getCause() != null ? e.getCause().getMessage() : "") + ". Removing the copied file locally " + this.filePath));
                    JCRLocalCloudDrive.this.removeNode(this.node);
                    throw new SkipChangeException(e.getMessage() + ". Locally copied file removed.", e);
                }
                break;
            }
            this.fileId = this.file.getId();
        }

        private void create() throws SkipSyncException, SyncNotSupportedException, CloudDriveException, RepositoryException, InterruptedException {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Create file " + this.filePath));
            }
            this.begin();
            try {
                this.node.getIndex();
            }
            catch (InvalidItemStateException e) {
                LOG.warn((Object)("Cannot create already removed file. " + e.getMessage()));
                throw new SkipSyncException("Skip creation of already removed file. " + e.getMessage());
            }
            int attempts = 0;
            while (true) {
                ++attempts;
                try {
                    this.file = JCRLocalCloudDrive.this.synchronizer(this.node).create(this.node, JCRLocalCloudDrive.this.fileAPI);
                    this.filePath = this.file.getPath();
                }
                catch (NotFoundException e) {
                    LOG.warn((Object)("Parent not found cloud file creation " + this.filePath + ". " + e.getMessage()));
                    JCRLocalCloudDrive.this.removeNode(this.node);
                    return;
                }
                catch (ConflictException e) {
                    if (attempts <= 100) {
                        JCRLocalCloudDrive.this.fixNameConflict(this.node);
                        continue;
                    }
                    throw new SkipChangeException(e.getMessage() + ". Local file cannot be synchronized.", e);
                }
                catch (ConstraintException e) {
                    LOG.warn((Object)("Constraint violation while synchronizing cloud file creation: " + e.getMessage() + ". " + (e.getCause() != null ? e.getCause().getMessage() : "") + ". File exists only locally " + this.filePath));
                    throw new SkipChangeException(e.getMessage() + ". Local file cannot be synchronized.", e);
                }
                break;
            }
            this.fileId = this.file.getId();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Created file " + this.fileId + " " + this.filePath));
            }
        }
    }

    protected abstract class AbstractFileAPI
    implements CloudFileAPI {
        protected AbstractFileAPI() {
        }

        protected String rootPath() throws DriveRemovedException, RepositoryException {
            return JCRLocalCloudDrive.this.rootNode().getPath();
        }

        @Override
        public boolean isFolder(Node node) throws RepositoryException {
            return node.isNodeType(JCRLocalCloudDrive.ECD_CLOUDFOLDER);
        }

        @Override
        public boolean isFile(Node node) throws RepositoryException {
            return node.isNodeType(JCRLocalCloudDrive.ECD_CLOUDFILE);
        }

        @Override
        public boolean isFileResource(Node node) throws RepositoryException {
            return node.isNodeType(JCRLocalCloudDrive.ECD_CLOUDFILERESOURCE);
        }

        @Override
        public boolean isDrive(Node node) throws RepositoryException {
            return node.isNodeType(JCRLocalCloudDrive.ECD_CLOUDDRIVE);
        }

        @Override
        public boolean isIgnored(Node node) throws RepositoryException {
            return node.isNodeType(JCRLocalCloudDrive.ECD_IGNORED);
        }

        @Override
        public boolean ignore(Node node) throws RepositoryException {
            if (node.isNodeType(JCRLocalCloudDrive.ECD_IGNORED)) {
                return false;
            }
            node.addMixin(JCRLocalCloudDrive.ECD_IGNORED);
            return true;
        }

        @Override
        public boolean unignore(Node node) throws RepositoryException {
            if (node.isNodeType(JCRLocalCloudDrive.ECD_IGNORED)) {
                node.removeMixin(JCRLocalCloudDrive.ECD_IGNORED);
                return true;
            }
            return false;
        }

        @Override
        public String getId(Node fileNode) throws RepositoryException {
            return fileNode.getProperty("ecd:id").getString();
        }

        protected void setId(Node fileNode, String id) throws RepositoryException {
            fileNode.setProperty("ecd:id", id);
        }

        @Override
        public String getTitle(Node fileNode) throws RepositoryException {
            return fileNode.getProperty("exo:title").getString();
        }

        @Override
        public String getParentId(Node fileNode) throws RepositoryException {
            Node parent = fileNode.getParent();
            return parent.getProperty("ecd:id").getString();
        }

        @Override
        public String getAuthor(Node fileNode) throws RepositoryException {
            return fileNode.getProperty("ecd:author").getString();
        }

        @Override
        public String getLastUser(Node fileNode) throws RepositoryException {
            return fileNode.getProperty("ecd:lastUser").getString();
        }

        @Override
        public Calendar getCreated(Node fileNode) throws RepositoryException {
            return fileNode.getProperty("ecd:created").getDate();
        }

        @Override
        public Calendar getModified(Node fileNode) throws RepositoryException {
            return fileNode.getProperty("ecd:modified").getDate();
        }

        @Override
        public String getType(Node fileNode) throws RepositoryException {
            return fileNode.getProperty("ecd:type").getString();
        }

        @Override
        public Collection<String> findParents(String fileId) throws DriveRemovedException, RepositoryException {
            LinkedHashSet<String> parentIds = new LinkedHashSet<String>();
            for (Node fn : JCRLocalCloudDrive.this.findNodes(Arrays.asList(fileId))) {
                Node p = fn.getParent();
                parentIds.add(JCRLocalCloudDrive.this.fileAPI.getId(p));
            }
            return Collections.unmodifiableCollection(parentIds);
        }

        protected Collection<Node> findParentNodes(String fileId) throws DriveRemovedException, RepositoryException {
            LinkedHashSet<Node> parents = new LinkedHashSet<Node>();
            for (Node fn : JCRLocalCloudDrive.this.findNodes(Arrays.asList(fileId))) {
                Node p = fn.getParent();
                parents.add(p);
            }
            return Collections.unmodifiableCollection(parents);
        }
    }

    protected class SyncFilesCommand
    extends AbstractCommand {
        static final String NAME = "files synchronization";
        static final int RETRY_ATTEMPTS_MAX = 3;
        static final long RETRY_TIMEOUT_MAX = 60000L;
        static final long RETRY_TIMEOUT_DEFAULT = 2000L;
        final List<String> updating;
        final List<FileChange> applied;
        final List<FileChange> skipped;
        final List<FileChange> changes;

        SyncFilesCommand(List<FileChange> changes) {
            this.updating = new ArrayList<String>();
            this.applied = new ArrayList<FileChange>();
            this.skipped = new ArrayList<FileChange>();
            this.changes = changes;
            for (FileChange change : changes) {
                String path = change.path;
                JCRLocalCloudDrive.this.initUpdating(path);
                this.updating.add(path);
                String id = change.fileId;
                if (id == null) continue;
                JCRLocalCloudDrive.this.initUpdating(id);
                this.updating.add(id);
            }
        }

        void initDriveNode(Node driveNode) {
            this.driveNode = driveNode;
        }

        void updating(FileChange ch) {
            String path = ch.filePath;
            this.updating.add(path);
            JCRLocalCloudDrive.this.addUpdating(path);
            String id = ch.fileId;
            if (id != null) {
                this.updating.add(id);
                JCRLocalCloudDrive.this.addUpdating(id);
            }
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        protected void process() throws CloudDriveException, RepositoryException, InterruptedException {
            if (JCRLocalCloudDrive.this.isConnected()) {
                JCRLocalCloudDrive.this.syncLock.readLock().lock();
                try {
                    if (this.getAttempts() == 0) {
                        JCRLocalCloudDrive.this.saveChanges(this.changes);
                    }
                    this.sync();
                }
                finally {
                    JCRLocalCloudDrive.this.syncLock.readLock().unlock();
                }
                if (this.hasChanges()) {
                    JCRLocalCloudDrive.this.listeners.fireOnSynchronized(new CloudDriveEvent(JCRLocalCloudDrive.this.getUser(), JCRLocalCloudDrive.this.rootWorkspace, this.driveNode.getPath(), this.getFiles(), this.getRemoved()));
                }
            } else {
                LOG.warn((Object)("Cannot synchronize file in cloud drive '" + JCRLocalCloudDrive.this.title() + "': drive not connected"));
            }
        }

        @Override
        protected void always() {
            this.changes.clear();
        }

        @Override
        protected void preSaveChunk() throws CloudDriveException, RepositoryException {
        }

        @Override
        protected void save() throws RepositoryException, CloudDriveException {
            super.save();
            if (this.applied.size() > 0 || this.skipped.size() > 0) {
                JCRLocalCloudDrive.this.commitChanges(this.applied, this.skipped);
                this.applied.clear();
                this.skipped.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sync() throws RepositoryException, CloudDriveException, InterruptedException {
            try {
                Object accepted = new LinkedHashMap<String, FileChange>();
                LinkedHashSet<String> copied = new LinkedHashSet<String>();
                Iterator<FileChange> chiter = this.changes.iterator();
                while (chiter.hasNext() && !Thread.currentThread().isInterrupted()) {
                    FileChange change = chiter.next();
                    if (this.getAttempts() > 0 && !JCRLocalCloudDrive.this.hasChange(change)) continue;
                    try {
                        if (change.accept()) {
                            this.updating(change);
                            String path = change.filePath;
                            FileChange previous = (FileChange)accepted.get(path);
                            if (previous != null) {
                                String prevChange = previous.changeType;
                                if ("U".equals(change.changeType) && ("A".equals(prevChange) || "U".equals(prevChange) || "C".equals(prevChange))) {
                                    this.skipped.add(change);
                                    continue;
                                }
                                if ("D".equals(change.changeType)) {
                                    if ("A".equals(prevChange)) {
                                        this.skipped.add((FileChange)accepted.remove(path));
                                        this.skipped.add(change);
                                        continue;
                                    }
                                    if ("U".equals(prevChange) || "C".equals(prevChange)) {
                                        this.skipped.add((FileChange)accepted.remove(path));
                                    }
                                } else if ("A".equals(change.changeType) && "D".equals(prevChange)) {
                                    LinkedHashMap newOrder = new LinkedHashMap();
                                    for (Map.Entry ae : accepted.entrySet()) {
                                        if (ae.getValue() == previous) {
                                            newOrder.put(previous.fileId + path, previous);
                                            continue;
                                        }
                                        newOrder.put(ae.getKey(), ae.getValue());
                                    }
                                    accepted = newOrder;
                                } else if ("C".equals(change.changeType)) {
                                    if ("U".equals(prevChange)) {
                                        this.skipped.add((FileChange)accepted.remove(path));
                                    } else if ("A".equals(prevChange)) {
                                        this.skipped.add(change);
                                        continue;
                                    }
                                }
                            }
                            if ("A".equals(change.changeType) && change.fileId != null) {
                                String copiedParent = null;
                                for (String copyPath : copied) {
                                    if (path.length() <= copyPath.length() || !path.startsWith(copyPath)) continue;
                                    copiedParent = copyPath;
                                    break;
                                }
                                if (copiedParent != null) {
                                    this.skipped.add(change);
                                    continue;
                                }
                                copied.add(path);
                            }
                            accepted.put(path, change);
                            continue;
                        }
                        this.skipped.add(change);
                    }
                    catch (AccessDeniedException e) {
                        if (change != null && change.node != null && JCRLocalCloudDrive.this.isInTrash(change.node)) {
                            this.skipped.add(change);
                            continue;
                        }
                        throw e;
                    }
                    catch (PathNotFoundException e) {
                        if (change.changeType.equals("D")) {
                            this.skipped.add(change);
                            LOG.warn((Object)("Ignoring already removed item removal: " + change.fileId + " " + change.path), (Throwable)e);
                            continue;
                        }
                        if (change.changeType.equals("A")) {
                            this.skipped.add(change);
                            LOG.warn((Object)("Ignoring already removed item creation: " + change.path), (Throwable)e);
                            continue;
                        }
                        if (change.changeType.equals("U")) {
                            Node existing = JCRLocalCloudDrive.this.findNode(change.fileId);
                            if (existing != null) {
                                LOG.warn((Object)("Item already updated (file renamed) " + change.path + " belongs to " + existing.getPath() + ". Change faced with this: " + e.getMessage()));
                            } else {
                                LOG.warn((Object)("Item already removed (moved?) " + change.path + ". Change faced with this: " + e.getMessage()));
                            }
                            this.skipped.add(change);
                            continue;
                        }
                        if (e.getMessage().indexOf("/exo:thumbnails") > 0 && change.path.indexOf("/exo:thumbnails") > 0) {
                            this.skipped.add(change);
                            continue;
                        }
                        throw e;
                    }
                }
                HashSet<String> ignoredPaths = new HashSet<String>();
                Iterator chiter2 = accepted.values().iterator();
                block15: while (chiter2.hasNext() && !Thread.currentThread().isInterrupted()) {
                    FileChange change = (FileChange)chiter2.next();
                    String changePath = change.filePath;
                    for (String ipath : ignoredPaths) {
                        if (!changePath.startsWith(ipath)) continue;
                        this.skipped.add(change);
                        continue block15;
                    }
                    boolean applying = true;
                    int attempts = 0;
                    do {
                        applying = false;
                        try {
                            Node node;
                            change.apply();
                            this.applied.add(change);
                            if ("D".equals(change.changeType)) {
                                this.addRemoved(change.filePath);
                                continue;
                            }
                            CloudFile cfile = change.file;
                            if (cfile != null) {
                                this.addChanged(cfile);
                            }
                            if ((node = change.node) == null || node.isNew() || !node.isNodeType(JCRLocalCloudDrive.MIX_VERSIONABLE)) continue;
                            node.removeMixin(JCRLocalCloudDrive.MIX_VERSIONABLE);
                        }
                        catch (SyncNotSupportedException e) {
                            ignoredPaths.add(changePath);
                            this.skipped.add(change);
                        }
                        catch (SkipChangeException e) {
                            ignoredPaths.add(changePath);
                            this.skipped.add(change);
                            this.messages.add(new CloudDriveMessage(CloudDriveMessage.Type.WARN, e.getMessage()));
                        }
                        catch (RetryLaterException e) {
                            if (attempts > 3) {
                                throw e;
                            }
                            ++attempts;
                            long timeout = e.getTimeout();
                            if (timeout < 0L || timeout > 60000L) {
                                timeout = 60000L;
                            } else if (timeout == 0L) {
                                timeout = 2000L;
                            }
                            LOG.warn((Object)("File change retry requested for [" + change.changeType + "] " + changePath + " in " + this.getName() + " command of " + JCRLocalCloudDrive.this.title() + ". " + e.getMessage() + ". Will run retry in: " + timeout + "ms."));
                            Thread.sleep(timeout);
                            applying = true;
                        }
                        catch (PathNotFoundException e) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Unexpected PathNotFoundException for " + changePath + ": " + e.getMessage()));
                            }
                            if (change.changeType.equals("D")) {
                                this.skipped.add(change);
                                LOG.warn((Object)("[2] Ignoring already removed item removal: " + change.fileId + " " + changePath), (Throwable)e);
                                continue;
                            }
                            if (change.changeType.equals("A")) {
                                this.skipped.add(change);
                                LOG.warn((Object)("[2] Ignoring already removed item creation: " + changePath), (Throwable)e);
                                continue;
                            }
                            if (change.changeType.equals("U")) {
                                Node existing = JCRLocalCloudDrive.this.findNode(change.fileId);
                                if (existing == null) continue;
                                this.skipped.add(change);
                                LOG.warn((Object)("[2] Item already updated (file renamed) " + changePath + " belongs to " + existing.getPath() + ". Change faced with this: " + e.getMessage()));
                                continue;
                            }
                            if (e.getMessage().indexOf("/exo:thumbnails") > 0 && changePath.indexOf("/exo:thumbnails") > 0) {
                                ignoredPaths.add(changePath);
                                this.skipped.add(change);
                                continue;
                            }
                            throw e;
                        }
                        catch (AccessDeniedException e) {
                            if (change != null && change.node != null && JCRLocalCloudDrive.this.isInTrash(change.node)) {
                                this.skipped.add(change);
                                continue;
                            }
                            throw e;
                        }
                    } while (applying && !Thread.currentThread().isInterrupted());
                }
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException("Files synchronization interrupted in " + JCRLocalCloudDrive.this.title());
                }
                this.save();
                accepted.clear();
                ignoredPaths.clear();
            }
            finally {
                for (String key : this.updating) {
                    JCRLocalCloudDrive.this.removeUpdating(key);
                }
                this.updating.clear();
                if (this.messages.size() > 0) {
                    JCRLocalCloudDrive.this.syncFilesMessages.addAll(this.messages);
                    this.messages.clear();
                }
            }
        }
    }

    protected final class NoSyncCommand
    extends SyncCommand {
        protected NoSyncCommand() {
        }

        @Override
        protected void syncFiles() throws CloudDriveException, RepositoryException {
        }

        @Override
        protected void preSaveChunk() throws CloudDriveException, RepositoryException {
        }
    }

    protected abstract class SyncCommand
    extends AbstractCommand {
        protected Map<String, List<Node>> nodes;
        protected Set<String> linkedNodes;

        protected SyncCommand() {
            this.linkedNodes = new HashSet<String>();
        }

        @Override
        public String getName() {
            return "synchronization";
        }

        @Override
        protected void process() throws CloudDriveException, RepositoryException, InterruptedException {
            boolean hasChanges;
            JCRLocalCloudDrive.this.syncLock.writeLock().lock();
            try {
                this.preSyncFiles();
                this.syncFiles();
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException("Drive synchronization interrupted for " + JCRLocalCloudDrive.this.title());
                }
                hasChanges = this.hasChanges();
                this.save();
            }
            finally {
                Iterator miter = JCRLocalCloudDrive.this.syncFilesMessages.iterator();
                while (miter.hasNext()) {
                    this.messages.add(miter.next());
                    miter.remove();
                }
                JCRLocalCloudDrive.this.syncLock.writeLock().unlock();
                if (this.nodes != null) {
                    this.nodes.clear();
                }
            }
            if (hasChanges) {
                JCRLocalCloudDrive.this.listeners.fireOnSynchronized(new CloudDriveEvent(JCRLocalCloudDrive.this.getUser(), JCRLocalCloudDrive.this.rootWorkspace, this.driveNode.getPath(), this.getFiles(), this.getRemoved()));
            }
        }

        @Override
        protected void always() {
            JCRLocalCloudDrive.this.currentSync.set(JCRLocalCloudDrive.this.noSync);
        }

        protected void preSyncFiles() throws CloudDriveException, RepositoryException, InterruptedException {
            List<FileChange> changes = JCRLocalCloudDrive.this.savedChanges();
            if (changes.size() > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Applying stored local changes in " + JCRLocalCloudDrive.this.title()));
                }
                SyncFilesCommand localChanges = new SyncFilesCommand(changes);
                localChanges.initDriveNode(this.driveNode);
                localChanges.sync();
            }
        }

        protected abstract void syncFiles() throws CloudDriveException, RepositoryException, InterruptedException;

        protected void readLocalNodes() throws RepositoryException {
            LinkedHashMap<String, List<Node>> nodes = new LinkedHashMap<String, List<Node>>();
            String rootId = JCRLocalCloudDrive.this.fileAPI.getId(this.driveNode);
            ArrayList<Node> rootList = new ArrayList<Node>();
            rootList.add(this.driveNode);
            nodes.put(rootId, rootList);
            JCRLocalCloudDrive.this.readNodes(this.driveNode, nodes, true);
            this.nodes = nodes;
        }

        protected void removeLocalNode(Node node) throws RepositoryException, CloudDriveException {
            String npath = node.getPath();
            if (this.nodes != null) {
                Iterator<List<Node>> cnliter = this.nodes.values().iterator();
                while (cnliter.hasNext() && !Thread.currentThread().isInterrupted()) {
                    List<Node> cnl = cnliter.next();
                    Iterator<Node> ecniter = cnl.iterator();
                    while (ecniter.hasNext()) {
                        Node cn = ecniter.next();
                        if (!cn.getPath().startsWith(npath)) continue;
                        ecniter.remove();
                    }
                    if (cnl.size() != 0) continue;
                    cnliter.remove();
                }
            }
            JCRLocalCloudDrive.this.removeNode(node);
            this.addRemoved(npath);
        }

        @Override
        protected void save() throws RepositoryException, CloudDriveException {
            super.save();
            Session session = JCRLocalCloudDrive.this.session();
            for (String fileUUID : this.linkedNodes) {
                JCRLocalCloudDrive.this.removeLinks(session, fileUUID);
            }
        }
    }

    protected final class NoConnectCommand
    extends ConnectCommand {
        NoConnectCommand() throws RepositoryException, DriveRemovedException {
        }

        @Override
        protected void fetchFiles() throws CloudDriveException, RepositoryException {
        }
    }

    protected abstract class ConnectCommand
    extends AbstractCommand {
        private Map<String, Set<String>> connecting;
        private Map<String, Set<String>> connected;

        protected ConnectCommand() throws RepositoryException, DriveRemovedException {
            this.connecting = new HashMap<String, Set<String>>();
            this.connected = new HashMap<String, Set<String>>();
        }

        protected abstract void fetchFiles() throws CloudDriveException, RepositoryException;

        @Override
        protected final boolean addChanged(CloudFile file) throws RepositoryException, CloudDriveException {
            throw new IllegalStateException("Adding changed files not supported by " + this.getName() + " command! Use addConnected().");
        }

        protected boolean addConnected(String parentId, CloudFile file) throws RepositoryException, CloudDriveException {
            boolean r = super.addChanged(file);
            if (r) {
                this.connecting.computeIfAbsent(file.getId(), k -> new HashSet()).add(parentId);
            }
            return r;
        }

        @Override
        protected void preSaveChunk() throws CloudDriveException, RepositoryException {
            this.connected.putAll(this.connecting);
            this.connecting.clear();
        }

        protected boolean isConnected(String parentId, String fileId) {
            Set<String> connectedParents = this.connected.get(fileId);
            return connectedParents != null && connectedParents.contains(parentId);
        }

        @Override
        public String getName() {
            return "connect";
        }

        @Override
        protected void process() throws CloudDriveException, RepositoryException, InterruptedException {
            this.driveNode.setProperty("ecd:localChanges", DUMMY_DATA);
            this.driveNode.setProperty("ecd:localHistory", DUMMY_DATA);
            this.driveNode.setProperty("ecd:connected", false);
            this.save();
            this.fetchFiles();
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("Drive connection interrupted for " + JCRLocalCloudDrive.this.title());
            }
            this.driveNode.setProperty("ecd:cloudUserId", JCRLocalCloudDrive.this.getUser().getId());
            this.driveNode.setProperty("ecd:cloudUserName", JCRLocalCloudDrive.this.getUser().getUsername());
            this.driveNode.setProperty("ecd:userEmail", JCRLocalCloudDrive.this.getUser().getEmail());
            this.driveNode.setProperty("ecd:connectDate", Calendar.getInstance());
            this.driveNode.setProperty("ecd:connected", true);
            this.save();
            JCRLocalCloudDrive.this.listeners.fireOnConnect(new CloudDriveEvent(JCRLocalCloudDrive.this.getUser(), JCRLocalCloudDrive.this.rootWorkspace, this.driveNode.getPath()));
        }

        @Override
        protected void always() {
            JCRLocalCloudDrive.this.currentConnect.set(JCRLocalCloudDrive.this.noConnect);
        }
    }

    protected abstract class AbstractCommand
    implements CloudDrive.Command,
    CloudDrive.CommandProgress {
        protected final Queue<CloudDriveMessage> messages = new ConcurrentLinkedQueue<CloudDriveMessage>();
        protected Node driveNode;
        protected final AtomicInteger progressReported = new AtomicInteger();
        protected final AtomicLong startTime = new AtomicLong();
        protected final AtomicLong finishTime = new AtomicLong();
        protected final List<ChunkIterator<?>> iterators = new ArrayList();
        private final Queue<CloudFile> changed = new ConcurrentLinkedQueue<CloudFile>();
        private final Queue<String> removed = new ConcurrentLinkedQueue<String>();
        private int saved = 0;
        private int attemptNumb = 0;
        protected Future<CloudDrive.Command> async;
        protected ExoJCRSettings settings;

        protected AbstractCommand() {
        }

        public boolean equals(Object obj) {
            return this == obj;
        }

        public String toString() {
            return super.toString() + " (" + JCRLocalCloudDrive.this.title() + ")";
        }

        protected void save() throws RepositoryException, CloudDriveException {
            this.driveNode.save();
        }

        private boolean saveChunk() throws RepositoryException, CloudDriveException {
            int changedNumber = this.changed.size() + this.removed.size();
            if (changedNumber - this.saved > 15) {
                this.preSaveChunk();
                this.save();
                this.saved = changedNumber;
                return true;
            }
            return false;
        }

        protected boolean addChanged(CloudFile file) throws RepositoryException, CloudDriveException {
            boolean r = this.changed.add(file);
            this.saveChunk();
            return r;
        }

        protected boolean removeChanged(CloudFile file) {
            return this.changed.remove(file);
        }

        protected boolean isChanged(CloudFile file) {
            return this.changed.contains(file);
        }

        protected void replaceChanged(Collection<CloudFile> files) {
            this.changed.clear();
            this.changed.addAll(files);
        }

        protected boolean addRemoved(String path) throws RepositoryException, CloudDriveException {
            boolean r = this.removed.add(path);
            this.saveChunk();
            return r;
        }

        protected boolean removeRemoved(String path) {
            return this.removed.remove(path);
        }

        protected boolean isRemoved(String path) {
            return this.removed.contains(path);
        }

        protected void replaceRemoved(Collection<String> paths) {
            this.removed.clear();
            this.removed.addAll(paths);
        }

        @Override
        public int getAttempts() {
            return this.attemptNumb;
        }

        private void reset() {
            this.iterators.clear();
        }

        protected abstract void process() throws CloudDriveException, RepositoryException, InterruptedException;

        protected abstract void always();

        protected abstract void preSaveChunk() throws CloudDriveException, RepositoryException;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected final void exec() throws CloudDriveException, RepositoryException {
            block15: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("> Running drive " + this.getName() + " command of " + JCRLocalCloudDrive.this.title()));
                }
                this.startTime.set(System.currentTimeMillis());
                JCRLocalCloudDrive.this.driveCommands.add(this);
                try {
                    JCRLocalCloudDrive.this.commandEnv.prepare(this);
                    JCRLocalCloudDrive.this.jcrListener.disable();
                    JCRLocalCloudDrive.startAction(JCRLocalCloudDrive.this);
                    this.driveNode = JCRLocalCloudDrive.this.rootNode();
                    while (!Thread.currentThread().isInterrupted()) {
                        try {
                            this.process();
                            return;
                        }
                        catch (CloudProviderException e) {
                            if (Thread.currentThread().isInterrupted()) throw e;
                            if (!JCRLocalCloudDrive.this.getUser().getProvider().retryOnProviderError()) throw e;
                            ++this.attemptNumb;
                            if (this.attemptNumb > 3) {
                                throw e;
                            }
                            JCRLocalCloudDrive.this.rollback(this.driveNode);
                            this.reset();
                            LOG.warn((Object)("Error running " + this.getName() + " command of " + JCRLocalCloudDrive.this.title() + ". " + e.getMessage() + ". Rolled back and will run next attempt in " + 10000L + "ms."), (Throwable)e);
                            Thread.sleep(10000L);
                        }
                    }
                    if (!Thread.currentThread().isInterrupted()) break block15;
                    throw new InterruptedException("Drive " + this.getName() + " command interrupted for " + JCRLocalCloudDrive.this.title());
                }
                catch (CloudDriveException e) {
                    JCRLocalCloudDrive.this.handleError(this.driveNode, e, this.getName());
                    JCRLocalCloudDrive.this.commandEnv.fail(this, e);
                    throw e;
                }
                catch (RepositoryException e) {
                    JCRLocalCloudDrive.this.handleError(this.driveNode, e, this.getName());
                    JCRLocalCloudDrive.this.commandEnv.fail(this, e);
                    throw e;
                }
                catch (InterruptedException e) {
                    JCRLocalCloudDrive.this.handleError(this.driveNode, e, this.getName());
                    JCRLocalCloudDrive.this.commandEnv.fail(this, e);
                    Thread.currentThread().interrupt();
                    throw new CloudDriveException("Drive " + this.getName() + " canceled", e);
                }
                catch (RuntimeException e) {
                    JCRLocalCloudDrive.this.handleError(this.driveNode, e, this.getName());
                    JCRLocalCloudDrive.this.commandEnv.fail(this, e);
                    LOG.error((Object)("Runtime error. Drive " + this.getName() + " canceled. " + e.getMessage()));
                    throw e;
                }
            }
            LOG.warn((Object)("Drive " + this.getName() + " command of " + JCRLocalCloudDrive.this.title() + " finished unexpectedly."));
            return;
            finally {
                this.always();
                JCRLocalCloudDrive.doneAction();
                JCRLocalCloudDrive.this.jcrListener.enable();
                JCRLocalCloudDrive.this.commandEnv.cleanup(this);
                JCRLocalCloudDrive.this.driveCommands.remove(this);
                this.finishTime.set(System.currentTimeMillis());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("< Ended drive " + this.getName() + " command for " + JCRLocalCloudDrive.this.title() + " in " + (this.finishTime.get() - this.startTime.get()) + "ms."));
                }
            }
        }

        Future<CloudDrive.Command> start() throws CloudDriveException {
            JCRLocalCloudDrive.this.commandEnv.configure(this);
            this.async = JCRLocalCloudDrive.this.workerExecutor.submit(new CommandCallable(this));
            return this.async;
        }

        @Override
        public long getComplete() {
            int complete = 0;
            for (ChunkIterator<?> child : this.iterators) {
                complete = (int)((long)complete + child.getFetched());
            }
            return complete;
        }

        @Override
        public long getAvailable() {
            int available = 0;
            for (ChunkIterator<?> child : this.iterators) {
                available = (int)((long)available + child.getAvailable());
            }
            return Math.round((float)available * 1.075f);
        }

        @Override
        public int getProgress() {
            int reported;
            if (this.isDone()) {
                return 100;
            }
            int current = Math.round((float)this.getComplete() * 100.0f / (float)this.getAvailable());
            if (current >= (reported = this.progressReported.get())) {
                reported = current;
                this.progressReported.set(reported);
            }
            return reported;
        }

        @Override
        public boolean isDone() {
            return this.getFinishTime() > 0L;
        }

        @Override
        public long getStartTime() {
            return this.startTime.get();
        }

        @Override
        public long getFinishTime() {
            return this.finishTime.get();
        }

        @Override
        public boolean hasChanges() {
            return this.changed.size() > 0 || this.removed.size() > 0;
        }

        @Override
        public Collection<CloudFile> getFiles() {
            return Collections.unmodifiableCollection(this.changed);
        }

        @Override
        public Collection<String> getRemoved() {
            return Collections.unmodifiableCollection(this.removed);
        }

        @Override
        public void await() throws ExecutionException, InterruptedException {
            if (this.async != null && !this.async.isDone() && !this.async.isCancelled()) {
                this.async.get();
            }
        }

        @Override
        public Collection<CloudDriveMessage> getMessages() {
            LinkedHashSet<CloudDriveMessage> unique = new LinkedHashSet<CloudDriveMessage>();
            for (CloudDriveMessage m : this.messages) {
                unique.add(m);
            }
            return unique;
        }
    }

    protected class ExoJCREnvironment
    extends CloudDriveEnvironment {
        protected final Map<CloudDrive.Command, ExoJCRSettings> config = Collections.synchronizedMap(new HashMap());

        protected ExoJCREnvironment() {
        }

        @Override
        public void configure(CloudDrive.Command command) throws CloudDriveException {
            ConversationState conversation = ConversationState.getCurrent();
            if (conversation == null) {
                throw new CloudDriveException("Error to " + command.getName() + " drive for user " + JCRLocalCloudDrive.this.getUser().getEmail() + ". Conversation state not set.");
            }
            this.config.put(command, new ExoJCRSettings(conversation, ExoContainerContext.getCurrentContainer()));
            super.configure(command);
        }

        @Override
        public void prepare(CloudDrive.Command command) throws CloudDriveException {
            ExoJCRSettings settings = this.config.get(command);
            if (settings == null) {
                throw new CloudDriveException(((Object)((Object)this)).getClass().getName() + " setting not configured for " + command + " to be prepared.");
            }
            settings.prevConversation = ConversationState.getCurrent();
            ConversationState.setCurrent((ConversationState)settings.conversation);
            settings.prevContainer = ExoContainerContext.getCurrentContainerIfPresent();
            ExoContainerContext.setCurrentContainer((ExoContainer)settings.container);
            RequestLifeCycle.begin((ExoContainer)settings.container);
            settings.prevSessions = JCRLocalCloudDrive.this.sessionProviders.getSessionProvider(null);
            JCRLocalCloudDrive.this.sessionProviders.setSessionProvider(null, new SessionProvider(settings.conversation));
            super.prepare(command);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void cleanup(CloudDrive.Command command) throws CloudDriveException {
            CloudDriveException superError = null;
            RuntimeException superRuntimeError = null;
            super.cleanup(command);
            ExoJCRSettings settings = this.config.remove(command);
            if (settings != null) {
                SessionProvider sp = JCRLocalCloudDrive.this.sessionProviders.getSessionProvider(null);
                RequestLifeCycle.end();
                JCRLocalCloudDrive.this.sessionProviders.setSessionProvider(null, settings.prevSessions);
                ExoContainerContext.setCurrentContainer((ExoContainer)settings.prevContainer);
                ConversationState.setCurrent((ConversationState)settings.prevConversation);
                sp.close();
            } else {
                String message = ((Object)((Object)this)).getClass().getName() + " setting not configured for " + command + " to be cleaned";
                if (superError != null) {
                    LOG.warn((Object)(message + ". But another error raised: " + superError.getMessage()));
                    throw superError;
                }
                if (superRuntimeError != null) {
                    LOG.warn((Object)(message + ". But runtime error raised: " + superRuntimeError.getMessage()));
                    throw superRuntimeError;
                }
                throw new CloudDriveException(message);
                catch (CloudDriveException cde) {
                    block17: {
                        superError = cde;
                        settings = this.config.remove(command);
                        if (settings == null) break block17;
                        SessionProvider sp = JCRLocalCloudDrive.this.sessionProviders.getSessionProvider(null);
                        RequestLifeCycle.end();
                        JCRLocalCloudDrive.this.sessionProviders.setSessionProvider(null, settings.prevSessions);
                        ExoContainerContext.setCurrentContainer((ExoContainer)settings.prevContainer);
                        ConversationState.setCurrent((ConversationState)settings.prevConversation);
                        sp.close();
                    }
                    message = ((Object)((Object)this)).getClass().getName() + " setting not configured for " + command + " to be cleaned";
                    if (superError != null) {
                        LOG.warn((Object)(message + ". But another error raised: " + superError.getMessage()));
                        throw superError;
                    }
                    if (superRuntimeError != null) {
                        LOG.warn((Object)(message + ". But runtime error raised: " + superRuntimeError.getMessage()));
                        throw superRuntimeError;
                    }
                    throw new CloudDriveException(message);
                }
                catch (RuntimeException ue) {
                    block18: {
                        superRuntimeError = ue;
                        settings = this.config.remove(command);
                        if (settings == null) break block18;
                        {
                            catch (Throwable throwable) {
                                ExoJCRSettings settings2 = this.config.remove(command);
                                if (settings2 == null) {
                                    String message2 = ((Object)((Object)this)).getClass().getName() + " setting not configured for " + command + " to be cleaned";
                                    if (superError != null) {
                                        LOG.warn((Object)(message2 + ". But another error raised: " + superError.getMessage()));
                                        throw superError;
                                    }
                                    if (superRuntimeError != null) {
                                        LOG.warn((Object)(message2 + ". But runtime error raised: " + superRuntimeError.getMessage()));
                                        throw superRuntimeError;
                                    }
                                    throw new CloudDriveException(message2);
                                }
                                SessionProvider sp = JCRLocalCloudDrive.this.sessionProviders.getSessionProvider(null);
                                RequestLifeCycle.end();
                                JCRLocalCloudDrive.this.sessionProviders.setSessionProvider(null, settings2.prevSessions);
                                ExoContainerContext.setCurrentContainer((ExoContainer)settings2.prevContainer);
                                ConversationState.setCurrent((ConversationState)settings2.prevConversation);
                                sp.close();
                                throw throwable;
                            }
                        }
                        SessionProvider sp = JCRLocalCloudDrive.this.sessionProviders.getSessionProvider(null);
                        RequestLifeCycle.end();
                        JCRLocalCloudDrive.this.sessionProviders.setSessionProvider(null, settings.prevSessions);
                        ExoContainerContext.setCurrentContainer((ExoContainer)settings.prevContainer);
                        ConversationState.setCurrent((ConversationState)settings.prevConversation);
                        sp.close();
                    }
                    message = ((Object)((Object)this)).getClass().getName() + " setting not configured for " + command + " to be cleaned";
                    if (superError != null) {
                        LOG.warn((Object)(message + ". But another error raised: " + superError.getMessage()));
                        throw superError;
                    }
                    if (superRuntimeError != null) {
                        LOG.warn((Object)(message + ". But runtime error raised: " + superRuntimeError.getMessage()));
                        throw superRuntimeError;
                    }
                    throw new CloudDriveException(message);
                }
            }
        }
    }

    protected class ExoJCRSettings {
        final ConversationState conversation;
        final ExoContainer container;
        ConversationState prevConversation;
        ExoContainer prevContainer;
        SessionProvider prevSessions;

        ExoJCRSettings(ConversationState conversation, ExoContainer container) {
            this.conversation = conversation;
            this.container = container;
        }
    }

    protected class CommandCallable
    implements Callable<CloudDrive.Command> {
        final AbstractCommand command;

        CommandCallable(AbstractCommand command) throws CloudDriveException {
            this.command = command;
        }

        @Override
        public CloudDrive.Command call() throws Exception {
            this.command.exec();
            return this.command;
        }
    }

    public class JCRListener {
        final String initialRootPath;
        final RemoveDriveListener removeListener;
        final AddTrashListener trashListener;
        final DriveChangesListener changesListener;
        volatile boolean trashed = false;
        volatile boolean added = false;

        JCRListener(String initialRootPath) {
            this.initialRootPath = initialRootPath;
            this.removeListener = new RemoveDriveListener();
            this.trashListener = new AddTrashListener();
            this.changesListener = new DriveChangesListener();
        }

        synchronized void checkTrashed(Node driveRoot) throws RepositoryException {
            if (this.trashed && this.added) {
                try {
                    if (driveRoot.getParent().isNodeType(JCRLocalCloudDrive.EXO_TRASHFOLDER)) {
                        this.finishTrashed(driveRoot.getSession(), driveRoot.getPath());
                        JCRLocalCloudDrive.this.workerExecutor.submit(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                boolean interrupted = false;
                                try {
                                    Session session = JCRLocalCloudDrive.this.systemSession();
                                    Node driveRoot = session.getNodeByUUID(JCRLocalCloudDrive.this.rootUUID);
                                    try {
                                        Thread.sleep(2000L);
                                    }
                                    catch (InterruptedException e) {
                                        LOG.warn((Object)("Cloud Drive remover interrupted " + e.getMessage()));
                                        interrupted = true;
                                    }
                                    JCRLocalCloudDrive.startAction(JCRLocalCloudDrive.this);
                                    try {
                                        JCRLocalCloudDrive.this.disconnect(driveRoot);
                                    }
                                    catch (Throwable e) {
                                        LOG.error((Object)("Error disconnecting Cloud Drive " + JCRLocalCloudDrive.this.title() + " before its removal. " + e.getMessage()), e);
                                    }
                                    try {
                                        driveRoot.remove();
                                        session.save();
                                        LOG.info((Object)("Cloud Drive " + JCRLocalCloudDrive.this.title() + " successfully removed from the Trash."));
                                    }
                                    catch (ItemNotFoundException e) {
                                        LOG.warn((Object)("Cloud Drive " + JCRLocalCloudDrive.this.title() + " node already removed directly from JCR: " + e.getMessage()));
                                    }
                                }
                                catch (Throwable e) {
                                    LOG.error((Object)("Error removing node of Cloud Drive " + JCRLocalCloudDrive.this.title() + ". " + e.getMessage()), e);
                                }
                                finally {
                                    JCRLocalCloudDrive.doneAction();
                                    if (interrupted) {
                                        Thread.currentThread().interrupt();
                                    }
                                }
                            }
                        });
                    }
                }
                catch (ItemNotFoundException itemNotFoundException) {
                    // empty catch block
                }
            }
        }

        void finishTrashed(Session session, String rootPath) {
            this.added = false;
            this.trashed = false;
            try {
                JCRLocalCloudDrive.this.removeJCRListener(session);
            }
            catch (RepositoryException e) {
                LOG.error((Object)("Error unregistering Cloud Drive '" + JCRLocalCloudDrive.this.title() + "' node listeners: " + e.getMessage()), (Throwable)e);
            }
            JCRLocalCloudDrive.this.listeners.fireOnRemove(new CloudDriveEvent(JCRLocalCloudDrive.this.getUser(), JCRLocalCloudDrive.this.rootWorkspace, rootPath));
        }

        public void enable() {
            this.changesListener.enable();
        }

        public void disable() {
            this.changesListener.disable();
        }

        class DriveChangesListener
        extends BaseCloudDriveListener
        implements EventListener {
            final ThreadLocal<AtomicLong> lock = new ThreadLocal();
            final AtomicReference<SyncFilesCommand> delayedChanges = new AtomicReference();

            DriveChangesListener() {
            }

            void disable() {
                AtomicLong requests = this.lock.get();
                if (requests == null) {
                    requests = new AtomicLong(1L);
                    this.lock.set(requests);
                } else {
                    requests.incrementAndGet();
                }
            }

            void enable() {
                AtomicLong requests = this.lock.get();
                if (requests == null) {
                    requests = new AtomicLong(0L);
                    this.lock.set(requests);
                } else if (requests.get() > 0L) {
                    requests.decrementAndGet();
                }
            }

            boolean enabled() {
                AtomicLong requests = this.lock.get();
                return requests == null || requests.get() == 0L;
            }

            public void onEvent(EventIterator events) {
                if (this.enabled()) {
                    try {
                        SyncFilesCommand delayed;
                        ArrayList<FileChange> changes = new ArrayList<FileChange>();
                        boolean moveGuessed = false;
                        HashSet<String> addedNodes = new HashSet<String>();
                        while (events.hasNext()) {
                            Event event = events.nextEvent();
                            String eventPath = event.getPath();
                            if (eventPath.endsWith("/jcr:mixinTypes") || eventPath.endsWith("/jcr:content") || eventPath.indexOf("/ecd:") >= 0 || eventPath.indexOf("/exo:thumbnails") > 0) continue;
                            if (event.getType() == 2) {
                                FileChange remove;
                                Map<String, FileChange> removed;
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)("Node removed. User: " + event.getUserID() + ". Path: " + eventPath));
                                }
                                if ((removed = JCRLocalCloudDrive.this.fileRemovals.get()) != null && (remove = removed.remove(eventPath)) != null) {
                                    changes.add(remove);
                                    continue;
                                }
                                moveGuessed = true;
                                continue;
                            }
                            if (event.getType() == 1) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)("Node added. User: " + event.getUserID() + ". Path: " + eventPath));
                                }
                                if (moveGuessed) {
                                    addedNodes.add(eventPath);
                                }
                                changes.add(new FileChange(eventPath, "A"));
                                continue;
                            }
                            if (event.getType() != 16) continue;
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Node property changed. User: " + event.getUserID() + ". Path: " + eventPath));
                            }
                            if (moveGuessed && (eventPath.endsWith("/exo:name") || eventPath.endsWith("/exo:title")) && addedNodes.contains(JCRLocalCloudDrive.this.parentPath(eventPath))) {
                                moveGuessed = false;
                            }
                            changes.add(new FileChange(eventPath, "U"));
                        }
                        if (changes.size() > 0) {
                            if (moveGuessed) {
                                delayed = new SyncFilesCommand(changes);
                                JCRLocalCloudDrive.this.commandEnv.configure(delayed);
                                SyncFilesCommand prevDelayed = this.delayedChanges.getAndSet(delayed);
                                if (prevDelayed != null) {
                                    prevDelayed.start();
                                }
                                JCRLocalCloudDrive.this.workerExecutor.submit(new DelayedStart(1250L));
                            } else {
                                delayed = this.delayedChanges.getAndSet(null);
                                if (delayed != null) {
                                    delayed.changes.addAll(changes);
                                    delayed.start();
                                } else {
                                    new SyncFilesCommand(changes).start();
                                }
                            }
                        } else {
                            delayed = this.delayedChanges.getAndSet(null);
                            if (delayed != null) {
                                delayed.start();
                            }
                        }
                    }
                    catch (CloudDriveException e) {
                        LOG.error((Object)("Error starting file synchronization in cloud drive '" + JCRLocalCloudDrive.this.title() + "'"), (Throwable)e);
                    }
                    catch (RepositoryException e) {
                        LOG.error((Object)("Error reading cloud file for synchronization in cloud drive '" + JCRLocalCloudDrive.this.title() + "'"), (Throwable)e);
                    }
                }
            }

            @Override
            public void onError(CloudDriveEvent event, Throwable error, String operationName) {
                if (operationName.equals("files synchronization")) {
                    if (error instanceof RefreshAccessException) {
                        Throwable cause = error.getCause();
                        LOG.error((Object)("Error running " + operationName + " in drive " + JCRLocalCloudDrive.this.title() + ". " + error.getMessage() + (cause != null ? ". " + cause.getMessage() : "")));
                    } else {
                        LOG.error((Object)("Error running " + operationName + " in drive " + JCRLocalCloudDrive.this.title()), error);
                    }
                }
            }

            class DelayedStart
            implements Runnable {
                final long delay;

                DelayedStart(long delay) {
                    this.delay = delay;
                }

                @Override
                public void run() {
                    try {
                        Thread.sleep(this.delay);
                        SyncFilesCommand delayed = DriveChangesListener.this.delayedChanges.getAndSet(null);
                        if (delayed != null) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("> Starting delayed files synchronization of " + JCRLocalCloudDrive.this.title()));
                            }
                            delayed.exec();
                        }
                    }
                    catch (InterruptedException e) {
                        LOG.warn((Object)("Failed to wait for delayed file synchronization in cloud drive '" + JCRLocalCloudDrive.this.title() + "'"), (Throwable)e);
                        Thread.currentThread().interrupt();
                    }
                    catch (CloudDriveException e) {
                        LOG.error((Object)("Error starting delayed file synchronization in cloud drive '" + JCRLocalCloudDrive.this.title() + "'"), (Throwable)e);
                    }
                    catch (RepositoryException e) {
                        LOG.error((Object)("Error applyting delayed file synchronization in cloud drive '" + JCRLocalCloudDrive.this.title() + "'"), (Throwable)e);
                    }
                }
            }
        }

        class AddTrashListener
        implements EventListener {
            AddTrashListener() {
            }

            public void onEvent(EventIterator events) {
                String userId = null;
                try {
                    Session session = JCRLocalCloudDrive.this.systemSession();
                    Node driveRoot = null;
                    while (events.hasNext()) {
                        Event event = events.nextEvent();
                        userId = event.getUserID();
                        String path = event.getPath();
                        try {
                            Item item = session.getItem(path);
                            if (item.isNode()) {
                                Node node = (Node)item;
                                if (node.isNodeType(JCRLocalCloudDrive.ECD_CLOUDDRIVE)) {
                                    String rootPath;
                                    if (driveRoot == null) {
                                        try {
                                            driveRoot = session.getNodeByUUID(JCRLocalCloudDrive.this.rootUUID);
                                        }
                                        catch (ItemNotFoundException e) {
                                            LOG.warn((Object)("Cloud Drive " + JCRLocalCloudDrive.this.title() + " node already removed directly from JCR: " + e.getMessage()));
                                            JCRListener.this.finishTrashed(session, JCRListener.this.initialRootPath);
                                            continue;
                                        }
                                    }
                                    if ((rootPath = driveRoot.getPath()).equals(path)) {
                                        JCRListener.this.added = true;
                                        if (LOG.isDebugEnabled()) {
                                            LOG.debug((Object)("Cloud Drive trashed " + path));
                                        }
                                    }
                                    JCRListener.this.checkTrashed(driveRoot);
                                    continue;
                                }
                                if (!JCRLocalCloudDrive.this.fileAPI.isFile(node) || JCRLocalCloudDrive.this.fileAPI.isIgnored(node) || !JCRLocalCloudDrive.this.rootUUID.equals(node.getProperty("ecd:driveUUID").getString())) continue;
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)("Cloud drive item trashed " + path));
                                }
                                node.setProperty("ecd:trashed", true);
                                node.save();
                                String fileId = JCRLocalCloudDrive.this.fileAPI.getId(node);
                                FileTrashing confirmation = new FileTrashing();
                                FileTrashing existing = JCRLocalCloudDrive.this.fileTrash.putIfAbsent(fileId, confirmation);
                                if (existing != null) {
                                    confirmation = existing;
                                }
                                confirmation.confirm(path, fileId);
                                if (JCRLocalCloudDrive.this.fileAPI.isTrashSupported()) continue;
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)("Cloud drive item in Trash will be removed permanently " + path));
                                }
                                confirmation.remove();
                                continue;
                            }
                            LOG.warn((Object)("Item in Trash not a node:" + path));
                        }
                        catch (PathNotFoundException e) {
                            LOG.warn((Object)("Cloud item already deleted directly from JCR: " + path));
                        }
                    }
                }
                catch (AccessDeniedException session) {
                }
                catch (RepositoryException e) {
                    LOG.error((Object)("Error handling Cloud Drive " + JCRLocalCloudDrive.this.title() + " item move to Trash event" + (userId != null ? " for user " + userId : "")), (Throwable)e);
                }
            }
        }

        class RemoveDriveListener
        implements EventListener {
            RemoveDriveListener() {
            }

            public void onEvent(EventIterator events) {
                String userId = null;
                try {
                    Node driveRoot;
                    Session session = JCRLocalCloudDrive.this.systemSession();
                    try {
                        driveRoot = session.getNodeByUUID(JCRLocalCloudDrive.this.rootUUID);
                    }
                    catch (ItemNotFoundException e) {
                        LOG.warn((Object)("Cloud Drive '" + JCRLocalCloudDrive.this.title() + "' node already removed directly from JCR: " + e.getMessage()));
                        JCRListener.this.finishTrashed(session, JCRListener.this.initialRootPath);
                        return;
                    }
                    while (events.hasNext()) {
                        Event event = events.nextEvent();
                        userId = event.getUserID();
                        if (!JCRListener.this.initialRootPath.equals(event.getPath())) continue;
                        JCRListener.this.trashed = true;
                    }
                    JCRListener.this.checkTrashed(driveRoot);
                }
                catch (AccessDeniedException session) {
                }
                catch (RepositoryException e) {
                    LOG.error((Object)("Error handling Cloud Drive '" + JCRLocalCloudDrive.this.title() + "' node move/remove event" + (userId != null ? " for user " + userId : "")), (Throwable)e);
                }
            }
        }
    }

    class FileTrashing {
        private final CountDownLatch latch = new CountDownLatch(1);
        private String trashPath;
        private String fileId;
        private boolean remove = false;

        FileTrashing() {
        }

        void confirm(String path, String fileId) {
            this.trashPath = path;
            this.fileId = fileId;
            this.latch.countDown();
        }

        void remove() {
            this.remove = true;
        }

        void complete() throws InterruptedException, RepositoryException {
            this.latch.await(60L, TimeUnit.SECONDS);
            if (this.remove) {
                this.removeTrashed();
            }
        }

        private void removeTrashed() throws RepositoryException {
            if (this.trashPath != null && this.fileId != null) {
                Node trash;
                Session session = JCRLocalCloudDrive.this.systemSession();
                Item trashed = session.getItem(this.trashPath);
                if (trashed.isNode()) {
                    Node file = (Node)trashed;
                    if (JCRLocalCloudDrive.this.fileAPI.isFile(file) && this.fileId.equals(JCRLocalCloudDrive.this.fileAPI.getId(file)) && JCRLocalCloudDrive.this.rootUUID.equals(file.getProperty("ecd:driveUUID").getString())) {
                        JCRLocalCloudDrive.this.removeNode(file);
                        session.save();
                        return;
                    }
                    trash = trashed.getParent();
                } else {
                    trash = trashed.getParent().getParent();
                }
                QueryManager qm = session.getWorkspace().getQueryManager();
                Query q = qm.createQuery("SELECT * FROM ecd:cloudFile WHERE ecd:id=" + this.fileId + " AND jcr:path LIKE '" + trash.getPath() + "/%'", "sql");
                QueryResult qr = q.execute();
                NodeIterator niter = qr.getNodes();
                while (niter.hasNext()) {
                    Node file = niter.nextNode();
                    if (!JCRLocalCloudDrive.this.rootUUID.equals(file.getProperty("ecd:driveUUID").getString())) continue;
                    JCRLocalCloudDrive.this.removeNode(file);
                }
                session.save();
            }
        }
    }

    static class AlreadyDone
    implements CloudDrive.Command {
        final long time = System.currentTimeMillis();

        AlreadyDone() {
        }

        @Override
        public int getProgress() {
            return 100;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public boolean hasChanges() {
            return false;
        }

        @Override
        public Collection<CloudFile> getFiles() {
            return Collections.emptyList();
        }

        @Override
        public Collection<String> getRemoved() {
            return Collections.emptyList();
        }

        @Override
        public Collection<CloudDriveMessage> getMessages() {
            return Collections.emptyList();
        }

        @Override
        public long getStartTime() {
            return this.time;
        }

        @Override
        public long getFinishTime() {
            return this.time;
        }

        @Override
        public void await() {
        }

        @Override
        public String getName() {
            return "complete";
        }
    }
}

