/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.clouddrive.CloudFile;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class LocalCloudFile
implements CloudFile {
    protected static final Log LOG = ExoLogger.getLogger(LocalCloudFile.class);
    private String modifiedLocal;
    private String modifiedRemote;

    public void initModified(Locale locale) {
        Node node = this.getNode();
        if (node != null) {
            try {
                Calendar modifiedLocalDate = node.getProperty("exo:lastModifiedDate").getDate();
                this.modifiedLocal = this.formatLocalizedDate(modifiedLocalDate, locale);
                this.modifiedRemote = this.formatLocalizedDate(this.getModifiedDate(), locale);
            }
            catch (RepositoryException e) {
                LOG.warn((Object)("Cannot initialize cloud file modified fields:" + e.getMessage()));
            }
        }
    }

    private String formatLocalizedDate(Calendar date, Locale locale) {
        if (date != null && locale != null) {
            DateFormat dateFormat = SimpleDateFormat.getDateInstance(3, locale);
            return dateFormat.format(date.getTime());
        }
        return null;
    }

    public String getModifiedRemote() {
        return this.modifiedRemote;
    }

    public String getModifiedLocal() {
        return this.modifiedLocal;
    }

    @Override
    public final boolean isConnected() {
        return true;
    }

    public abstract Node getNode();
}

