/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.sharing.SharedLinkSettings;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

class ModifySharedLinkSettingsArgs {
    protected final String url;
    protected final SharedLinkSettings settings;
    protected final boolean removeExpiration;

    public ModifySharedLinkSettingsArgs(String url, SharedLinkSettings settings, boolean removeExpiration) {
        if (url == null) {
            throw new IllegalArgumentException("Required value for 'url' is null");
        }
        this.url = url;
        if (settings == null) {
            throw new IllegalArgumentException("Required value for 'settings' is null");
        }
        this.settings = settings;
        this.removeExpiration = removeExpiration;
    }

    public ModifySharedLinkSettingsArgs(String url, SharedLinkSettings settings) {
        this(url, settings, false);
    }

    public String getUrl() {
        return this.url;
    }

    public SharedLinkSettings getSettings() {
        return this.settings;
    }

    public boolean getRemoveExpiration() {
        return this.removeExpiration;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.url, this.settings, this.removeExpiration});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            ModifySharedLinkSettingsArgs other = (ModifySharedLinkSettingsArgs)obj;
            return !(this.url != other.url && !this.url.equals(other.url) || this.settings != other.settings && !this.settings.equals(other.settings) || this.removeExpiration != other.removeExpiration);
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<ModifySharedLinkSettingsArgs> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(ModifySharedLinkSettingsArgs value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("url");
            StoneSerializers.string().serialize(value.url, g);
            g.writeFieldName("settings");
            SharedLinkSettings.Serializer.INSTANCE.serialize(value.settings, g);
            g.writeFieldName("remove_expiration");
            StoneSerializers.boolean_().serialize((Boolean)value.removeExpiration, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public ModifySharedLinkSettingsArgs deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Boolean f_removeExpiration;
            SharedLinkSettings f_settings;
            String f_url;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_url = null;
                f_settings = null;
                f_removeExpiration = false;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("url".equals(field)) {
                        f_url = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("settings".equals(field)) {
                        f_settings = (SharedLinkSettings)SharedLinkSettings.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("remove_expiration".equals(field)) {
                        f_removeExpiration = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_url == null) {
                    throw new JsonParseException(p, "Required field \"url\" missing.");
                }
                if (f_settings == null) {
                    throw new JsonParseException(p, "Required field \"settings\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            ModifySharedLinkSettingsArgs value = new ModifySharedLinkSettingsArgs(f_url, f_settings, f_removeExpiration);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

