/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.rest;

import javax.annotation.security.RolesAllowed;
import javax.jcr.LoginException;
import javax.jcr.RepositoryException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.clouddrive.CannotCreateDriveException;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveService;
import org.exoplatform.clouddrive.CloudProvider;
import org.exoplatform.clouddrive.ProviderNotAvailableException;
import org.exoplatform.clouddrive.features.CloudDriveFeatures;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;

@Path(value="/clouddrive/features")
@Produces(value={"application/json"})
public class FeaturesService
implements ResourceContainer {
    protected static final Log LOG = ExoLogger.getLogger(FeaturesService.class);
    protected final CloudDriveFeatures features;
    protected final CloudDriveService cloudDrives;
    protected final RepositoryService jcrService;
    protected final SessionProviderService sessionProviders;

    public FeaturesService(CloudDriveService cloudDrives, CloudDriveFeatures features, RepositoryService jcrService, SessionProviderService sessionProviders) {
        this.cloudDrives = cloudDrives;
        this.features = features;
        this.jcrService = jcrService;
        this.sessionProviders = sessionProviders;
    }

    @GET
    @Path(value="/can-create-drive/")
    @RolesAllowed(value={"users"})
    public Response canCreateDrive(@Context UriInfo uriInfo, @QueryParam(value="workspace") String workspace, @QueryParam(value="path") String path, @QueryParam(value="provider") String providerId) {
        if (workspace != null) {
            if (path != null) {
                CloudProvider provider;
                if (providerId != null && providerId.length() > 0) {
                    try {
                        provider = this.cloudDrives.getProvider(providerId);
                    }
                    catch (ProviderNotAvailableException e) {
                        LOG.warn((Object)("Unknown provider: " + providerId));
                        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Unknown provider.").build();
                    }
                } else {
                    provider = null;
                }
                ConversationState currentConvo = ConversationState.getCurrent();
                try {
                    boolean result = this.features.canCreateDrive(workspace, path, currentConvo != null ? currentConvo.getIdentity().getUserId() : null, provider);
                    return Response.ok().entity((Object)("{\"result\":\"" + result + "\"}")).build();
                }
                catch (CannotCreateDriveException e) {
                    return Response.ok().entity((Object)("{\"result\":\"false\", \"message\":\"" + e.getMessage() + "\"}")).build();
                }
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Null path.").build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Null workspace.").build();
    }

    @GET
    @Path(value="/is-autosync-enabled/")
    @RolesAllowed(value={"users"})
    public Response isAutosyncEnabled(@Context UriInfo uriInfo, @QueryParam(value="workspace") String workspace, @QueryParam(value="path") String path) {
        if (workspace != null) {
            if (path != null) {
                try {
                    CloudDrive local = this.cloudDrives.findDrive(workspace, path);
                    if (local != null) {
                        boolean result = this.features.isAutosyncEnabled(local);
                        return Response.ok().entity((Object)("{\"result\":\"" + result + "\"}")).build();
                    }
                    LOG.warn((Object)("Item " + workspace + ":" + path + " not a cloud file or drive not connected."));
                    return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
                }
                catch (LoginException e) {
                    LOG.warn((Object)("Error login to read drive " + workspace + ":" + path + ". " + e.getMessage()));
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Authentication error.").build();
                }
                catch (RepositoryException e) {
                    LOG.error((Object)("Error getting autosync status of a drive " + workspace + ":" + path), (Throwable)e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Error reading drive: storage error.").build();
                }
                catch (Throwable e) {
                    LOG.error((Object)("Error getting autosync status of a drive " + workspace + ":" + path), e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Error reading drive: runtime error.").build();
                }
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Null path.").build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Null workspace.").build();
    }
}

