/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.ecms.action;

import java.util.Map;
import java.util.regex.Matcher;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveService;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.rightclick.manager.DeleteManageComponent;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.exception.MessageException;

@ComponentConfig(events={@EventConfig(listeners={DeleteActionListener.class})})
public class CloudDriveDeleteManageComponent
extends DeleteManageComponent {
    private static final Log LOG = ExoLogger.getLogger((String)CloudDriveDeleteManageComponent.class.getName());

    public static class DeleteActionListener
    extends DeleteManageComponent.DeleteActionListener {
        protected Map<String, Object> createContext(Event<DeleteManageComponent> event) throws Exception {
            Map context = super.createContext(event);
            if (context != null) {
                UIJCRExplorer uiExplorer = (UIJCRExplorer)((DeleteManageComponent)event.getSource()).getAncestorOfType(UIJCRExplorer.class);
                String nodePath = event.getRequestContext().getRequestParameter("objectId");
                try {
                    Node currentNode = this.getNodeByPath(nodePath, uiExplorer, false);
                    CloudDriveService driveService = (CloudDriveService)WCMCoreUtils.getService(CloudDriveService.class);
                    CloudDrive drive = driveService.findDrive(currentNode);
                    if (drive != null) {
                        context.put(Node.class.getName(), currentNode);
                    }
                }
                catch (PathNotFoundException pte) {
                    throw new MessageException(new ApplicationMessage("UIPopupMenu.msg.path-not-found", null, 1));
                }
                catch (Exception e) {
                    LOG.error((Object)"Unexpected error while updating listener context", (Throwable)e);
                }
            }
            return context;
        }

        private Node getNodeByPath(String nodePath, UIJCRExplorer uiExplorer, boolean giveTarget) throws Exception {
            nodePath = uiExplorer.getCurrentWorkspace() + ":" + nodePath;
            Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(nodePath);
            String wsName = null;
            if (matcher.find()) {
                wsName = matcher.group(1);
                nodePath = matcher.group(2);
            } else {
                wsName = uiExplorer.getCurrentWorkspace();
            }
            Session session = uiExplorer.getSessionByWorkspace(wsName);
            return uiExplorer.getNodeByPath(nodePath, session, giveTarget);
        }
    }
}

