/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2;

import com.dropbox.core.DbxHost;
import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.DbxRequestUtil;
import com.dropbox.core.http.HttpRequestor;
import com.dropbox.core.v2.DbxClientV2;
import com.dropbox.core.v2.DbxRawClientV2;
import com.dropbox.core.v2.DbxTeamClientV2Base;
import com.dropbox.core.v2.common.PathRoot;
import java.util.List;

public class DbxTeamClientV2
extends DbxTeamClientV2Base {
    private final String accessToken;

    public DbxTeamClientV2(DbxRequestConfig requestConfig, String accessToken) {
        this(requestConfig, accessToken, DbxHost.DEFAULT);
    }

    public DbxTeamClientV2(DbxRequestConfig requestConfig, String accessToken, DbxHost host) {
        this(requestConfig, accessToken, host, null);
    }

    public DbxTeamClientV2(DbxRequestConfig requestConfig, String accessToken, DbxHost host, String userId) {
        super(new DbxTeamRawClientV2(requestConfig, host, accessToken, userId, null, null, null));
        this.accessToken = accessToken;
    }

    public DbxClientV2 asMember(String memberId) {
        if (memberId == null) {
            throw new IllegalArgumentException("'memberId' should not be null");
        }
        DbxTeamRawClientV2 asMemberClient = new DbxTeamRawClientV2(this._client.getRequestConfig(), this._client.getHost(), this.accessToken, this._client.getUserId(), memberId, null, null);
        return new DbxClientV2(asMemberClient);
    }

    public DbxClientV2 asAdmin(String adminId) {
        if (adminId == null) {
            throw new IllegalArgumentException("'adminId' should not be null");
        }
        DbxTeamRawClientV2 asAdminClient = new DbxTeamRawClientV2(this._client.getRequestConfig(), this._client.getHost(), this.accessToken, this._client.getUserId(), null, adminId, null);
        return new DbxClientV2(asAdminClient);
    }

    private static final class DbxTeamRawClientV2
    extends DbxRawClientV2 {
        private final String accessToken;
        private final String memberId;
        private final String adminId;

        private DbxTeamRawClientV2(DbxRequestConfig requestConfig, DbxHost host, String accessToken) {
            this(requestConfig, host, accessToken, null, null, null, null);
        }

        private DbxTeamRawClientV2(DbxRequestConfig requestConfig, DbxHost host, String accessToken, String userId, String memberId, String adminId, PathRoot pathRoot) {
            super(requestConfig, host, userId, pathRoot);
            if (accessToken == null) {
                throw new NullPointerException("accessToken");
            }
            this.accessToken = accessToken;
            this.memberId = memberId;
            this.adminId = adminId;
        }

        @Override
        protected void addAuthHeaders(List<HttpRequestor.Header> headers) {
            DbxRequestUtil.addAuthHeader(headers, this.accessToken);
            if (this.memberId != null) {
                DbxRequestUtil.addSelectUserHeader(headers, this.memberId);
            }
            if (this.adminId != null) {
                DbxRequestUtil.addSelectAdminHeader(headers, this.adminId);
            }
        }

        @Override
        protected DbxRawClientV2 withPathRoot(PathRoot pathRoot) {
            return new DbxTeamRawClientV2(this.getRequestConfig(), this.getHost(), this.accessToken, this.getUserId(), this.memberId, this.adminId, pathRoot);
        }
    }
}

