/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.sharing.SharedFileMembers;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class ListFileMembersCountResult {
    protected final SharedFileMembers members;
    protected final long memberCount;

    public ListFileMembersCountResult(SharedFileMembers members, long memberCount) {
        if (members == null) {
            throw new IllegalArgumentException("Required value for 'members' is null");
        }
        this.members = members;
        this.memberCount = memberCount;
    }

    public SharedFileMembers getMembers() {
        return this.members;
    }

    public long getMemberCount() {
        return this.memberCount;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.members, this.memberCount});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            ListFileMembersCountResult other = (ListFileMembersCountResult)obj;
            return (this.members == other.members || this.members.equals(other.members)) && this.memberCount == other.memberCount;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<ListFileMembersCountResult> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(ListFileMembersCountResult value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("members");
            SharedFileMembers.Serializer.INSTANCE.serialize(value.members, g);
            g.writeFieldName("member_count");
            StoneSerializers.uInt32().serialize((Long)value.memberCount, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public ListFileMembersCountResult deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Long f_memberCount;
            SharedFileMembers f_members;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_members = null;
                f_memberCount = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("members".equals(field)) {
                        f_members = (SharedFileMembers)SharedFileMembers.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("member_count".equals(field)) {
                        f_memberCount = StoneSerializers.uInt32().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_members == null) {
                    throw new JsonParseException(p, "Required field \"members\" missing.");
                }
                if (f_memberCount == null) {
                    throw new JsonParseException(p, "Required field \"member_count\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            ListFileMembersCountResult value = new ListFileMembersCountResult(f_members, f_memberCount);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

