/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

class MembersListArg {
    protected final long limit;
    protected final boolean includeRemoved;

    public MembersListArg(long limit, boolean includeRemoved) {
        if (limit < 1L) {
            throw new IllegalArgumentException("Number 'limit' is smaller than 1L");
        }
        if (limit > 1000L) {
            throw new IllegalArgumentException("Number 'limit' is larger than 1000L");
        }
        this.limit = limit;
        this.includeRemoved = includeRemoved;
    }

    public MembersListArg() {
        this(1000L, false);
    }

    public long getLimit() {
        return this.limit;
    }

    public boolean getIncludeRemoved() {
        return this.includeRemoved;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.limit, this.includeRemoved});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            MembersListArg other = (MembersListArg)obj;
            return this.limit == other.limit && this.includeRemoved == other.includeRemoved;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<MembersListArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(MembersListArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("limit");
            StoneSerializers.uInt32().serialize((Long)value.limit, g);
            g.writeFieldName("include_removed");
            StoneSerializers.boolean_().serialize((Boolean)value.includeRemoved, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public MembersListArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Boolean f_includeRemoved;
            Long f_limit;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_limit = 1000L;
                f_includeRemoved = false;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("limit".equals(field)) {
                        f_limit = StoneSerializers.uInt32().deserialize(p);
                        continue;
                    }
                    if ("include_removed".equals(field)) {
                        f_includeRemoved = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            MembersListArg value = new MembersListArg(f_limit, f_includeRemoved);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected long limit = 1000L;
        protected boolean includeRemoved = false;

        protected Builder() {
        }

        public Builder withLimit(Long limit) {
            if (limit < 1L) {
                throw new IllegalArgumentException("Number 'limit' is smaller than 1L");
            }
            if (limit > 1000L) {
                throw new IllegalArgumentException("Number 'limit' is larger than 1000L");
            }
            this.limit = limit != null ? limit : 1000L;
            return this;
        }

        public Builder withIncludeRemoved(Boolean includeRemoved) {
            this.includeRemoved = includeRemoved != null ? includeRemoved : false;
            return this;
        }

        public MembersListArg build() {
            return new MembersListArg(this.limit, this.includeRemoved);
        }
    }
}

