/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.webui;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.Application;
import org.exoplatform.web.application.ApplicationLifecycle;
import org.exoplatform.web.application.RequestFailure;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIComponentDecorator;

public class CloudDriveLifecycle
implements ApplicationLifecycle<WebuiRequestContext> {
    protected static final Log LOG = ExoLogger.getLogger(CloudDriveLifecycle.class);
    protected final ThreadLocal<Boolean> toolbarRendered = new ThreadLocal();

    public void onInit(Application app) throws Exception {
    }

    public void onStartRequest(Application app, WebuiRequestContext context) throws Exception {
        UIComponent toolbar = this.findToolbarComponent(app, context);
        if (toolbar != null && toolbar.isRendered()) {
            this.toolbarRendered.set(true);
            toolbar.setRendered(false);
        }
    }

    public void onEndRequest(Application app, WebuiRequestContext context) throws Exception {
        Boolean render;
        UIComponent toolbar = this.findToolbarComponent(app, context);
        if (toolbar != null && (render = this.toolbarRendered.get()) != null && render.booleanValue()) {
            toolbar.setRendered(true);
        }
    }

    public void onFailRequest(Application app, WebuiRequestContext context, RequestFailure failureType) {
    }

    public void onDestroy(Application app) throws Exception {
    }

    protected UIComponent findToolbarComponent(Application app, WebuiRequestContext context) throws Exception {
        UIContainer viewContainer;
        UIApplication uiApp;
        UIComponentDecorator uiViewWS;
        ExoContainer container = app.getApplicationServiceContainer();
        if (container != null && (uiViewWS = (UIComponentDecorator)(uiApp = context.getUIApplication()).findComponentById("UIViewWS")) != null && (viewContainer = (UIContainer)uiViewWS.getUIComponent()) != null) {
            UIContainer navContainer = (UIContainer)viewContainer.getChildById("NavigationPortlet");
            if (navContainer == null) {
                navContainer = viewContainer;
            }
            for (UIComponent child : navContainer.getChildren()) {
                UIContainer childContainer;
                UIComponent toolbar;
                if (!UIContainer.class.isAssignableFrom(child.getClass()) || (toolbar = (childContainer = (UIContainer)UIContainer.class.cast(child)).getChildById("UIToolbarContainer")) == null) continue;
                return toolbar;
            }
            return navContainer.findComponentById("UIToolbarContainer");
        }
        return null;
    }
}

