/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.ecms;

import org.exoplatform.clouddrive.CloudDriveService;
import org.exoplatform.clouddrive.CloudProvider;
import org.exoplatform.clouddrive.ProviderNotAvailableException;
import org.exoplatform.clouddrive.ecms.BaseCloudDriveManagerComponent;
import org.exoplatform.clouddrive.ecms.CloudDriveUIMenuAction;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.Parameter;
import org.exoplatform.webui.application.WebuiRequestContext;

public abstract class BaseConnectActionComponent
extends BaseCloudDriveManagerComponent
implements CloudDriveUIMenuAction {
    protected static final Log LOG = ExoLogger.getLogger(BaseConnectActionComponent.class);

    protected abstract String getProviderId();

    public String renderEventURL(boolean ajax, String name, String beanId, Parameter[] params) throws Exception {
        CloudDriveService drivesService = (CloudDriveService)WCMCoreUtils.getService(CloudDriveService.class);
        if (drivesService != null) {
            try {
                CloudProvider provider = drivesService.getProvider(this.getProviderId());
                this.initContext();
                return "javascript:void(0);//" + provider.getId() + "//objectId";
            }
            catch (ProviderNotAvailableException e) {
                LOG.error((Object)("Error rendering Connect to " + this.getProviderId() + " component: " + e.getMessage()));
                return super.renderEventURL(ajax, name, beanId, params);
            }
        }
        LOG.error((Object)"CloudDriveService not registred in the container.");
        return super.renderEventURL(ajax, name, beanId, params);
    }

    @Override
    public String getName() {
        CloudDriveService drivesService;
        String connectYour = WebuiRequestContext.getCurrentInstance().getApplicationResourceBundle().getString("UIPopupWindow.title.ConnectYour");
        if (connectYour == null || connectYour.length() == 0) {
            connectYour = "Connect your";
        }
        if ((drivesService = (CloudDriveService)WCMCoreUtils.getService(CloudDriveService.class)) != null) {
            try {
                CloudProvider provider = drivesService.getProvider(this.getProviderId());
                return connectYour + " " + provider.getName();
            }
            catch (ProviderNotAvailableException e) {
                LOG.error((Object)("Error rendering Connect to " + this.getProviderId() + " component: " + e.getMessage()));
            }
        } else {
            LOG.error((Object)"CloudDriveService not registred in the container.");
        }
        return connectYour + " " + this.getProviderId();
    }
}

