/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.ecms.action;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import org.exoplatform.clouddrive.ecms.action.CloudFileAction;
import org.exoplatform.clouddrive.ecms.action.CloudFileActionException;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.rightclick.manager.PasteManageComponent;
import org.exoplatform.services.cms.clipboard.ClipboardService;
import org.exoplatform.services.cms.clipboard.jcr.model.ClipboardCommand;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.event.Event;

@ComponentConfig(events={@EventConfig(listeners={PasteActionListener.class})})
public class CloudDrivePasteManageComponent
extends PasteManageComponent {
    protected static final Log LOG = ExoLogger.getLogger(CloudDrivePasteManageComponent.class);

    public static class PasteActionListener
    extends PasteManageComponent.PasteActionListener {
        public void processEvent(Event<PasteManageComponent> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((PasteManageComponent)event.getSource()).getAncestorOfType(UIJCRExplorer.class);
            CloudFileAction action = new CloudFileAction(uiExplorer);
            try {
                String destParam = event.getRequestContext().getRequestParameter("objectId");
                if (destParam == null) {
                    action.setDestination(uiExplorer.getCurrentNode());
                } else {
                    action.setDestination(destParam);
                }
                String userId = ConversationState.getCurrent().getIdentity().getUserId();
                ClipboardService clipboardService = (ClipboardService)WCMCoreUtils.getService(ClipboardService.class);
                LinkedList allClipboards = new LinkedList(clipboardService.getClipboardList(userId, false));
                if (allClipboards.size() > 0) {
                    Set virtClipboards = clipboardService.getClipboardList(userId, true);
                    ClipboardCommand current2 = null;
                    if (virtClipboards.isEmpty()) {
                        current2 = (ClipboardCommand)allClipboards.getLast();
                        boolean isCut = "cut".equals(current2.getType());
                        action.addSource(current2.getWorkspace(), current2.getSrcPath());
                        if (isCut) {
                            action.move();
                        }
                        if (action.apply()) {
                            if (isCut) {
                                virtClipboards.clear();
                                allClipboards.remove(current2);
                            }
                            uiExplorer.updateAjax(event);
                            return;
                        }
                    } else {
                        int virtSize = virtClipboards.size();
                        LinkedHashSet<ClipboardCommand> linked = new LinkedHashSet<ClipboardCommand>();
                        Boolean isCut = null;
                        for (ClipboardCommand current2 : virtClipboards) {
                            boolean isThisCut = "cut".equals(current2.getType());
                            if (isCut == null) {
                                isCut = isThisCut;
                            }
                            if (isCut.equals(isThisCut)) {
                                action.addSource(current2.getWorkspace(), current2.getSrcPath());
                                linked.add(current2);
                                continue;
                            }
                            LOG.warn((Object)("Cannot handle different types of clipboard operations for group action. Files " + (isCut != false ? " cut-paste" : " copy-paste") + " already started but " + (isThisCut ? " cut-paste" : " copy-paste") + " found for " + current2.getSrcPath()));
                            break;
                        }
                        if (virtSize == linked.size()) {
                            if (isCut != null && isCut.booleanValue()) {
                                action.move();
                            }
                            if (action.apply()) {
                                if (isCut.booleanValue()) {
                                    virtClipboards.clear();
                                    for (ClipboardCommand c : linked) {
                                        allClipboards.remove(c);
                                    }
                                }
                                uiExplorer.updateAjax(event);
                                return;
                            }
                        } else {
                            action.rollback();
                            LOG.warn((Object)("Links cannot be created for all cloud files. Destination " + action.getDestonationPath() + "." + (current2 != null ? " Last file " + current2.getSrcPath() + "." : "") + " Default behaviour will be applied (files Paste)."));
                        }
                    }
                }
            }
            catch (CloudFileActionException e) {
                LOG.warn((Object)e.getMessage(), (Throwable)e);
                UIApplication uiApp = (UIApplication)uiExplorer.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(e.getUIMessage());
                action.rollback();
                uiExplorer.updateAjax(event);
                return;
            }
            catch (Exception e) {
                LOG.warn((Object)"Error creating link of cloud file. Default behaviour will be applied (file Paste).", (Throwable)e);
            }
            super.processEvent(event);
        }
    }
}

