/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.xcmis.spi.utils.Logger;

public class CaseInsensitiveRangeQuery
extends TermRangeQuery {
    private static final long serialVersionUID = 3351256558561558491L;
    private static final Logger log = Logger.getLogger(CaseInsensitiveRangeQuery.class);
    private static String LOWER_TERM;
    private static String UPPER_TERM;
    private static String FIELD;
    private static boolean IS_LOWER_INCLUSIVE;
    private static boolean IS_UPPER_INCLUSIVE;
    public static final MultiTermQuery.RewriteMethod CASE_IN_SENSITIVE_FILTER_REWRITE;

    public CaseInsensitiveRangeQuery(String field, String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper) {
        super(field, lowerTerm, upperTerm, includeLower, includeUpper, null);
        FIELD = field;
        LOWER_TERM = lowerTerm;
        UPPER_TERM = upperTerm;
        IS_LOWER_INCLUSIVE = includeLower;
        IS_UPPER_INCLUSIVE = includeUpper;
        this.setRewriteMethod(CASE_IN_SENSITIVE_FILTER_REWRITE);
    }

    static {
        CASE_IN_SENSITIVE_FILTER_REWRITE = new MultiTermQuery.RewriteMethod(){
            private static final long serialVersionUID = 1L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Query rewrite(IndexReader reader, MultiTermQuery multiTermQuery) throws IOException {
                BooleanQuery query = new BooleanQuery(true);
                TermEnum enumerator = reader.terms(new Term(FIELD, LOWER_TERM));
                try {
                    Term term;
                    while ((term = enumerator.term()) != null && term.field().equals(FIELD)) {
                        block11: {
                            block12: {
                                String termText = term.text().toLowerCase();
                                int lowerCompareResult = termText.compareTo(LOWER_TERM);
                                if (lowerCompareResult <= 0 && (!IS_LOWER_INCLUSIVE || lowerCompareResult != 0)) break block11;
                                if (UPPER_TERM == null) break block12;
                                if (new Term(FIELD, UPPER_TERM).text().compareTo(term.text()) < 0) {
                                    break;
                                }
                                int upperCompareResult = new Term(FIELD, UPPER_TERM).text().compareTo(termText);
                                if (upperCompareResult < 0 || !IS_UPPER_INCLUSIVE && upperCompareResult == 0) break block11;
                            }
                            TermQuery tq = new TermQuery(term);
                            tq.setBoost(multiTermQuery.getBoost());
                            query.add((Query)tq, BooleanClause.Occur.SHOULD);
                        }
                        if (enumerator.next()) continue;
                        break;
                    }
                }
                finally {
                    enumerator.close();
                }
                if (log.isDebugEnabled()) {
                    log.debug(query.toString());
                }
                return query;
            }
        };
    }
}

