/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.xcmis.sp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import org.exoplatform.ecms.xcmis.sp.BaseObjectData;
import org.exoplatform.ecms.xcmis.sp.JcrNodeEntry;
import org.exoplatform.ecms.xcmis.sp.StorageImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.xcmis.spi.ConstraintException;
import org.xcmis.spi.ContentStream;
import org.xcmis.spi.FolderData;
import org.xcmis.spi.ItemsIterator;
import org.xcmis.spi.LazyIterator;
import org.xcmis.spi.ObjectData;
import org.xcmis.spi.StorageException;

class FolderDataImpl
extends BaseObjectData
implements FolderData {
    private static final Log LOG = ExoLogger.getLogger((String)FolderDataImpl.class.getName());

    public FolderDataImpl(JcrNodeEntry jcrEntry) {
        super(jcrEntry);
    }

    public void addObject(ObjectData object) throws ConstraintException {
        this.entry.addObject(((BaseObjectData)object).getNodeEntry());
    }

    public ItemsIterator<ObjectData> getChildren(String orderBy) {
        return new FolderChildrenIterator(this.entry.getChildren());
    }

    public ContentStream getContentStream(String streamId) {
        return null;
    }

    public FolderData getParent() throws ConstraintException {
        if (this.isRoot()) {
            throw new ConstraintException("Unable get parent of root folder.");
        }
        Collection<FolderData> parents = this.getParents();
        return parents.iterator().next();
    }

    public Collection<FolderData> getParents() {
        if (this.isRoot()) {
            return Collections.emptyList();
        }
        Collection<JcrNodeEntry> parentEntries = this.entry.getParents();
        ArrayList<FolderData> parents = new ArrayList<FolderData>(parentEntries.size());
        for (JcrNodeEntry parentEntry : parentEntries) {
            parents.add(new FolderDataImpl(parentEntry));
        }
        return parents;
    }

    @Override
    public Calendar getCreationDate() {
        Calendar date = super.getCreationDate();
        if (date == null) {
            date = this.entry.getDate("jcr:created");
        }
        return date;
    }

    public String getPath() {
        return this.entry.getPath();
    }

    public boolean hasChildren() {
        return this.entry.hasChildren();
    }

    public boolean isAllowedChildType(String typeId) {
        String[] values = this.entry.getStrings("cmis:allowedChildObjectTypeIds");
        return values == null || values.length <= 0 || Arrays.asList(values).contains(typeId);
    }

    public boolean isRoot() {
        return this.entry.isRoot();
    }

    public void removeObject(ObjectData object) {
        this.entry.removeObject(((BaseObjectData)object).getNodeEntry());
    }

    @Override
    public void delete() throws StorageException {
        if (this.isRoot()) {
            throw new StorageException("Root folder can't be deleted.");
        }
        this.entry.delete();
    }

    private class FolderChildrenIterator
    extends LazyIterator<ObjectData> {
        private final ItemsIterator<JcrNodeEntry> iter;

        FolderChildrenIterator(ItemsIterator<JcrNodeEntry> iter) {
            this.iter = iter;
            this.fetchNext();
        }

        protected void fetchNext() {
            this.next = null;
            if (this.iter.hasNext()) {
                JcrNodeEntry childEntry = (JcrNodeEntry)this.iter.next();
                this.next = ((StorageImpl)FolderDataImpl.this.entry.storage).getObject(childEntry);
            }
        }

        public int size() {
            return this.iter.size();
        }
    }
}

