/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.client.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.abdera.model.Base;
import org.apache.abdera.util.MimeTypeHelper;
import org.apache.commons.httpclient.methods.RequestEntity;

public class BaseRequestEntity
implements RequestEntity {
    private final Base base;
    private byte[] buf = null;
    private boolean use_chunked = true;

    public BaseRequestEntity(Base base) {
        this.base = base;
    }

    public BaseRequestEntity(Base base, boolean use_chunked) {
        this(base);
        this.use_chunked = use_chunked;
    }

    public boolean isRepeatable() {
        return true;
    }

    public void writeRequest(OutputStream out) throws IOException {
        if (this.use_chunked) {
            this.base.writeTo(out);
        } else {
            if (this.buf == null) {
                this.getContentLength();
            }
            out.write(this.buf);
            out.flush();
        }
    }

    public long getContentLength() {
        if (this.use_chunked) {
            return -1L;
        }
        if (this.buf == null) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                this.base.writeTo((OutputStream)out);
                this.buf = out.toByteArray();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.buf.length;
    }

    public String getContentType() {
        return MimeTypeHelper.getMimeType((Base)this.base);
    }
}

