/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.xcmis.search.QueryObjectModelVisitor;
import org.xcmis.search.VisitException;
import org.xcmis.search.Visitors;
import org.xcmis.search.model.Limit;
import org.xcmis.search.model.QueryElement;
import org.xcmis.search.model.column.Column;
import org.xcmis.search.model.constraint.Constraint;
import org.xcmis.search.model.ordering.Ordering;
import org.xcmis.search.model.source.Source;

public class Query
implements QueryElement,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<Column> columns;
    private final Constraint constraint;
    private final Limit limits;
    private final List<Ordering> orderings;
    private final Source source;
    private final int hcode;

    public Query(Source source) {
        this(source, null, Collections.emptyList(), Collections.emptyList(), Limit.NONE);
    }

    public Query(Source source, Constraint constraint, List<Ordering> orderings, List<Column> columns, Limit limit) {
        Validate.notNull((Object)source, (String)"The source argument may not be null");
        this.source = source;
        this.constraint = constraint;
        this.orderings = orderings != null ? orderings : Collections.emptyList();
        this.limits = limit != null ? limit : Limit.NONE;
        this.columns = columns != null ? columns : Collections.emptyList();
        this.hcode = new HashCodeBuilder().append((Object)this.source).append((Object)this.constraint).append(this.columns).append((Object)this.limits).append(this.orderings).toHashCode();
    }

    @Override
    public void accept(QueryObjectModelVisitor visitor) throws VisitException {
        visitor.visit(this);
    }

    public Query adding(Column ... columns) {
        List<Column> newColumns = null;
        if (this.columns != null) {
            newColumns = new ArrayList<Column>(this.columns);
            for (Column column : columns) {
                newColumns.add(column);
            }
        } else {
            newColumns = Arrays.asList(columns);
        }
        return new Query(this.source, this.constraint, this.getOrderings(), newColumns, this.getLimits());
    }

    public Query adding(Ordering ... orderings) {
        List<Ordering> newOrderings = null;
        if (this.getOrderings() != null) {
            newOrderings = new ArrayList<Ordering>(this.getOrderings());
            for (Ordering ordering : orderings) {
                newOrderings.add(ordering);
            }
        } else {
            newOrderings = Arrays.asList(orderings);
        }
        return new Query(this.source, this.constraint, newOrderings, this.columns, this.getLimits());
    }

    public Query constrainedBy(Constraint constraint) {
        return new Query(this.source, constraint, this.getOrderings(), this.columns, this.getLimits());
    }

    public Query distinct() {
        return new Query(this.source, this.constraint, this.getOrderings(), this.columns, this.getLimits());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Query rhs = (Query)obj;
        return new EqualsBuilder().append((Object)this.source, (Object)rhs.source).append((Object)this.constraint, (Object)rhs.constraint).append(this.columns, rhs.columns).append((Object)this.limits, (Object)rhs.limits).isEquals();
    }

    public final List<Column> getColumns() {
        return this.columns;
    }

    public final Constraint getConstraint() {
        return this.constraint;
    }

    public final Limit getLimits() {
        return this.limits;
    }

    public final List<Ordering> getOrderings() {
        return this.orderings;
    }

    public final Source getSource() {
        return this.source;
    }

    public Query orderedBy(List<Ordering> orderings) {
        return new Query(this.source, this.constraint, orderings, this.columns, this.getLimits());
    }

    public Query returning(List<Column> columns) {
        return new Query(this.source, this.constraint, this.getOrderings(), columns, this.getLimits());
    }

    public Query withLimit(int rowLimit) {
        return new Query(this.source, this.constraint, this.getOrderings(), this.columns, this.getLimits().withRowLimit(rowLimit));
    }

    public Query withOffset(int offset) {
        return new Query(this.source, this.constraint, this.getOrderings(), this.columns, this.getLimits().withOffset(offset));
    }

    public String toString() {
        return Visitors.readable(this);
    }

    public int hashCode() {
        return this.hcode;
    }
}

