/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.model.column;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.xcmis.search.QueryObjectModelVisitor;
import org.xcmis.search.VisitException;
import org.xcmis.search.Visitors;
import org.xcmis.search.model.QueryElement;
import org.xcmis.search.model.source.SelectorName;

public class Column
implements QueryElement {
    private static final long serialVersionUID = 7650452286649408047L;
    private final String columnName;
    private final String propertyName;
    private final SelectorName selectorName;
    private final int hcode;
    private final ColumnFunction columnFunction;

    public Column(SelectorName selectorName) {
        this(selectorName, "*", "*");
    }

    public Column(SelectorName selectorName, String propertyName, String columnName) {
        Validate.notNull((Object)selectorName, (String)"The selectorName argument may not be null");
        Validate.notNull((Object)propertyName, (String)"The propertyName argument may not be null");
        Validate.notNull((Object)columnName, (String)"The columnName argument may not be null");
        this.selectorName = selectorName;
        this.propertyName = propertyName;
        this.columnName = columnName;
        this.columnFunction = null;
        this.hcode = new HashCodeBuilder().append((Object)selectorName).append((Object)propertyName).append((Object)columnName).toHashCode();
    }

    public Column(ColumnFunction columnFunction, String columnName) {
        Validate.notNull((Object)columnFunction, (String)"The selectorName argument may not be null");
        Validate.notNull((Object)columnName, (String)"The propertyName argument may not be null");
        this.columnFunction = columnFunction;
        this.columnName = columnName;
        this.selectorName = null;
        this.propertyName = null;
        this.hcode = new HashCodeBuilder().append((Object)columnFunction).append((Object)columnName).toHashCode();
    }

    @Override
    public void accept(QueryObjectModelVisitor visitor) throws VisitException {
        visitor.visit(this);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Column rhs = (Column)obj;
        return new EqualsBuilder().append((Object)this.selectorName, (Object)rhs.selectorName).append((Object)this.propertyName, (Object)rhs.propertyName).append((Object)this.columnName, (Object)rhs.columnName).isEquals();
    }

    public final String getColumnName() {
        return this.columnName;
    }

    public final String getPropertyName() {
        return this.propertyName;
    }

    public final boolean isFunction() {
        return this.columnFunction != null;
    }

    public ColumnFunction getColumnFunction() {
        return this.columnFunction;
    }

    public final SelectorName getSelectorName() {
        return this.selectorName;
    }

    public String toString() {
        return Visitors.readable(this);
    }

    public int hashCode() {
        return this.hcode;
    }

    public Column with(SelectorName newSelectorName) {
        return new Column(newSelectorName, this.propertyName, this.columnName);
    }

    public static class ScoreFunction
    implements ColumnFunction {
        public String toString() {
            return "SCORE()";
        }
    }

    public static interface ColumnFunction {
    }
}

