# Contact Us Addon

This addon provide a REST service to send email from the platform

## How to install
Launch this commands :
```
cd ${EXO_HOME}
./addon install exo-contact-us
```

## How to configure

Availables properties are :

- org.exoplatform.addons.contactus.recipient : The recipient of the email. This can be only change on server side to prevent sending Spam


## How to use :
The service is accessible on url /portal/rest/contactus/send, with a POST requests. 3 properties are required in the body of the request :
- subject : The subject of the email
- body : The message of the email
- portal:csrf : the csrf token of the user. This is required to prevent CSRF attacks. You can get the token by using the js property exo.env.portal.csrfToken

The csrfToken implies that the request is done in a web context, on a page of the platform. It cannot be used with a curl command or a Postman command as csrf token will not exists in this case. This is a security feature to prevent spam sendind.



## Example with IDE portlet :
By using the IDE portlet, you can use the following code to send an email :
- Html : 
```html
<button id="contactus">Send</button>
``` 
- Javascript : 
```javascript
document.getElementById("contactus").addEventListener("click", (event) => {
  fetch("/portal/rest/contactus/send", {
   "body": "body=Message&subject=Message Subject&portal:csrf="+eXo.env.portal.csrfToken,
    "method": "POST", 
    "headers": {
      "Content-Type": "application/x-www-form-urlencoded",
    },
    "credentials": "include"
  });
});
``` 

This create a button which send an email when clicked. The email will be sent to the recipient defined in the properties. The subject and body of the email are defined in the javascript code. The csrf token is automatically added to the request.
