/*
 * Copyright (C) 2003-2016 eXo Platform SAS.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package org.exoplatform.cs.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

import lombok.Data;

import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.cs.dto.InfoType;
import org.exoplatform.cs.dto.IssueSeverity;
import org.exoplatform.cs.dto.IssueType;

/**
 * Created by The eXo Platform SAS
 * 
 * @author boubaker.khanfir@exoplatform.com
 * @since Apr 27, 2016
 */
@Entity(name = "CSTopicEntity")
@ExoEntity
@Table(name = "CS_ADDON_TOPICS")
@NamedQueries({ @NamedQuery(name = "topicEntity.getTopicsBySpace", query = "SELECT a FROM CSTopicEntity a where a.space.id = :spaceGroupID") })
@Data
public class TopicEntity {

  @Id
  @Column(name = "TOPIC_ID")
  private String            id;

  @Column(name = "TYPE")
  private IssueType         type;

  @Column(name = "SEVERITY")
  private IssueSeverity     severity;

  @Column(name = "INFO_TYPE")
  private InfoType          infoType;

  @Column(name = "LINK")
  private String            link;

  @Column(name = "TOPIC_ASSIGNEE")
  private String assignee;

  @ManyToOne
  @JoinColumn(name = "SPACE_ID")
  private SpaceEntity       space;

  @ManyToOne
  @JoinColumn(name = "ENVIRONMENT_ID")
  private EnvironmentEntity environment;
}
