/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.cs.dao.EnvironmentDAO;
import org.exoplatform.cs.dao.SpaceDAO;
import org.exoplatform.cs.dao.TopicDAO;
import org.exoplatform.cs.dao.TypeDAO;
import org.exoplatform.cs.dto.EnvironmentDTO;
import org.exoplatform.cs.dto.TypeDTO;
import org.exoplatform.cs.entity.EnvironmentEntity;
import org.exoplatform.cs.entity.SpaceEntity;
import org.exoplatform.cs.entity.TypeEntity;
import org.exoplatform.cs.service.BaseService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentService
extends BaseService {
    private static final Logger LOG = LoggerFactory.getLogger(EnvironmentService.class);

    public EnvironmentService(EnvironmentDAO environmentDAO, SpaceDAO spaceDAO, TopicDAO topicDAO, TypeDAO typeDAO) {
        super(environmentDAO, spaceDAO, topicDAO, typeDAO);
    }

    public EnvironmentDTO saveEnvironment(EnvironmentDTO environmentDTO) throws Exception {
        if (environmentDTO == null) {
            throw new IllegalStateException("Method save - Parameter 'environmentDTO' is null");
        }
        if (!environmentDTO.verifySaveConditions()) {
            throw new IllegalStateException("Method save - Parameter 'environmentDTO' is not coherent " + environmentDTO);
        }
        SpaceEntity spaceEntity = (SpaceEntity)this.spaceDAO.find((Serializable)((Object)environmentDTO.getSpaceGroupId()));
        if (spaceEntity == null) {
            throw new IllegalStateException("Method save - Parameter 'environmentDTO.spaceGroupId' = '" + environmentDTO.getSpaceGroupId() + "' was not found in DB");
        }
        EnvironmentEntity environmentEntity = null;
        environmentEntity = environmentDTO.getId() == null ? (EnvironmentEntity)this.environmentDAO.create(this.convert(environmentDTO, spaceEntity, false)) : (EnvironmentEntity)this.environmentDAO.update(this.convert(environmentDTO, spaceEntity, false));
        if (environmentEntity.isDefaultEnvironment()) {
            String groupId = environmentDTO.getSpaceGroupId();
            List<EnvironmentEntity> environmentEntities = this.environmentDAO.getEnvironmentsBySpace(groupId);
            for (EnvironmentEntity otherEnvironmentEntity : environmentEntities) {
                if (otherEnvironmentEntity.getId() == environmentEntity.getId() || !otherEnvironmentEntity.isDefaultEnvironment()) continue;
                otherEnvironmentEntity.setDefaultEnvironment(false);
                if (otherEnvironmentEntity.getId() == environmentEntity.getId()) continue;
                this.environmentDAO.update(otherEnvironmentEntity);
            }
        }
        return this.convert(environmentEntity);
    }

    public void remove(EnvironmentDTO entity) {
        if (entity == null || entity.getId() == null) {
            throw new IllegalStateException("Parameter 'entity' = + " + entity + " or 'entity.id' is null");
        }
        entity.setSpaceGroupId(null);
        this.environmentDAO.delete(this.convert(entity, null, true));
    }

    public List<EnvironmentDTO> getSpaceEnvironments(String spaceGroupId) {
        ArrayList<EnvironmentDTO> dtos = new ArrayList<EnvironmentDTO>();
        List<EnvironmentEntity> environments = this.environmentDAO.getEnvironmentsBySpace(spaceGroupId);
        if (environments != null) {
            for (EnvironmentEntity environmentEntity : environments) {
                dtos.add(this.convert(environmentEntity));
            }
        }
        return dtos;
    }

    public List<TypeDTO> getTypeObjects(String type) {
        Class<? extends TypeEntity> typeEntity = TypeDTO.getTypeFromString(type);
        List<? extends TypeEntity> entities = this.typeDAO.getTypeObjects(typeEntity);
        ArrayList<TypeDTO> typeDTOs = new ArrayList<TypeDTO>();
        for (TypeEntity typeEntity2 : entities) {
            try {
                typeDTOs.add(TypeDTO.getDTOFromEntity(typeEntity2));
            }
            catch (Exception e) {
                LOG.error("Error occured while getting types : " + type, (Throwable)e);
            }
        }
        return typeDTOs;
    }

    public TypeDTO getTypeObject(String name, String type) {
        TypeEntity typeEntity;
        Class<? extends TypeEntity> typeEntityClass = TypeDTO.getTypeFromString(type);
        if (typeEntityClass.isInstance(typeEntity = this.typeDAO.getTypeByName(name))) {
            return TypeDTO.getDTOFromEntity(typeEntity);
        }
        return null;
    }

    public TypeDTO saveType(TypeDTO typeDTO) throws Exception {
        TypeEntity typeEntity = TypeDTO.getEntityFromDTO(typeDTO);
        if (typeDTO.getId() < 1L) {
            typeEntity.setId(null);
            typeEntity = (TypeEntity)this.typeDAO.create(typeEntity);
        } else {
            this.typeDAO.update(typeEntity);
        }
        return TypeDTO.getDTOFromEntity(typeEntity);
    }

    public void removeType(TypeDTO typeDTO) throws Exception {
        TypeEntity typeEntity = TypeDTO.getEntityFromDTO(typeDTO);
        if (typeDTO.getId() > 0L) {
            this.typeDAO.delete(typeEntity);
        }
    }
}

