/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.injector;

import java.util.HashSet;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.RuntimeDelegate;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.cs.dto.BasicEntityDTO;
import org.exoplatform.cs.dto.EnvironmentDTO;
import org.exoplatform.cs.dto.IssueSeverity;
import org.exoplatform.cs.dto.IssueType;
import org.exoplatform.cs.dto.SpaceDTO;
import org.exoplatform.cs.dto.TicketDTO;
import org.exoplatform.cs.service.CSSpaceService;
import org.exoplatform.cs.service.EnvironmentService;
import org.exoplatform.cs.service.TicketService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.impl.UserImpl;
import org.exoplatform.services.rest.impl.RuntimeDelegateImpl;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.task.domain.Priority;

@Path(value="csinjector")
public class CSInjector
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(CSInjector.class);
    private static final CacheControl cc;
    private CSSpaceService spaceService;
    private TicketService ticketService;
    private EnvironmentService environmentService;
    private OrganizationService organizationService;

    public CSInjector(CSSpaceService spaceService, TicketService ticketService, EnvironmentService environmentService, OrganizationService organizationService) {
        this.spaceService = spaceService;
        this.ticketService = ticketService;
        this.environmentService = environmentService;
        this.organizationService = organizationService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @RolesAllowed(value={"administrators"})
    @Path(value="createspaces/spaces")
    @Produces(value={"text/plain"})
    public Response getUpdates(@Context UriInfo uriInfo, @QueryParam(value="prefix") String spacePrefix, @QueryParam(value="spacecount") String spaceCount, @QueryParam(value="ticketperspace") String ticketPerSpace) {
        int ticketsPerSpace;
        int spacesCount;
        UserImpl customerUser = new UserImpl();
        BasicEntityDTO customer = new BasicEntityDTO("bugs", "bugs");
        BasicEntityDTO support = new BasicEntityDTO("support", "support");
        BasicEntityDTO spaceMembersgroup = new BasicEntityDTO("support-team", "support-team");
        BasicEntityDTO spaceManagersGroup = new BasicEntityDTO("gss", "gss");
        try {
            spacesCount = Integer.parseInt(spaceCount);
        }
        catch (NumberFormatException nfe) {
            spacesCount = 10;
            LOG.info((Object)"We will create 10 customer spaces ");
        }
        try {
            ticketsPerSpace = Integer.parseInt(spaceCount);
        }
        catch (NumberFormatException nfe) {
            ticketsPerSpace = 10;
            LOG.info((Object)"We will create 10 tickets per space ");
        }
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        try {
            customerUser = this.organizationService.getUserHandler().findUserByName(customer.computeId());
        }
        catch (Exception e) {
            LOG.error("User {} not found", new Object[]{customer.computeId(), e});
            Response response = Response.serverError().cacheControl(cc).build();
            return response;
        }
        finally {
            RequestLifeCycle.end();
        }
        int i = 0;
        while (i < spacesCount) {
            try {
                String spaceName = spacePrefix + i;
                SpaceDTO space = new SpaceDTO();
                space.setDescription("Description for space" + spaceName);
                space.setInvitedMembersGroupId(spaceMembersgroup);
                space.setLimitTicketsNumber(1000L);
                space.setManagersGroupId(spaceManagersGroup);
                HashSet<BasicEntityDTO> members = new HashSet<BasicEntityDTO>();
                members.add(customer);
                space.setMembers(members);
                space.setName(spaceName);
                space.setOwner(support.computeId());
                space.setTagPrefix(spacePrefix + i);
                space.setTaskDefaultAssignee(support);
                space.setTaskPriority(Priority.NONE);
                RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
                try {
                    space = this.spaceService.saveSpace(space);
                }
                catch (Exception e) {
                    LOG.error("Error creating space {}", new Object[]{space.getName(), e});
                    Response response = Response.serverError().cacheControl(cc).build();
                    return response;
                }
                finally {
                    RequestLifeCycle.end();
                }
                LOG.info("Space {} created!", new Object[]{space.getName()});
                EnvironmentDTO environment = new EnvironmentDTO();
                environment.setName("PROD");
                environment.setTypeOtherName("Production");
                environment.setProductVersion("5.0.0");
                environment.setDefaultEnvironment(true);
                environment.setSpaceGroupId(space.getGroupId());
                environment = this.environmentService.saveEnvironment(environment);
                LOG.info("Environment {} created for space {} !", new Object[]{environment.getName(), space.getName()});
                for (int counter = 0; counter < ticketsPerSpace; ++counter) {
                    TicketDTO ticket = new TicketDTO();
                    ticket.setAssignee(support.computeId());
                    ticket.setDescription("Description for ticket " + counter + "in space " + space.getName());
                    ticket.setEnvironmentId(environment.getId());
                    ticket.setEnvironmentName(environment.getName());
                    ticket.setSeverity(IssueSeverity.SEVERITY_2);
                    ticket.setTitle("Title of ticket " + counter + "in space " + space.getName());
                    ticket.setSpaceGroupId(space.getGroupId());
                    ticket.setStatus("Open");
                    ticket.setType(IssueType.INCIDENT);
                    this.ticketService.createTicket(ticket, (User)customerUser);
                    LOG.info("Ticket {} created in space {}!", new Object[]{ticket.getTitle(), space.getName()});
                }
            }
            catch (Exception e) {
                LOG.error("Could not create space {}", new Object[]{spacePrefix + i, e});
                return Response.serverError().cacheControl(cc).build();
            }
            ++i;
        }
        return Response.ok((Object)("Created " + spacesCount + " spaces with " + ticketPerSpace + " tickets in each."), (String)"text/plain").cacheControl(cc).build();
    }

    static {
        RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
        cc = new CacheControl();
        cc.setNoCache(true);
        cc.setNoStore(true);
    }
}

