/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.service.listener;

import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.forum.ext.impl.ForumDataInitialize;
import org.exoplatform.forum.service.DataStorage;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;

public class CSForumDataInitializer
extends ForumDataInitialize {
    private static final Log LOG = ExoLogger.getLogger(CSForumDataInitializer.class);
    private String portletName;

    public CSForumDataInitializer(InitParams params) {
        super(params);
        this.portletName = params.getValueParam("portletName").getValue();
        if (StringUtils.isBlank((CharSequence)this.portletName)) {
            LOG.error((Object)"Portlet name is Blank. Attention, this listener will not be triggered.");
        }
    }

    public void applicationAdded(SpaceLifeCycleEvent event) {
        DataStorage storage = (DataStorage)CommonsUtils.getService(DataStorage.class);
        Space space = event.getSpace();
        if (StringUtils.isBlank((CharSequence)this.portletName) || !this.portletName.equals(event.getSource()) || space == null) {
            return;
        }
        try {
            String categorySpId = Utils.CATEGORY + "/spaces".replaceAll("/", "");
            String forumId = Utils.FORUM_SPACE_ID_PREFIX + space.getPrettyName();
            super.applicationAdded(event);
            Forum forum = storage.getForum(categorySpId, forumId);
            this.fixCreatedDate(forum, storage.getWorkspace());
            storage.saveForum(categorySpId, forum, false);
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to initialize CS Space forum. ", (Throwable)e);
        }
    }

    private void fixCreatedDate(Forum forum, String workspace) throws Exception {
        RepositoryService repoSrv = (RepositoryService)PortalContainer.getInstance().getComponentInstanceOfType(RepositoryService.class);
        Session systemSession = repoSrv.getCurrentRepository().getSystemSession(workspace);
        Node forumNode = (Node)systemSession.getItem(forum.getPath());
        Calendar createdDate = forumNode.getProperty("exo:createdDate").getDate();
        forum.setCreatedDate(createdDate.getTime());
    }
}

