/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.dao;

import java.util.Calendar;
import java.util.List;
import javax.persistence.TemporalType;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.cs.dto.IssueType;
import org.exoplatform.cs.entity.SpaceEntity;
import org.exoplatform.cs.entity.TopicEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicDAO
extends GenericDAOJPAImpl<TopicEntity, String> {
    private static final Logger LOG = LoggerFactory.getLogger(TopicDAO.class);

    public List<TopicEntity> getTopicsBySpace(String spaceGroupId) {
        try {
            return this.getEntityManager().createNamedQuery("topicEntity.getTopicsBySpace", TopicEntity.class).setParameter("spaceGroupID", (Object)spaceGroupId).getResultList();
        }
        catch (Exception e) {
            LOG.error("Exception while attempting to get topics of space '" + spaceGroupId + "'.", (Throwable)e);
            throw e;
        }
    }

    public List<TopicEntity> getTopicsByAssignee(String assignee, boolean allTickets) {
        try {
            if (allTickets) {
                return this.getEntityManager().createNamedQuery("topicEntity.getTopicsByAssignee", TopicEntity.class).setParameter("assignee", (Object)assignee).getResultList();
            }
            return this.getEntityManager().createNamedQuery("topicEntity.getOpenTopicsByAssignee", TopicEntity.class).setParameter("assignee", (Object)assignee).setParameter("status", (Object)"closed").getResultList();
        }
        catch (Exception e) {
            LOG.error("Exception while attempting to get topics by assignee '" + assignee + "'.", (Throwable)e);
            throw e;
        }
    }

    public List<TopicEntity> getOpenTickets() {
        return this.getEntityManager().createNamedQuery("topicEntity.getOpenTopics", TopicEntity.class).setParameter("status", (Object)"closed").getResultList();
    }

    public List<TopicEntity> findUpdatedBetween(Calendar fromDate, Calendar toDate) {
        return this.getEntityManager().createNamedQuery("topicEntity.findUpdatedTopics", TopicEntity.class).setParameter("from", fromDate, TemporalType.TIMESTAMP).setParameter("to", toDate, TemporalType.TIMESTAMP).getResultList();
    }

    public Long countTickets(SpaceEntity space, IssueType type) {
        return (Long)this.getEntityManager().createNamedQuery("topicEntity.countTickets", Long.class).setParameter("type", (Object)type).setParameter("space", (Object)space).getSingleResult();
    }

    public List<TopicEntity> getEmptyTitleOrCreationDate() {
        return this.getEntityManager().createNamedQuery("topicEntity.findEmptyTitleAndCreationDateTopics", TopicEntity.class).setMaxResults(50).getResultList();
    }
}

