/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.entity;

import java.util.Calendar;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.cs.dto.LogType;
import org.exoplatform.cs.entity.TopicEntity;

@Entity(name="CSLogEntity")
@ExoEntity
@Table(name="CS_ADDON_LOG")
@NamedQueries(value={@NamedQuery(name="logEntity.getLogsByTicket", query="SELECT a FROM CSLogEntity a where a.topic.space.id = :spaceGroupID and a.topic = :topic")})
public class LogEntity {
    @Id
    @SequenceGenerator(name="SEQ_CS_LOG_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_CS_LOG_ID")
    @Column(name="LOG_ID")
    private String id;
    @Column(name="TYPE")
    private LogType type;
    @Column(name="USER")
    private String userID;
    @Column(name="DATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Calendar when;
    @Column(name="ORIGINAL_VALUE")
    private String originalValue;
    @Column(name="NEW_VALUE")
    private String newValue;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="TICKET_ID")
    private TopicEntity topic;

    public LogEntity() {
    }

    public LogEntity(LogType type, String userID, Calendar when, String originalValue, String newValue, TopicEntity topic) {
        this.type = type;
        this.userID = userID;
        this.when = when;
        this.originalValue = originalValue;
        this.newValue = newValue;
        this.topic = topic;
    }

    public String getId() {
        return this.id;
    }

    public LogType getType() {
        return this.type;
    }

    public String getUserID() {
        return this.userID;
    }

    public Calendar getWhen() {
        return this.when;
    }

    public String getOriginalValue() {
        return this.originalValue;
    }

    public String getNewValue() {
        return this.newValue;
    }

    public TopicEntity getTopic() {
        return this.topic;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setType(LogType type) {
        this.type = type;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public void setWhen(Calendar when) {
        this.when = when;
    }

    public void setOriginalValue(String originalValue) {
        this.originalValue = originalValue;
    }

    public void setNewValue(String newValue) {
        this.newValue = newValue;
    }

    public void setTopic(TopicEntity topic) {
        this.topic = topic;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogEntity)) {
            return false;
        }
        LogEntity other = (LogEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        LogType this$type = this.getType();
        LogType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$userID = this.getUserID();
        String other$userID = other.getUserID();
        if (this$userID == null ? other$userID != null : !this$userID.equals(other$userID)) {
            return false;
        }
        Calendar this$when = this.getWhen();
        Calendar other$when = other.getWhen();
        if (this$when == null ? other$when != null : !((Object)this$when).equals(other$when)) {
            return false;
        }
        String this$originalValue = this.getOriginalValue();
        String other$originalValue = other.getOriginalValue();
        if (this$originalValue == null ? other$originalValue != null : !this$originalValue.equals(other$originalValue)) {
            return false;
        }
        String this$newValue = this.getNewValue();
        String other$newValue = other.getNewValue();
        if (this$newValue == null ? other$newValue != null : !this$newValue.equals(other$newValue)) {
            return false;
        }
        TopicEntity this$topic = this.getTopic();
        TopicEntity other$topic = other.getTopic();
        return !(this$topic == null ? other$topic != null : !((Object)this$topic).equals(other$topic));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LogEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        LogType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $userID = this.getUserID();
        result = result * 59 + ($userID == null ? 43 : $userID.hashCode());
        Calendar $when = this.getWhen();
        result = result * 59 + ($when == null ? 43 : ((Object)$when).hashCode());
        String $originalValue = this.getOriginalValue();
        result = result * 59 + ($originalValue == null ? 43 : $originalValue.hashCode());
        String $newValue = this.getNewValue();
        result = result * 59 + ($newValue == null ? 43 : $newValue.hashCode());
        TopicEntity $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : ((Object)$topic).hashCode());
        return result;
    }

    public String toString() {
        return "LogEntity(id=" + this.getId() + ", type=" + (Object)((Object)this.getType()) + ", userID=" + this.getUserID() + ", when=" + this.getWhen() + ", originalValue=" + this.getOriginalValue() + ", newValue=" + this.getNewValue() + ", topic=" + this.getTopic() + ")";
    }
}

