/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.listener;

import java.io.Serializable;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.cs.dao.LogDAO;
import org.exoplatform.cs.dao.TopicDAO;
import org.exoplatform.cs.dto.IssueType;
import org.exoplatform.cs.dto.LogType;
import org.exoplatform.cs.entity.LogEntity;
import org.exoplatform.cs.entity.TopicEntity;
import org.exoplatform.cs.integration.notification.CSPrivatePostPlugin;
import org.exoplatform.cs.service.util.CSUtils;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.DataStorage;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumEventListener;
import org.exoplatform.forum.service.MessageBuilder;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;

public class ForumListener
extends ForumEventListener {
    private static final Log LOG = ExoLogger.getLogger(ForumListener.class);
    private static final String SUPPORT_GROUP_NAME_CONFIGURATION = "support.group.name";
    private static final String ALL_EMPLOYEE_GROUP_NAME_CONFIGURATION = "all.employee.group.name";
    private TopicDAO topicDAO;
    private LogDAO logDAO;
    private DataStorage dataStorage;
    private String support_group_name;
    private String all_employees_group_name;
    private String customerGroupName;

    public ForumListener(InitParams initParams, TopicDAO topicDAO, DataStorage dataStorage, LogDAO logDAO) {
        this.topicDAO = topicDAO;
        this.logDAO = logDAO;
        this.dataStorage = dataStorage;
        if (initParams.getValueParam(SUPPORT_GROUP_NAME_CONFIGURATION) != null) {
            this.support_group_name = initParams.getValueParam(SUPPORT_GROUP_NAME_CONFIGURATION).getValue();
        }
        if (initParams.getValueParam(ALL_EMPLOYEE_GROUP_NAME_CONFIGURATION) != null) {
            this.all_employees_group_name = initParams.getValueParam(ALL_EMPLOYEE_GROUP_NAME_CONFIGURATION).getValue();
        }
        this.customerGroupName = System.getProperty("exo.cs.customers.group");
        if (StringUtils.isBlank((CharSequence)this.customerGroupName)) {
            this.customerGroupName = "customers";
        }
    }

    public void addTopic(Topic topic) {
    }

    public void updateTopic(Topic topic) {
        TopicEntity ticket;
        if (topic.getIsClosed() && (ticket = (TopicEntity)this.topicDAO.find((Serializable)((Object)topic.getId()))) != null) {
            ticket.setStatus("closed");
            this.topicDAO.update(ticket);
        }
    }

    public void updateTopics(List<Topic> topics, boolean isLock) {
    }

    public void moveTopic(Topic topic, String toCategoryName, String toForumName) {
    }

    public void movePost(List<Post> posts, List<String> srcPostActivityIds, String desTopicPath) {
    }

    public void mergeTopic(Topic newTopic, String removeActivityId1, String removeActivityId2) {
    }

    public void splitTopic(Topic newTopic, Topic splitedTopic, String removeActivityId) {
    }

    public void addPost(Post post) {
        String topicID = post.getTopicId();
        TopicEntity topicEntity = (TopicEntity)this.topicDAO.find((Serializable)((Object)topicID));
        if (topicEntity != null && !IssueType.PRODUCT.equals((Object)topicEntity.getType())) {
            topicEntity.setUpdateDate(Calendar.getInstance());
            this.topicDAO.update(topicEntity);
            LogType type = LogType.TICKET_COMMENTED_BY_SUPPORT;
            if (CSUtils.isMemberof(post.getOwner(), this.customerGroupName)) {
                type = LogType.TICKET_COMMENTED_BY_CUSTOMER;
            }
            LogEntity messagePostedLog = new LogEntity(type, post.getOwner(), Calendar.getInstance(), null, null, (TopicEntity)this.topicDAO.find((Serializable)((Object)post.getTopicId())), null, null);
            this.logDAO.create(messagePostedLog);
        }
    }

    public void addPrivatePost(Post post) {
        try {
            TopicEntity topic = (TopicEntity)this.topicDAO.find((Serializable)((Object)post.getTopicId()));
            if (topic != null && !IssueType.PRODUCT.equals((Object)topic.getType())) {
                List<User> supportMembers = CSUtils.getGroupMembers(this.all_employees_group_name);
                String[] userPrivate = (String[])supportMembers.stream().map(User::getUserName).toArray(String[]::new);
                post.setUserPrivate(userPrivate);
                post.setMessage("<div class=\"alert alert-warning\" id=\"\">" + post.getMessage() + "</div>");
                this.dataStorage.savePost(post.getCategoryId(), post.getForumId(), post.getTopicId(), post, false, new MessageBuilder());
                topic.setUpdateDate(Calendar.getInstance());
                this.topicDAO.update(topic);
                NotificationContext ctx = NotificationContextImpl.cloneInstance().append(CSPrivatePostPlugin.TICKET, (Object)topic).append(CSPrivatePostPlugin.POST, (Object)post.getMessage()).append(CSPrivatePostPlugin.POSTER, (Object)post.getOwner());
                ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"CSPrivatePostPlugin"))).execute(ctx);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updatePrivatePost(Post post) {
    }

    public void updatePost(Post post) {
    }

    public void updatePost(Post post, int type) {
    }

    public void removeActivity(String activityId) {
    }

    public void removeComment(String activityId, String commentId) {
    }

    public void saveCategory(Category category) {
    }

    public void saveForum(Forum forum) {
    }
}

