/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.cs.dto.InfoType;
import org.exoplatform.cs.dto.IssueSeverity;
import org.exoplatform.cs.dto.IssueType;
import org.exoplatform.cs.dto.Owner;

@JsonIgnoreProperties(value={"simpleDateFormat"})
public class TicketDTO {
    @JsonIgnore
    public SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
    private String id;
    private String title;
    private String status;
    private String description;
    private String link;
    private String assignee;
    private String tagName;
    private IssueType type;
    private IssueSeverity severity;
    private InfoType infoType;
    private String spaceGroupId;
    private String environmentName;
    private Long environmentId;
    private Calendar startDate;
    private Calendar endDate;
    private Calendar updateDate;
    private transient String dateFormat;
    private List<FileItem> files;
    private String flow;
    private String ticketId;
    private String creator;
    private String creatorId;
    private String creatorAvatar;
    private Owner owner;
    private String attachedJira;
    private Calendar firstWarningDate;
    private Calendar lastWarningDate;
    private String warning;
    private String jiraStatus;
    private String jiraStatusIcon;
    private Long timeToFirstResponse;
    private Long timeToResolution;
    private Boolean customerSatisfied;
    private Boolean internal;
    private Boolean active;

    public boolean verifySaveConditions() {
        return !StringUtils.isEmpty((String)this.title) && !StringUtils.isEmpty((String)this.description) && this.type != null && this.spaceGroupId != null && (!IssueType.INCIDENT.equals((Object)this.type) || this.environmentId != null && this.severity != null) && (!IssueType.INFORMATION.equals((Object)this.type) || this.infoType != null);
    }

    private Date retrieveFormattedDate(String dateValue) throws ParseException {
        if (StringUtils.isEmpty((String)dateValue) || StringUtils.isEmpty((String)this.dateFormat)) {
            return null;
        }
        this.simpleDateFormat.applyPattern(this.dateFormat);
        return this.simpleDateFormat.parse(dateValue);
    }

    public SimpleDateFormat getSimpleDateFormat() {
        return this.simpleDateFormat;
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getStatus() {
        return this.status;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLink() {
        return this.link;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public String getTagName() {
        return this.tagName;
    }

    public IssueType getType() {
        return this.type;
    }

    public IssueSeverity getSeverity() {
        return this.severity;
    }

    public InfoType getInfoType() {
        return this.infoType;
    }

    public String getSpaceGroupId() {
        return this.spaceGroupId;
    }

    public String getEnvironmentName() {
        return this.environmentName;
    }

    public Long getEnvironmentId() {
        return this.environmentId;
    }

    public Calendar getStartDate() {
        return this.startDate;
    }

    public Calendar getEndDate() {
        return this.endDate;
    }

    public Calendar getUpdateDate() {
        return this.updateDate;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public List<FileItem> getFiles() {
        return this.files;
    }

    public String getFlow() {
        return this.flow;
    }

    public String getTicketId() {
        return this.ticketId;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public String getCreatorAvatar() {
        return this.creatorAvatar;
    }

    public Owner getOwner() {
        return this.owner;
    }

    public String getAttachedJira() {
        return this.attachedJira;
    }

    public Calendar getFirstWarningDate() {
        return this.firstWarningDate;
    }

    public Calendar getLastWarningDate() {
        return this.lastWarningDate;
    }

    public String getWarning() {
        return this.warning;
    }

    public String getJiraStatus() {
        return this.jiraStatus;
    }

    public String getJiraStatusIcon() {
        return this.jiraStatusIcon;
    }

    public Long getTimeToFirstResponse() {
        return this.timeToFirstResponse;
    }

    public Long getTimeToResolution() {
        return this.timeToResolution;
    }

    public Boolean getCustomerSatisfied() {
        return this.customerSatisfied;
    }

    public Boolean getInternal() {
        return this.internal;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setSimpleDateFormat(SimpleDateFormat simpleDateFormat) {
        this.simpleDateFormat = simpleDateFormat;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public void setType(IssueType type) {
        this.type = type;
    }

    public void setSeverity(IssueSeverity severity) {
        this.severity = severity;
    }

    public void setInfoType(InfoType infoType) {
        this.infoType = infoType;
    }

    public void setSpaceGroupId(String spaceGroupId) {
        this.spaceGroupId = spaceGroupId;
    }

    public void setEnvironmentName(String environmentName) {
        this.environmentName = environmentName;
    }

    public void setEnvironmentId(Long environmentId) {
        this.environmentId = environmentId;
    }

    public void setStartDate(Calendar startDate) {
        this.startDate = startDate;
    }

    public void setEndDate(Calendar endDate) {
        this.endDate = endDate;
    }

    public void setUpdateDate(Calendar updateDate) {
        this.updateDate = updateDate;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setFiles(List<FileItem> files) {
        this.files = files;
    }

    public void setFlow(String flow) {
        this.flow = flow;
    }

    public void setTicketId(String ticketId) {
        this.ticketId = ticketId;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public void setCreatorAvatar(String creatorAvatar) {
        this.creatorAvatar = creatorAvatar;
    }

    public void setOwner(Owner owner) {
        this.owner = owner;
    }

    public void setAttachedJira(String attachedJira) {
        this.attachedJira = attachedJira;
    }

    public void setFirstWarningDate(Calendar firstWarningDate) {
        this.firstWarningDate = firstWarningDate;
    }

    public void setLastWarningDate(Calendar lastWarningDate) {
        this.lastWarningDate = lastWarningDate;
    }

    public void setWarning(String warning) {
        this.warning = warning;
    }

    public void setJiraStatus(String jiraStatus) {
        this.jiraStatus = jiraStatus;
    }

    public void setJiraStatusIcon(String jiraStatusIcon) {
        this.jiraStatusIcon = jiraStatusIcon;
    }

    public void setTimeToFirstResponse(Long timeToFirstResponse) {
        this.timeToFirstResponse = timeToFirstResponse;
    }

    public void setTimeToResolution(Long timeToResolution) {
        this.timeToResolution = timeToResolution;
    }

    public void setCustomerSatisfied(Boolean customerSatisfied) {
        this.customerSatisfied = customerSatisfied;
    }

    public void setInternal(Boolean internal) {
        this.internal = internal;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TicketDTO)) {
            return false;
        }
        TicketDTO other = (TicketDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SimpleDateFormat this$simpleDateFormat = this.getSimpleDateFormat();
        SimpleDateFormat other$simpleDateFormat = other.getSimpleDateFormat();
        if (this$simpleDateFormat == null ? other$simpleDateFormat != null : !((Object)this$simpleDateFormat).equals(other$simpleDateFormat)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$link = this.getLink();
        String other$link = other.getLink();
        if (this$link == null ? other$link != null : !this$link.equals(other$link)) {
            return false;
        }
        String this$assignee = this.getAssignee();
        String other$assignee = other.getAssignee();
        if (this$assignee == null ? other$assignee != null : !this$assignee.equals(other$assignee)) {
            return false;
        }
        String this$tagName = this.getTagName();
        String other$tagName = other.getTagName();
        if (this$tagName == null ? other$tagName != null : !this$tagName.equals(other$tagName)) {
            return false;
        }
        IssueType this$type = this.getType();
        IssueType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        IssueSeverity this$severity = this.getSeverity();
        IssueSeverity other$severity = other.getSeverity();
        if (this$severity == null ? other$severity != null : !((Object)((Object)this$severity)).equals((Object)other$severity)) {
            return false;
        }
        InfoType this$infoType = this.getInfoType();
        InfoType other$infoType = other.getInfoType();
        if (this$infoType == null ? other$infoType != null : !((Object)((Object)this$infoType)).equals((Object)other$infoType)) {
            return false;
        }
        String this$spaceGroupId = this.getSpaceGroupId();
        String other$spaceGroupId = other.getSpaceGroupId();
        if (this$spaceGroupId == null ? other$spaceGroupId != null : !this$spaceGroupId.equals(other$spaceGroupId)) {
            return false;
        }
        String this$environmentName = this.getEnvironmentName();
        String other$environmentName = other.getEnvironmentName();
        if (this$environmentName == null ? other$environmentName != null : !this$environmentName.equals(other$environmentName)) {
            return false;
        }
        Long this$environmentId = this.getEnvironmentId();
        Long other$environmentId = other.getEnvironmentId();
        if (this$environmentId == null ? other$environmentId != null : !((Object)this$environmentId).equals(other$environmentId)) {
            return false;
        }
        Calendar this$startDate = this.getStartDate();
        Calendar other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
            return false;
        }
        Calendar this$endDate = this.getEndDate();
        Calendar other$endDate = other.getEndDate();
        if (this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate)) {
            return false;
        }
        Calendar this$updateDate = this.getUpdateDate();
        Calendar other$updateDate = other.getUpdateDate();
        if (this$updateDate == null ? other$updateDate != null : !((Object)this$updateDate).equals(other$updateDate)) {
            return false;
        }
        List<FileItem> this$files = this.getFiles();
        List<FileItem> other$files = other.getFiles();
        if (this$files == null ? other$files != null : !((Object)this$files).equals(other$files)) {
            return false;
        }
        String this$flow = this.getFlow();
        String other$flow = other.getFlow();
        if (this$flow == null ? other$flow != null : !this$flow.equals(other$flow)) {
            return false;
        }
        String this$ticketId = this.getTicketId();
        String other$ticketId = other.getTicketId();
        if (this$ticketId == null ? other$ticketId != null : !this$ticketId.equals(other$ticketId)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$creatorId = this.getCreatorId();
        String other$creatorId = other.getCreatorId();
        if (this$creatorId == null ? other$creatorId != null : !this$creatorId.equals(other$creatorId)) {
            return false;
        }
        String this$creatorAvatar = this.getCreatorAvatar();
        String other$creatorAvatar = other.getCreatorAvatar();
        if (this$creatorAvatar == null ? other$creatorAvatar != null : !this$creatorAvatar.equals(other$creatorAvatar)) {
            return false;
        }
        Owner this$owner = this.getOwner();
        Owner other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !((Object)((Object)this$owner)).equals((Object)other$owner)) {
            return false;
        }
        String this$attachedJira = this.getAttachedJira();
        String other$attachedJira = other.getAttachedJira();
        if (this$attachedJira == null ? other$attachedJira != null : !this$attachedJira.equals(other$attachedJira)) {
            return false;
        }
        Calendar this$firstWarningDate = this.getFirstWarningDate();
        Calendar other$firstWarningDate = other.getFirstWarningDate();
        if (this$firstWarningDate == null ? other$firstWarningDate != null : !((Object)this$firstWarningDate).equals(other$firstWarningDate)) {
            return false;
        }
        Calendar this$lastWarningDate = this.getLastWarningDate();
        Calendar other$lastWarningDate = other.getLastWarningDate();
        if (this$lastWarningDate == null ? other$lastWarningDate != null : !((Object)this$lastWarningDate).equals(other$lastWarningDate)) {
            return false;
        }
        String this$warning = this.getWarning();
        String other$warning = other.getWarning();
        if (this$warning == null ? other$warning != null : !this$warning.equals(other$warning)) {
            return false;
        }
        String this$jiraStatus = this.getJiraStatus();
        String other$jiraStatus = other.getJiraStatus();
        if (this$jiraStatus == null ? other$jiraStatus != null : !this$jiraStatus.equals(other$jiraStatus)) {
            return false;
        }
        String this$jiraStatusIcon = this.getJiraStatusIcon();
        String other$jiraStatusIcon = other.getJiraStatusIcon();
        if (this$jiraStatusIcon == null ? other$jiraStatusIcon != null : !this$jiraStatusIcon.equals(other$jiraStatusIcon)) {
            return false;
        }
        Long this$timeToFirstResponse = this.getTimeToFirstResponse();
        Long other$timeToFirstResponse = other.getTimeToFirstResponse();
        if (this$timeToFirstResponse == null ? other$timeToFirstResponse != null : !((Object)this$timeToFirstResponse).equals(other$timeToFirstResponse)) {
            return false;
        }
        Long this$timeToResolution = this.getTimeToResolution();
        Long other$timeToResolution = other.getTimeToResolution();
        if (this$timeToResolution == null ? other$timeToResolution != null : !((Object)this$timeToResolution).equals(other$timeToResolution)) {
            return false;
        }
        Boolean this$customerSatisfied = this.getCustomerSatisfied();
        Boolean other$customerSatisfied = other.getCustomerSatisfied();
        if (this$customerSatisfied == null ? other$customerSatisfied != null : !((Object)this$customerSatisfied).equals(other$customerSatisfied)) {
            return false;
        }
        Boolean this$internal = this.getInternal();
        Boolean other$internal = other.getInternal();
        if (this$internal == null ? other$internal != null : !((Object)this$internal).equals(other$internal)) {
            return false;
        }
        Boolean this$active = this.getActive();
        Boolean other$active = other.getActive();
        return !(this$active == null ? other$active != null : !((Object)this$active).equals(other$active));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TicketDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SimpleDateFormat $simpleDateFormat = this.getSimpleDateFormat();
        result = result * 59 + ($simpleDateFormat == null ? 43 : ((Object)$simpleDateFormat).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $link = this.getLink();
        result = result * 59 + ($link == null ? 43 : $link.hashCode());
        String $assignee = this.getAssignee();
        result = result * 59 + ($assignee == null ? 43 : $assignee.hashCode());
        String $tagName = this.getTagName();
        result = result * 59 + ($tagName == null ? 43 : $tagName.hashCode());
        IssueType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        IssueSeverity $severity = this.getSeverity();
        result = result * 59 + ($severity == null ? 43 : ((Object)((Object)$severity)).hashCode());
        InfoType $infoType = this.getInfoType();
        result = result * 59 + ($infoType == null ? 43 : ((Object)((Object)$infoType)).hashCode());
        String $spaceGroupId = this.getSpaceGroupId();
        result = result * 59 + ($spaceGroupId == null ? 43 : $spaceGroupId.hashCode());
        String $environmentName = this.getEnvironmentName();
        result = result * 59 + ($environmentName == null ? 43 : $environmentName.hashCode());
        Long $environmentId = this.getEnvironmentId();
        result = result * 59 + ($environmentId == null ? 43 : ((Object)$environmentId).hashCode());
        Calendar $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
        Calendar $endDate = this.getEndDate();
        result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
        Calendar $updateDate = this.getUpdateDate();
        result = result * 59 + ($updateDate == null ? 43 : ((Object)$updateDate).hashCode());
        List<FileItem> $files = this.getFiles();
        result = result * 59 + ($files == null ? 43 : ((Object)$files).hashCode());
        String $flow = this.getFlow();
        result = result * 59 + ($flow == null ? 43 : $flow.hashCode());
        String $ticketId = this.getTicketId();
        result = result * 59 + ($ticketId == null ? 43 : $ticketId.hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $creatorId = this.getCreatorId();
        result = result * 59 + ($creatorId == null ? 43 : $creatorId.hashCode());
        String $creatorAvatar = this.getCreatorAvatar();
        result = result * 59 + ($creatorAvatar == null ? 43 : $creatorAvatar.hashCode());
        Owner $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : ((Object)((Object)$owner)).hashCode());
        String $attachedJira = this.getAttachedJira();
        result = result * 59 + ($attachedJira == null ? 43 : $attachedJira.hashCode());
        Calendar $firstWarningDate = this.getFirstWarningDate();
        result = result * 59 + ($firstWarningDate == null ? 43 : ((Object)$firstWarningDate).hashCode());
        Calendar $lastWarningDate = this.getLastWarningDate();
        result = result * 59 + ($lastWarningDate == null ? 43 : ((Object)$lastWarningDate).hashCode());
        String $warning = this.getWarning();
        result = result * 59 + ($warning == null ? 43 : $warning.hashCode());
        String $jiraStatus = this.getJiraStatus();
        result = result * 59 + ($jiraStatus == null ? 43 : $jiraStatus.hashCode());
        String $jiraStatusIcon = this.getJiraStatusIcon();
        result = result * 59 + ($jiraStatusIcon == null ? 43 : $jiraStatusIcon.hashCode());
        Long $timeToFirstResponse = this.getTimeToFirstResponse();
        result = result * 59 + ($timeToFirstResponse == null ? 43 : ((Object)$timeToFirstResponse).hashCode());
        Long $timeToResolution = this.getTimeToResolution();
        result = result * 59 + ($timeToResolution == null ? 43 : ((Object)$timeToResolution).hashCode());
        Boolean $customerSatisfied = this.getCustomerSatisfied();
        result = result * 59 + ($customerSatisfied == null ? 43 : ((Object)$customerSatisfied).hashCode());
        Boolean $internal = this.getInternal();
        result = result * 59 + ($internal == null ? 43 : ((Object)$internal).hashCode());
        Boolean $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        return result;
    }

    public String toString() {
        return "TicketDTO(simpleDateFormat=" + this.getSimpleDateFormat() + ", id=" + this.getId() + ", title=" + this.getTitle() + ", status=" + this.getStatus() + ", description=" + this.getDescription() + ", link=" + this.getLink() + ", assignee=" + this.getAssignee() + ", tagName=" + this.getTagName() + ", type=" + (Object)((Object)this.getType()) + ", severity=" + (Object)((Object)this.getSeverity()) + ", infoType=" + (Object)((Object)this.getInfoType()) + ", spaceGroupId=" + this.getSpaceGroupId() + ", environmentName=" + this.getEnvironmentName() + ", environmentId=" + this.getEnvironmentId() + ", startDate=" + this.getStartDate() + ", endDate=" + this.getEndDate() + ", updateDate=" + this.getUpdateDate() + ", dateFormat=" + this.getDateFormat() + ", files=" + this.getFiles() + ", flow=" + this.getFlow() + ", ticketId=" + this.getTicketId() + ", creator=" + this.getCreator() + ", creatorId=" + this.getCreatorId() + ", creatorAvatar=" + this.getCreatorAvatar() + ", owner=" + (Object)((Object)this.getOwner()) + ", attachedJira=" + this.getAttachedJira() + ", firstWarningDate=" + this.getFirstWarningDate() + ", lastWarningDate=" + this.getLastWarningDate() + ", warning=" + this.getWarning() + ", jiraStatus=" + this.getJiraStatus() + ", jiraStatusIcon=" + this.getJiraStatusIcon() + ", timeToFirstResponse=" + this.getTimeToFirstResponse() + ", timeToResolution=" + this.getTimeToResolution() + ", customerSatisfied=" + this.getCustomerSatisfied() + ", internal=" + this.getInternal() + ", active=" + this.getActive() + ")";
    }
}

