/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.dao;

import java.util.Calendar;
import java.util.List;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.cs.entity.StatLogEntity;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class StatLogDAO
extends GenericDAOJPAImpl<StatLogEntity, Long> {
    private static final Logger LOG = LoggerFactory.getLogger(StatLogDAO.class);

    public List<StatLogEntity> getAllStatsByType(String type) throws Exception {
        return this.getEntityManager().createNamedQuery("statLogEntity.getAllStatsByType", StatLogEntity.class).setParameter("statType", (Object)type).getResultList();
    }

    public List<StatLogEntity> getWeeklyStatsByType(String type) throws Exception {
        return this.getEntityManager().createNamedQuery("statLogEntity.getWeeklyStatsByType", StatLogEntity.class).setParameter("statType", (Object)type).getResultList();
    }

    public List<StatLogEntity> getMonthlyStatsByType(String type) throws Exception {
        return this.getEntityManager().createNamedQuery("statLogEntity.getMonthlyStatsByType", StatLogEntity.class).setParameter("statType", (Object)type).getResultList();
    }

    public List<StatLogEntity> getAllStatsByTypeAndDates(String type, Calendar from, Calendar to) throws Exception {
        return this.getEntityManager().createNamedQuery("statLogEntity.getAllStatsByTypeAndDates", StatLogEntity.class).setParameter("statType", (Object)type).setParameter("from", (Object)from).setParameter("to", (Object)to).getResultList();
    }

    public List<StatLogEntity> getWeeklyStatsByTypeAndDates(String type, Calendar from, Calendar to) throws Exception {
        return this.getEntityManager().createNamedQuery("statLogEntity.getWeeklyStatsByTypeAndDates", StatLogEntity.class).setParameter("statType", (Object)type).setParameter("from", (Object)from).setParameter("to", (Object)to).getResultList();
    }

    public List<StatLogEntity> getMonthlyStatsByTypeAndDates(String type, Calendar from, Calendar to) throws Exception {
        return this.getEntityManager().createNamedQuery("statLogEntity.getMonthlyStatsByTypeAndDates", StatLogEntity.class).setParameter("statType", (Object)type).setParameter("from", (Object)from).setParameter("to", (Object)to).getResultList();
    }

    public List<StatLogEntity> getStatsByTypeAndDate(String type, Calendar statDate) throws Exception {
        return this.getEntityManager().createNamedQuery("statLogEntity.getStatsByTypeAndDate", StatLogEntity.class).setParameter("statType", (Object)type).setParameter("statDate", (Object)statDate).getResultList();
    }
}

