/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.RuntimeDelegate;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.cs.dao.LogDAO;
import org.exoplatform.cs.entity.LogEntity;
import org.exoplatform.cs.entity.TopicEntity;
import org.exoplatform.cs.service.TicketService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.impl.RuntimeDelegateImpl;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="customerspace")
public class TicketUpdatesService
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(TicketUpdatesService.class);
    private static final CacheControl cc;
    private static final String PATTERN = "dd-MM-yyyy HH:mm:ss Z";
    private static final SimpleDateFormat sdf;

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="cstickets/updates.json")
    @Produces(value={"application/json"})
    public Response getUpdates(@Context UriInfo uriInfo, @QueryParam(value="from") String from, @QueryParam(value="to") String to) {
        TicketService ticketService = TicketUpdatesService.getService(TicketService.class, null);
        LogDAO logDAO = TicketUpdatesService.getService(LogDAO.class, null);
        String DATE_FORMAT = "dd-MM-yyyy";
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
        Calendar fromDate = Calendar.getInstance();
        Calendar toDate = Calendar.getInstance();
        try {
            if (from != null && !from.isEmpty()) {
                fromDate.setTime(df.parse(from));
            } else {
                fromDate.add(2, -1);
            }
            if (to != null && !to.isEmpty()) {
                toDate.setTime(df.parse(to));
            }
        }
        catch (ParseException e) {
            LOG.error("Start and End Date format should be {}", new Object[]{DATE_FORMAT});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        List<LogEntity> updates = logDAO.getupdates(fromDate, toDate);
        String response = this.buildJsonArrayOfUpdates(updates);
        return Response.ok((Object)response, (String)"application/json").cacheControl(cc).build();
    }

    private String buildJsonArrayOfUpdates(List<LogEntity> updatesList) {
        JSONArray ticketsJSON = new JSONArray();
        HashMap<TopicEntity, List> updatesMap = new HashMap<TopicEntity, List>();
        for (LogEntity logEntity : updatesList) {
            updatesMap.computeIfAbsent(logEntity.getTopic(), k -> new ArrayList()).add(logEntity);
        }
        updatesMap.forEach((k, v) -> {
            JSONObject ticketJSON = new JSONObject();
            try {
                ticketJSON.put("ticket", (Object)this.buildJsonObject((TopicEntity)k));
                for (LogEntity entity : v) {
                    JSONObject update = new JSONObject();
                    update.put("id", (Object)entity.getTopic().getId());
                    update.put("topicTitle", (Object)entity.getTopic().getTitle());
                    update.put("updater", (Object)entity.getUserID());
                    update.put("updateType", (Object)entity.getType().name());
                    update.put("oldValue", (Object)entity.getOriginalValue());
                    update.put("newValue", (Object)entity.getNewValue());
                    update.put("when", (Object)sdf.format(entity.getWhen().getTime()));
                    ticketJSON.append("updates", (Object)update);
                }
                ticketsJSON.put((Object)ticketJSON);
            }
            catch (Exception e) {
                LOG.error("A problem when building JSON for LogEntity {}", new Object[]{k.getId(), e});
            }
        });
        return ticketsJSON.toString();
    }

    public static <T> T getService(Class<T> clazz, String containerName) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (containerName != null) {
            container = RootContainer.getInstance().getPortalContainer(containerName);
        }
        if (container.getComponentInstanceOfType(clazz) == null) {
            containerName = PortalContainer.getCurrentPortalContainerName();
            container = RootContainer.getInstance().getPortalContainer(containerName);
        }
        return clazz.cast(container.getComponentInstanceOfType(clazz));
    }

    private JSONObject buildJsonObject(TopicEntity topicEntity) {
        JSONObject ticket = new JSONObject();
        try {
            ticket.put("id", (Object)topicEntity.getId());
            ticket.put("assignee", (Object)topicEntity.getAssignee());
            ticket.put("environmentName", (Object)(topicEntity.getEnvironment() != null ? topicEntity.getEnvironment().getName() : ""));
            ticket.put("infoType", (Object)(topicEntity.getInfoType() != null ? topicEntity.getInfoType().name() : ""));
            ticket.put("link", (Object)topicEntity.getLink());
            ticket.put("severity", (Object)(topicEntity.getSeverity() != null ? topicEntity.getSeverity().name() : ""));
            ticket.put("spaceGroupId", (Object)topicEntity.getSpace().getGroupId());
            ticket.put("title", (Object)topicEntity.getTitle());
            ticket.put("type", (Object)(topicEntity.getType() != null ? topicEntity.getType().name() : ""));
            ticket.put("status", (Object)topicEntity.getStatus());
            ticket.put("updateDate", (Object)sdf.format(topicEntity.getUpdateDate().getTime()));
        }
        catch (JSONException jsonException) {
            LOG.error("A problem when building JSON for ticket {}", new Object[]{topicEntity.getId()});
        }
        return ticket;
    }

    private String buildJsonArray(List<TopicEntity> ticketDTOS) {
        JSONArray array = new JSONArray();
        for (TopicEntity ticketDTO : ticketDTOS) {
            JSONObject ticket = this.buildJsonObject(ticketDTO);
            array.put((Object)ticket);
        }
        return array.toString();
    }

    static {
        sdf = new SimpleDateFormat(PATTERN);
        RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
        cc = new CacheControl();
        cc.setNoCache(true);
        cc.setNoStore(true);
    }
}

