package org.exoplatform.cs.service.listener;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.exoplatform.container.PortalContainer;
import org.exoplatform.cs.service.CSSpaceService;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;

public class DeleteSpaceListener extends SpaceListenerPlugin {
  private static final Logger LOG = LoggerFactory.getLogger(DeleteSpaceListener.class);

  @Override
  public void spaceAccessEdited(SpaceLifeCycleEvent event) {
  }

  @Override
  public void spaceCreated(SpaceLifeCycleEvent event) {
  }

  @Override
  public void spaceRemoved(SpaceLifeCycleEvent event) {
    String spaceType = event.getSpace().getType();
    if (spaceType.equals("CSSpace")) {
      CSSpaceService csSpaceService = PortalContainer.getInstance().getComponentInstanceOfType(CSSpaceService.class);
      try {
        csSpaceService.removeSpace(event.getSpace().getGroupId());
      } catch (Exception e) {
        LOG.error("Error while deleting space" + event.getSpace().getGroupId(), e);
      }
    }
  }

  @Override
  public void applicationActivated(SpaceLifeCycleEvent event) {
  }

  @Override
  public void applicationAdded(SpaceLifeCycleEvent event) {
  }

  @Override
  public void applicationDeactivated(SpaceLifeCycleEvent event) {
  }

  @Override
  public void applicationRemoved(SpaceLifeCycleEvent event) {
  }

  @Override
  public void grantedLead(SpaceLifeCycleEvent event) {
  }

  @Override
  public void joined(SpaceLifeCycleEvent event) {
  }

  @Override
  public void left(SpaceLifeCycleEvent event) {
  }

  @Override
  public void revokedLead(SpaceLifeCycleEvent event) {
  }

  @Override
  public void spaceRenamed(SpaceLifeCycleEvent event) {
  }

  @Override
  public void spaceDescriptionEdited(SpaceLifeCycleEvent event) {
  }

  @Override
  public void spaceAvatarEdited(SpaceLifeCycleEvent event) {
  }

  @Override
  public void addInvitedUser(SpaceLifeCycleEvent event) {
  }

  @Override
  public void addPendingUser(SpaceLifeCycleEvent event) {
  }

  @Override
  public void spaceRegistrationEdited(SpaceLifeCycleEvent event) {

  }

  @Override
  public void spaceBannerEdited(SpaceLifeCycleEvent spaceLifeCycleEvent) {
    
  }

}
